/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.tsmodel.application.provider;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.metamodel.webdynpro.model.ModelClass;
import com.sap.ide.webdynpro.service.core.MetamodelServices;
import com.sap.ide.webdynpro.service.modeleditor.ServiceWithUI;
import com.sap.ide.webdynpro.tsmodel.application.plugin.TsmodelWebDynproPlugin;
import com.sap.ide.webdynpro.tsmodel.application.provider.DataSourceManager;
import com.sap.ide.webdynpro.tsmodel.application.provider.GenericModelAware;
import com.sap.ide.webdynpro.tsmodel.application.provider.Utils;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.ChildrenProvider;
import com.tssap.selena.model.extension.EntityExistenceProvider;
import com.tssap.selena.model.extension.ParentProvider;
import com.tssap.selena.model.util.EnumerationConverter;
import java.util.ArrayList;
import java.util.Collections;

public class ModelClassNodeProvider
extends GenericModelAware
implements EntityExistenceProvider,
ChildrenProvider,
ParentProvider {
    public boolean canCreateUniqueName(Entity parent, String shapeType, Entity template) {
        if (!Utils.uniqueNameHasSubdomain((Element)parent, "ModelClasses") || !shapeType.equals("WDModelClass")) {
            return false;
        }
        DevelopmentObject developmentObject = this.mDataSourceManager.getDevelopmentObject(parent.getUniqueName());
        if (!(developmentObject instanceof Model)) {
            return false;
        }
        Model model = (Model)developmentObject;
        boolean result = MetamodelServices.canCreateModelClass((Model)model);
        return result;
    }

    public UniqueName createUniqueName(Entity parent, String shapeType, Entity template) {
        ModelClass modelClass = null;
        DevelopmentObject developmentObject = this.mDataSourceManager.getDevelopmentObject(parent.getUniqueName());
        if (!(developmentObject instanceof Model)) {
            TsmodelWebDynproPlugin.internalError(this.getClass(), "createUniqueName", "parent has wrong type", null, false);
            return null;
        }
        Model parentModel = (Model)developmentObject;
        modelClass = ServiceWithUI.createModelClass((Model)parentModel);
        if (modelClass != null) {
            this.mDataSourceManager.commitChanges();
            return DataSourceManager.createUniqueName((DevelopmentObject)modelClass, "ModelClass");
        }
        return null;
    }

    public boolean exists(UniqueName uniqueName) {
        return Utils.exists(this.mDataSourceManager, uniqueName, "ModelClass");
    }

    public boolean isDeleteProviderApplicable(Element element) {
        if (element instanceof Entity) {
            return this.exists(element.getUniqueName());
        }
        return false;
    }

    public boolean canDelete(Element element) {
        DevelopmentObject developmentObject = this.mDataSourceManager.getDevelopmentObject(element.getUniqueName());
        if (!(developmentObject instanceof ModelClass)) {
            return false;
        }
        ModelClass modelClass = (ModelClass)developmentObject;
        boolean deletable = MetamodelServices.isModelClassDeletable((ModelClass)modelClass);
        return deletable;
    }

    public void delete(Element element) {
        DevelopmentObject developmentObject = this.mDataSourceManager.getDevelopmentObject(element.getUniqueName());
        if (!(developmentObject instanceof ModelClass)) {
            return;
        }
        ModelClass modelClass = (ModelClass)developmentObject;
        ServiceWithUI.deleteModelClass((ModelClass)modelClass);
    }

    public boolean isDeleted(Element element) {
        return !this.exists(element.getUniqueName());
    }

    public boolean isChildrenProviderApplicable(Entity parent) {
        return Utils.uniqueNameHasSubdomain((Element)parent, "ModelClasses");
    }

    public UniqueNameEnumeration children(Entity parent) {
        DevelopmentObject developmentObject = this.mDataSourceManager.getDevelopmentObject(parent.getUniqueName());
        if (!(developmentObject instanceof Model)) {
            TsmodelWebDynproPlugin.internalError(this.getClass(), "children", "parent has wrong type: ", null, false);
            return null;
        }
        Model model = (Model)developmentObject;
        ArrayList<UniqueName> list = new ArrayList<UniqueName>();
        ModelClass[] modelClasses = model.getModelClasses();
        int i = 0;
        while (i < modelClasses.length) {
            ModelClass modelClass = modelClasses[i];
            UniqueName uniqueName = DataSourceManager.createUniqueName((DevelopmentObject)modelClass, "ModelClass");
            list.add(uniqueName);
            ++i;
        }
        return EnumerationConverter.toUniqueNameEnumeration(Collections.enumeration(list));
    }

    public UniqueName getParentUniqueName(Element child) {
        if (this.exists(child.getUniqueName())) {
            ModelClass modelClass = (ModelClass)this.mDataSourceManager.getDevelopmentObject(child.getUniqueName());
            if (modelClass == null) {
                return null;
            }
            Model model = (Model)modelClass.getParent();
            if (model != null) {
                return DataSourceManager.createUniqueName((DevelopmentObject)model, "Model");
            }
        }
        return null;
    }
}

