/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.tsmodel.application.provider;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterfaceDefinition;
import com.sap.ide.metamodel.webdynpro.component.view.InterfaceView;
import com.sap.ide.webdynpro.service.applicationmodeler.CreationWithUI;
import com.sap.ide.webdynpro.service.controllereditor.ServiceWithUI;
import com.sap.ide.webdynpro.tsmodel.application.plugin.TsmodelWebDynproPlugin;
import com.sap.ide.webdynpro.tsmodel.application.provider.DataSourceManager;
import com.sap.ide.webdynpro.tsmodel.application.provider.GenericModelAware;
import com.sap.ide.webdynpro.tsmodel.application.provider.InterfaceViewDefinitionsNodeProvider;
import com.sap.ide.webdynpro.tsmodel.application.provider.Utils;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.ChildrenProvider;
import com.tssap.selena.model.extension.EntityExistenceProvider;
import com.tssap.selena.model.extension.ParentProvider;
import com.tssap.selena.model.util.EnumerationConverter;
import java.util.ArrayList;
import java.util.Collections;

public class InterfaceViewDefinitionNodeProvider
extends GenericModelAware
implements EntityExistenceProvider,
ChildrenProvider,
ParentProvider {
    public boolean canCreateUniqueName(Entity parent, String shapeType, Entity template) {
        return Utils.uniqueNameHasSubdomain((Element)parent, "InterfaceViewDefinitions") && shapeType.equals("WDInterfaceViewDefinition");
    }

    public UniqueName createUniqueName(Entity parent, String shapeType, Entity template) {
        InterfaceView interfaceView = null;
        DevelopmentObject developmentObject = this.mDataSourceManager.getDevelopmentObject(parent.getUniqueName());
        if (!(developmentObject instanceof ComponentInterfaceDefinition)) {
            TsmodelWebDynproPlugin.internalError(this.getClass(), "createUniqueName", "parent has wrong type", null, false);
            return null;
        }
        ComponentInterfaceDefinition parentComponentInterface = (ComponentInterfaceDefinition)developmentObject;
        interfaceView = CreationWithUI.createInterfaceView((ComponentInterfaceDefinition)parentComponentInterface);
        if (interfaceView != null) {
            this.mDataSourceManager.commitChanges();
            return DataSourceManager.createUniqueName((DevelopmentObject)interfaceView, "InterfaceView");
        }
        return null;
    }

    public boolean exists(UniqueName uniqueName) {
        return Utils.exists(this.mDataSourceManager, uniqueName, "InterfaceViewDefinition");
    }

    public boolean isDeleteProviderApplicable(Element element) {
        if (element instanceof Entity) {
            return this.exists(element.getUniqueName());
        }
        return false;
    }

    public boolean canDelete(Element element) {
        return true;
    }

    public void delete(Element element) {
        DevelopmentObject developmentObject = this.mDataSourceManager.getDevelopmentObject(element.getUniqueName());
        InterfaceView interfaceView = null;
        if (developmentObject instanceof InterfaceView) {
            interfaceView = (InterfaceView)developmentObject;
        }
        if (interfaceView != null) {
            ServiceWithUI.deleteInterfaceView((InterfaceView)interfaceView);
            this.mDataSourceManager.commitChanges();
        } else {
            TsmodelWebDynproPlugin.internalError(this.getClass(), "delete", "InterfaceView not found", null, false);
        }
    }

    public boolean isDeleted(Element element) {
        return !this.exists(element.getUniqueName());
    }

    public boolean isChildrenProviderApplicable(Entity parent) {
        return Utils.uniqueNameHasSubdomain((Element)parent, "InterfaceViewDefinitions");
    }

    public UniqueNameEnumeration children(Entity parent) {
        ComponentInterfaceDefinition componentInterfaceDefinition = (ComponentInterfaceDefinition)this.mDataSourceManager.getDevelopmentObject(parent.getUniqueName());
        ArrayList<UniqueName> list = new ArrayList<UniqueName>();
        InterfaceView[] interfaceViews = componentInterfaceDefinition.getInterfaceViews();
        int i = 0;
        while (i < interfaceViews.length) {
            UniqueName uniqueName = DataSourceManager.createUniqueName((DevelopmentObject)interfaceViews[i], "InterfaceViewDefinition");
            list.add(uniqueName);
            ++i;
        }
        return EnumerationConverter.toUniqueNameEnumeration(Collections.enumeration(list));
    }

    public UniqueName getParentUniqueName(Element child) {
        if (!this.exists(child.getUniqueName())) {
            return null;
        }
        InterfaceView view = (InterfaceView)this.mDataSourceManager.getDevelopmentObject(child.getUniqueName());
        if (view == null) {
            return null;
        }
        ComponentInterfaceDefinition componentInterfaceDefinition = (ComponentInterfaceDefinition)view.getParent();
        if (componentInterfaceDefinition == null) {
            return null;
        }
        UniqueName uniqueName = InterfaceViewDefinitionsNodeProvider.createUniqueName(componentInterfaceDefinition);
        return uniqueName;
    }
}

