/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.tsmodel.application.provider;

import com.sap.ide.metamodel.core.repository.MMRepositoryObject;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.webdynpro.repository.MMRepositoryObjectProvider;
import com.sap.ide.webdynpro.tsmodel.application.provider.GenericModelAware;
import com.tssap.dii.dtri.DtriCheckedObjects;
import com.tssap.dii.dtri.DtriRelevantObjects;
import com.tssap.dii.dtri.DtriUtil;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.extension.ObjectPropertyProvider;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class DtrInfoProvider
extends GenericModelAware
implements ObjectPropertyProvider {
    IFile getFile(IProject project, DevelopmentObject developmentObject) {
        IPath location;
        String absolutePath = developmentObject.getMDO().getAbsolutePath();
        Path path = new Path(absolutePath);
        int nrOfMatchingSegments = path.matchingFirstSegments(location = project.getLocation());
        if (nrOfMatchingSegments <= 0) {
            return null;
        }
        IPath lPath = path.removeFirstSegments(nrOfMatchingSegments);
        IFile file = project.getFile(lPath);
        if (file.exists()) {
            return file;
        }
        return null;
    }

    private void getAndAddFile(IProject project, DevelopmentObject developmentObject, List files) {
        IFile file = this.getFile(project, developmentObject);
        if (file != null) {
            files.add(file);
        }
    }

    public Object getObjectPropertyValue(Element element, String propertyName) {
        DevelopmentObject developmentObject = this.mDataSourceManager.getDevelopmentObject(element.getUniqueName());
        DtriRelevantObjects result = null;
        if (propertyName.equals("ObjectPropertyName_DtrRelevantObjects")) {
            DtriCheckedObjects dtrCheckedObjects;
            String projectName = element.getModel().getUniqueName().getName();
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            if (project == null) {
                return null;
            }
            ArrayList files = new ArrayList();
            this.getFiles(project, developmentObject, files);
            if (!files.isEmpty() && (dtrCheckedObjects = DtriUtil.getDtrCheckedObjects(files)).hasDtrRelevantObjects()) {
                result = new DtriRelevantObjects(dtrCheckedObjects.getDtrRelevantObjectList());
            }
        }
        return result;
    }

    private void getFiles(IProject project, DevelopmentObject developmentObject, List files) {
        MMRepositoryObject repositoryObject = null;
        if (!(developmentObject instanceof MainDevelopmentObject)) {
            return;
        }
        MainDevelopmentObject mdo = (MainDevelopmentObject)developmentObject;
        repositoryObject = MMRepositoryObjectProvider.getInstance().getRepositoryObject(mdo, false);
        if (repositoryObject != null) {
            this.addFiles(repositoryObject, files);
        }
    }

    private void addFiles(MMRepositoryObject repositoryObject, List fileList) {
        IFile[] files = repositoryObject.getFiles();
        int i = 0;
        while (i < files.length) {
            IFile file = files[i];
            if (file.exists()) {
                fileList.add(file);
            }
            ++i;
        }
    }

    public Enumeration objectPropertyValues(Element element, String propertyName) {
        return null;
    }

    public boolean canSetObjectPropertyValue(Element element, String propertyName, Object propertyValue) {
        return false;
    }

    public void setObjectPropertyValue(Element element, String propertyName, Object propertyValue) {
    }

    public boolean isPropertyProviderApplicable(Element element, String propertyName) {
        return true;
    }
}

