/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.tsmodel.application.provider;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.webdynpro.tsmodel.application.plugin.TsmodelWebDynproPlugin;
import com.sap.ide.webdynpro.tsmodel.application.provider.BasePropertyProvider;
import com.sap.ide.webdynpro.tsmodel.application.provider.Utils;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.enum.PropertyEnumeration;
import com.tssap.selena.model.extension.PropertySetProvider;
import com.tssap.selena.model.util.EnumerationConverter;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;

public class DiagramFilePathPropertyProvider
extends BasePropertyProvider
implements PropertySetProvider {
    public boolean isPropertyProviderApplicable(Element element, String propertyName) {
        return true;
    }

    public PropertyEnumeration properties(Element element) {
        ArrayList<Property> list = new ArrayList<Property>();
        list.add(this.getProperty(element, "diagramFilePath"));
        return EnumerationConverter.toPropertyEnumeration(Collections.enumeration(list));
    }

    public String getPropertyValue(Element element, String propertyName) {
        DevelopmentObject developmentObject = this.mDataSourceManager.getDevelopmentObject(element.getUniqueName());
        if (developmentObject == null) {
            return null;
        }
        if (!(developmentObject instanceof MainDevelopmentObject)) {
            TsmodelWebDynproPlugin.internalError(this.getClass(), "getPropertyValue", "developmentObject is no MainDevelopmentObject: " + developmentObject.toString(), null, false);
            return null;
        }
        MainDevelopmentObject mainDevelopmentObject = (MainDevelopmentObject)developmentObject;
        if (propertyName.equals("diagramFilePath")) {
            IPath path = Utils.getDiagramFilePath(mainDevelopmentObject);
            if (path == null) {
                return null;
            }
            String projectName = mainDevelopmentObject.getRoot().getMetamodel().getName();
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            IFile file = project.getFile(path);
            if (file == null || !file.exists()) {
                return null;
            }
            return file.getLocation().toOSString();
        }
        return null;
    }

    public boolean canSetPropertyValue(Element element, String propertyName, String propertyValue) {
        return false;
    }

    public boolean canAddProperty(Element element, String propertyName, String propertyValue) {
        return false;
    }

    public void setPropertyValue(Element element, String propertyName, String propertyValue) {
    }

    public Property addProperty(Element element, String propertyName, String propertyValue) {
        return null;
    }
}

