/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.tsmodel.application.provider;

import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.component.controller.Controller;
import com.sap.ide.metamodel.webdynpro.enum.ControllerTypeEnum;
import com.sap.ide.webdynpro.service.controllereditor.ServiceWithUI;
import com.sap.ide.webdynpro.tsmodel.application.plugin.TsmodelWebDynproPlugin;
import com.sap.ide.webdynpro.tsmodel.application.provider.CustomControllersNodeProvider;
import com.sap.ide.webdynpro.tsmodel.application.provider.DataSourceManager;
import com.sap.ide.webdynpro.tsmodel.application.provider.GenericModelAware;
import com.sap.ide.webdynpro.tsmodel.application.provider.Utils;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.ChildrenProvider;
import com.tssap.selena.model.extension.EntityExistenceProvider;
import com.tssap.selena.model.extension.ParentProvider;
import com.tssap.selena.model.util.EnumerationConverter;
import java.util.ArrayList;
import java.util.Collections;

public class CustomControllerNodeProvider
extends GenericModelAware
implements EntityExistenceProvider,
ChildrenProvider,
ParentProvider {
    public boolean canCreateUniqueName(Entity parent, String shapeType, Entity emplate) {
        return Utils.uniqueNameHasSubdomain((Element)parent, "CustomControllers") && shapeType.equals("WDCustomController");
    }

    public UniqueName createUniqueName(Entity parent, String shapeType, Entity template) {
        Component component = (Component)this.mDataSourceManager.getDevelopmentObject(parent.getUniqueName());
        Utils.storeDiagram((MainDevelopmentObject)component);
        Controller controller = ServiceWithUI.createController((Component)component);
        if (controller != null) {
            this.mDataSourceManager.commitChanges();
            MetamodelManager.saveAllMetaData((String)this.mProjectName);
            return DataSourceManager.createUniqueName((DevelopmentObject)controller, "CustomController");
        }
        return null;
    }

    public boolean exists(UniqueName uniqueName) {
        return Utils.exists(this.mDataSourceManager, uniqueName, "CustomController");
    }

    public boolean isDeleteProviderApplicable(Element element) {
        if (element instanceof Entity) {
            return this.exists(element.getUniqueName());
        }
        return false;
    }

    public boolean canDelete(Element element) {
        return true;
    }

    public void delete(Element element) {
        Controller controller = (Controller)this.mDataSourceManager.getDevelopmentObject(element.getUniqueName());
        if (controller != null) {
            Utils.storeDiagram((MainDevelopmentObject)((Component)controller.getParent()));
            ServiceWithUI.deleteController((Controller)controller);
            MetamodelManager.saveAllMetaData((String)this.mProjectName);
        } else {
            TsmodelWebDynproPlugin.internalError(this.getClass(), "delete", "controller == null", null, false);
        }
        this.mDataSourceManager.commitChanges();
    }

    public boolean isDeleted(Element element) {
        return !this.exists(element.getUniqueName());
    }

    public boolean isChildrenProviderApplicable(Entity parent) {
        return Utils.uniqueNameHasSubdomain((Element)parent, "CustomControllers");
    }

    public UniqueNameEnumeration children(Entity parent) {
        Component application = (Component)this.mDataSourceManager.getDevelopmentObject(parent.getUniqueName());
        ArrayList<UniqueName> list = new ArrayList<UniqueName>();
        Controller[] controllers = application.getControllers();
        int i = 0;
        while (i < controllers.length) {
            if (controllers[i].getType().equals(ControllerTypeEnum.CUSTOM)) {
                UniqueName uniqueName = DataSourceManager.createUniqueName((DevelopmentObject)controllers[i], "CustomController");
                list.add(uniqueName);
            }
            ++i;
        }
        return EnumerationConverter.toUniqueNameEnumeration(Collections.enumeration(list));
    }

    public UniqueName getParentUniqueName(Element child) {
        if (!this.exists(child.getUniqueName())) {
            return null;
        }
        Controller controller = (Controller)this.mDataSourceManager.getDevelopmentObject(child.getUniqueName());
        if (controller == null) {
            return null;
        }
        Component application = (Component)controller.getParent();
        if (application == null) {
            return null;
        }
        UniqueName uniqueName = CustomControllersNodeProvider.createUniqueName(application);
        return uniqueName;
    }
}

