/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.tsmodel.application.provider;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.webdynpro.service.applicationmodeler.CreationWithUI;
import com.sap.ide.webdynpro.service.applicationmodeler.ServicesDeletion;
import com.sap.ide.webdynpro.tsmodel.application.plugin.TsmodelWebDynproPlugin;
import com.sap.ide.webdynpro.tsmodel.application.provider.DataSourceManager;
import com.sap.ide.webdynpro.tsmodel.application.provider.GenericModelAware;
import com.sap.ide.webdynpro.tsmodel.application.provider.StructureNodeProviderBase;
import com.sap.ide.webdynpro.tsmodel.application.provider.Utils;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.ChildrenProvider;
import com.tssap.selena.model.extension.EntityExistenceProvider;
import com.tssap.selena.model.extension.ParentProvider;
import com.tssap.selena.model.util.EnumerationConverter;
import java.util.ArrayList;
import java.util.Collections;

public class ComponentNodeProvider
extends GenericModelAware
implements EntityExistenceProvider,
ChildrenProvider,
ParentProvider {
    public boolean canCreateUniqueName(Entity parent, String shapeType, Entity template) {
        return Utils.uniqueNameHasSubdomain((Element)parent, "Components") && shapeType.equals("WDComponent");
    }

    public UniqueName createUniqueName(Entity parent, String shapeType, Entity template) {
        Model model = parent.getModel();
        if (model == null) {
            return null;
        }
        Component component = null;
        component = CreationWithUI.createComponent((WebDynproRoot)this.mDataSourceManager.getWebDynproRoot());
        if (component != null) {
            this.mDataSourceManager.commitChanges();
        }
        if (component != null) {
            return DataSourceManager.createUniqueName((DevelopmentObject)component, "Component");
        }
        return null;
    }

    public boolean exists(UniqueName uniqueName) {
        boolean exists = Utils.exists(this.mDataSourceManager, uniqueName, "Component");
        return exists;
    }

    public boolean isChildrenProviderApplicable(Entity parent) {
        return Utils.uniqueNameHasSubdomain((Element)parent, "Components");
    }

    public UniqueNameEnumeration children(Entity parent) {
        ArrayList<UniqueName> list = new ArrayList<UniqueName>();
        String projectName = parent.getUniqueName().getName();
        Component[] components = null;
        try {
            components = this.mDataSourceManager.getWebDynproRoot().getComponents();
        }
        catch (LoadException e) {
            TsmodelWebDynproPlugin.internalError(this.getClass(), "children", "LoadException", e, false);
            return null;
        }
        int i = 0;
        while (i < components.length) {
            if (!components[i].originatesInArchive()) {
                UniqueName uniqueName = DataSourceManager.createUniqueName((DevelopmentObject)components[i], "Component");
                list.add(uniqueName);
            }
            ++i;
        }
        return EnumerationConverter.toUniqueNameEnumeration(Collections.enumeration(list));
    }

    public boolean isDeleteProviderApplicable(Element element) {
        if (element instanceof Entity) {
            return this.exists(element.getUniqueName());
        }
        return false;
    }

    public boolean canDelete(Element element) {
        return true;
    }

    public void delete(Element element) {
        Component component = (Component)this.mDataSourceManager.getDevelopmentObject(element.getUniqueName());
        if (component != null) {
            ServicesDeletion.deleteComponent((Component)component);
            this.mDataSourceManager.commitChanges();
        } else {
            TsmodelWebDynproPlugin.internalError(this.getClass(), "delete", "Component is not existing", null, false);
        }
    }

    public boolean isDeleted(Element element) {
        return !this.exists(element.getUniqueName());
    }

    public UniqueName getParentUniqueName(Element child) {
        if (this.exists(child.getUniqueName())) {
            return StructureNodeProviderBase.createUniqueName("Components");
        }
        return null;
    }
}

