/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.tsmodel.application.provider;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.webdynpro.Application;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.webdynpro.service.applicationeditor.ServiceWithUI;
import com.sap.ide.webdynpro.tsmodel.application.plugin.TsmodelWebDynproPlugin;
import com.sap.ide.webdynpro.tsmodel.application.provider.DataSourceManager;
import com.sap.ide.webdynpro.tsmodel.application.provider.GenericModelAware;
import com.sap.ide.webdynpro.tsmodel.application.provider.StructureNodeProviderBase;
import com.sap.ide.webdynpro.tsmodel.application.provider.Utils;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.ChildrenProvider;
import com.tssap.selena.model.extension.EntityExistenceProvider;
import com.tssap.selena.model.extension.ParentProvider;
import com.tssap.selena.model.util.EnumerationConverter;
import java.util.ArrayList;
import java.util.Collections;

public class ApplicationNodeProvider
extends GenericModelAware
implements EntityExistenceProvider,
ChildrenProvider,
ParentProvider {
    public boolean canCreateUniqueName(Entity parent, String shapeType, Entity template) {
        return Utils.uniqueNameHasSubdomain((Element)parent, "Applications") && shapeType.equals("WDApplication");
    }

    public UniqueName createUniqueName(Entity parent, String shapeType, Entity template) {
        Model model = parent.getModel();
        if (model == null) {
            return null;
        }
        Application application = ServiceWithUI.createApplication((WebDynproRoot)this.mDataSourceManager.getWebDynproRoot());
        if (application != null) {
            this.mDataSourceManager.commitChanges();
            return DataSourceManager.createUniqueName((DevelopmentObject)application, "Application");
        }
        return null;
    }

    public boolean exists(UniqueName uniqueName) {
        boolean exists = Utils.exists(this.mDataSourceManager, uniqueName, "Application");
        return exists;
    }

    public boolean isChildrenProviderApplicable(Entity parent) {
        return Utils.uniqueNameHasSubdomain((Element)parent, "Applications");
    }

    public UniqueNameEnumeration children(Entity parent) {
        ArrayList<UniqueName> list = new ArrayList<UniqueName>();
        String projectName = parent.getUniqueName().getName();
        Application[] applications = null;
        try {
            applications = this.mDataSourceManager.getWebDynproRoot().getApplications();
        }
        catch (LoadException e) {
            TsmodelWebDynproPlugin.internalError(this.getClass(), "children", "LoadException", e, false);
            return null;
        }
        int i = 0;
        while (i < applications.length) {
            if (!applications[i].originatesInArchive()) {
                UniqueName uniqueName = DataSourceManager.createUniqueName((DevelopmentObject)applications[i], "Application");
                list.add(uniqueName);
            }
            ++i;
        }
        return EnumerationConverter.toUniqueNameEnumeration(Collections.enumeration(list));
    }

    public boolean isDeleteProviderApplicable(Element element) {
        if (element instanceof Entity) {
            return this.exists(element.getUniqueName());
        }
        return false;
    }

    public boolean canDelete(Element element) {
        return true;
    }

    public void delete(Element element) {
        Application application = (Application)this.mDataSourceManager.getDevelopmentObject(element.getUniqueName());
        if (application != null) {
            ServiceWithUI.deleteApplication((Application)application);
            this.mDataSourceManager.commitChanges();
        } else {
            TsmodelWebDynproPlugin.internalError(this.getClass(), "delete", "Application is not existing", null, false);
        }
    }

    public boolean isDeleted(Element element) {
        return !this.exists(element.getUniqueName());
    }

    public UniqueName getParentUniqueName(Element child) {
        if (this.exists(child.getUniqueName())) {
            return StructureNodeProviderBase.createUniqueName("Applications");
        }
        return null;
    }
}

