/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.tsmodel.application.actions.datalink;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterface;
import com.sap.ide.metamodel.webdynpro.component.ComponentInterfaceImplementation;
import com.sap.ide.metamodel.webdynpro.component.ComponentUsage;
import com.sap.ide.webdynpro.tsmodel.application.actions.BaseAction;
import com.sap.ide.webdynpro.tsmodel.application.actions.datalink.OpenDataViewAction;
import com.sap.ide.webdynpro.tsmodel.application.plugin.TsmodelWebDynproPlugin;
import com.sap.ide.webdynpro.tsmodel.application.provider.DataSourceManager;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;

public class OpenDataViewForUsedComponentAction
extends BaseAction {
    private BaseAction mOpenDataViewAction = new OpenDataViewAction();

    public boolean isEnabled(Entity componentUsageEntity) {
        Entity componentEntity = this.getComponentEntity(componentUsageEntity, true);
        return componentEntity != null && this.mOpenDataViewAction.isEnabled(componentEntity);
    }

    public boolean isAvailable(Entity componentUsageEntity) {
        return this.isEnabled(componentUsageEntity);
    }

    public void run(IAction action) {
        if (this.mEntity == null) {
            return;
        }
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                OpenDataViewForUsedComponentAction.this.openDataViewForUsedComponent(OpenDataViewForUsedComponentAction.this.mEntity);
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(runnable, null);
        }
        catch (CoreException e) {
            TsmodelWebDynproPlugin.internalError(this.getClass(), "run", "run failed", e, false);
        }
    }

    private void openDataViewForUsedComponent(Entity componentUsageEntity) {
        Entity componentEntity = this.getComponentEntity(componentUsageEntity, false);
        if (componentEntity != null) {
            this.mOpenDataViewAction.setSelectedEntity(componentEntity);
            this.mOpenDataViewAction.run(null);
        }
    }

    private Entity getComponentEntity(Entity componentUsageEntity, boolean onlyLogErrors) {
        String projectName = componentUsageEntity.getModel().getUniqueName().getName();
        DataSourceManager sourceManager = DataSourceManager.getDataSourceManager(projectName);
        if (sourceManager == null) {
            TsmodelWebDynproPlugin.internalError(this.getClass(), "getComponentEntity", "no data source manager found", null, onlyLogErrors);
            return null;
        }
        DevelopmentObject object = sourceManager.findDevelopmentObject(componentUsageEntity.getUniqueName());
        if (!(object instanceof ComponentUsage)) {
            TsmodelWebDynproPlugin.internalError(this.getClass(), "getComponentEntity", "found object is not a component usage", null, onlyLogErrors);
            return null;
        }
        ComponentUsage usage = (ComponentUsage)object;
        ComponentInterface usedComponentInterface = usage.getUsedComponent();
        if (usedComponentInterface == null) {
            return null;
        }
        if (!(usedComponentInterface instanceof ComponentInterfaceImplementation)) {
            return null;
        }
        ComponentInterfaceImplementation impl = (ComponentInterfaceImplementation)usedComponentInterface;
        Component component = impl.getComponent();
        UniqueName compUIN = DataSourceManager.createUniqueName((DevelopmentObject)component, "Component");
        Entity componentEntity = componentUsageEntity.getModel().findEntity(compUIN);
        if (componentEntity == null) {
            TsmodelWebDynproPlugin.internalError(this.getClass(), "getComponentEntity", "no entity for component found", null, onlyLogErrors);
            return null;
        }
        return componentEntity;
    }
}

