/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.tsmodel.application.actions.datalink;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.Application;
import com.sap.ide.metamodel.webdynpro.component.Component;
import com.sap.ide.webdynpro.tsmodel.application.actions.BaseAction;
import com.sap.ide.webdynpro.tsmodel.application.actions.datalink.OpenDataViewAction;
import com.sap.ide.webdynpro.tsmodel.application.plugin.TsmodelWebDynproPlugin;
import com.sap.ide.webdynpro.tsmodel.application.provider.DataSourceManager;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;

public class OpenDataViewForApplicationAction
extends BaseAction {
    private BaseAction mOpenDataViewAction = new OpenDataViewAction();

    public boolean isEnabled(Entity applicationEntity) {
        Entity componentEntity = this.getComponentEntity(applicationEntity, true);
        return componentEntity != null && this.mOpenDataViewAction.isEnabled(componentEntity);
    }

    public void run(IAction action) {
        if (this.mEntity == null) {
            return;
        }
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                OpenDataViewForApplicationAction.this.openDataViewForUsedComponent(OpenDataViewForApplicationAction.this.mEntity);
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(runnable, null);
        }
        catch (CoreException e) {
            TsmodelWebDynproPlugin.internalError(this.getClass(), "run", "run failed", e, false);
        }
    }

    private void openDataViewForUsedComponent(Entity applicationEntity) {
        Entity componentEntity = this.getComponentEntity(applicationEntity, false);
        if (componentEntity != null) {
            this.mOpenDataViewAction.setSelectedEntity(componentEntity);
            this.mOpenDataViewAction.run(null);
        }
    }

    private Entity getComponentEntity(Entity applicationEntity, boolean onlyLogErrors) {
        String projectName = applicationEntity.getModel().getUniqueName().getName();
        DataSourceManager sourceManager = DataSourceManager.getDataSourceManager(projectName);
        if (sourceManager == null) {
            TsmodelWebDynproPlugin.internalError(this.getClass(), "getComponentEntity", "no data source manager found", null, onlyLogErrors);
            return null;
        }
        DevelopmentObject object = sourceManager.findDevelopmentObject(applicationEntity.getUniqueName());
        if (!(object instanceof Application)) {
            TsmodelWebDynproPlugin.internalError(this.getClass(), "getComponentEntity", "found object is not an application", null, onlyLogErrors);
            return null;
        }
        Application application = (Application)object;
        Component component = application.getComponent();
        if (component == null) {
            return null;
        }
        UniqueName compUIN = DataSourceManager.createUniqueName((DevelopmentObject)component, "Component");
        Entity componentEntity = applicationEntity.getModel().findEntity(compUIN);
        if (componentEntity == null) {
            TsmodelWebDynproPlugin.internalError(this.getClass(), "getComponentEntity", "no entity for component found", null, onlyLogErrors);
            return null;
        }
        return componentEntity;
    }
}

