/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.tsmodel.application.actions.datalink;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodelsupplement.webdynpro.links.DataLink;
import com.sap.ide.webdynpro.service.controllereditor.ServiceWithUI;
import com.sap.ide.webdynpro.tsmodel.application.actions.BaseAction;
import com.sap.ide.webdynpro.tsmodel.application.plugin.TsmodelWebDynproPlugin;
import com.sap.ide.webdynpro.tsmodel.application.provider.datalink.DataLinkSourceManager;
import com.tssap.selena.model.elements.Entity;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IObjectActionDelegate;

public class EditDataLinkAction
extends BaseAction
implements IObjectActionDelegate {
    private DevelopmentObject mSourceObject;
    private DevelopmentObject mTargetObject;

    public boolean isEnabled(Entity entity) {
        String projectName = entity.getModel().getUniqueName().getName();
        DataLinkSourceManager sourceManager = DataLinkSourceManager.getDataSourceManager(projectName);
        if (sourceManager == null) {
            return false;
        }
        DataLink dataLink = sourceManager.getDataLinkManager().findDataLink(entity.getUniqueName());
        return dataLink != null;
    }

    public void run(IAction action) {
        this.run();
    }

    public void run() {
        if (this.mEntity == null) {
            return;
        }
        String projectName = this.mEntity.getModel().getUniqueName().getName();
        DataLinkSourceManager sourceManager = DataLinkSourceManager.getDataSourceManager(projectName);
        if (sourceManager == null) {
            return;
        }
        DataLink dataLink = sourceManager.getDataLinkManager().findDataLink(this.mEntity.getUniqueName());
        if (dataLink == null) {
            return;
        }
        this.mSourceObject = dataLink.getSource();
        this.mTargetObject = dataLink.getTarget();
        this.run(this.mSourceObject, this.mTargetObject);
    }

    public void run(DevelopmentObject sourceObject, DevelopmentObject targetObject) {
        this.mSourceObject = sourceObject;
        this.mTargetObject = targetObject;
        if (this.mSourceObject == this.mTargetObject) {
            return;
        }
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ServiceWithUI.editDataLink((DevelopmentObject)EditDataLinkAction.this.mSourceObject, (DevelopmentObject)EditDataLinkAction.this.mTargetObject);
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(runnable, null);
        }
        catch (CoreException e) {
            TsmodelWebDynproPlugin.internalError(this.getClass(), "run", "run failed", e, false);
        }
    }
}

