/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.tsmodel.application.actions;

import com.sap.ide.webdynpro.tsmodel.application.actions.BaseAction;
import com.sap.ide.webdynpro.tsmodel.application.plugin.TsmodelWebDynproPlugin;
import com.tssap.selena.model.elements.Model;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IObjectActionDelegate;

public abstract class ProjectAction
extends BaseAction
implements IObjectActionDelegate {
    protected boolean mUseRunnable = true;

    public void run(IAction action) {
        if (this.mUseRunnable) {
            final IAction lAction = action;
            IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    ProjectAction.this.runInternal(lAction);
                }
            };
            try {
                ResourcesPlugin.getWorkspace().run(runnable, null);
            }
            catch (CoreException e) {
                TsmodelWebDynproPlugin.internalError(this.getClass(), "run", "run failed", e, false);
            }
        } else {
            this.runInternal(action);
        }
    }

    private void runInternal(IAction action) {
        if (this.mEntity instanceof Model) {
            String projectName = this.mEntity.getModel().getUniqueName().getName();
            if (projectName != null && projectName.length() > 0) {
                IProject eclipseProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                if (eclipseProject != null) {
                    try {
                        this.runProjectAction(action, projectName, eclipseProject);
                    }
                    catch (Throwable e) {
                        TsmodelWebDynproPlugin.internalError(this.getClass(), "runInternal", "Exception occured", e, false);
                    }
                } else {
                    TsmodelWebDynproPlugin.internalError(this.getClass(), "runInternal", "eclipseProject == null", null, false);
                }
            } else {
                TsmodelWebDynproPlugin.internalError(this.getClass(), "runInternal", "Empty Project Name", null, false);
            }
        }
    }

    public abstract void runProjectAction(IAction var1, String var2, IProject var3);
}

