/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.tsmodel.application.actions;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.component.Window;
import com.sap.ide.metamodel.webdynpro.component.view.AbstractView;
import com.sap.ide.metamodel.webdynpro.component.view.InterfaceView;
import com.sap.ide.metamodel.webdynpro.component.viewset.ViewUsage;
import com.sap.ide.webdynpro.tsmodel.application.actions.DevelopmentObjectAction;
import com.sap.ide.webdynpro.tsmodel.application.plugin.TsmodelWebDynproPlugin;
import com.sap.ide.webdynpro.tsmodel.application.provider.DataSourceManager;
import com.sap.ide.webdynpro.tsmodel.application.provider.Utils;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;

public class EditCorrespondingWindowAction
extends DevelopmentObjectAction {
    public boolean isEnabled(Entity entity) {
        String projectName = entity.getModel().getUniqueName().getName();
        DevelopmentObject developmentObject = DataSourceManager.getDataSourceManager(projectName).getDevelopmentObject(entity.getUniqueName());
        if (developmentObject == null) {
            return false;
        }
        if (!(developmentObject instanceof ViewUsage)) {
            return false;
        }
        ViewUsage viewUsage = (ViewUsage)developmentObject;
        return this.getCorrespondingWindow(viewUsage) != null;
    }

    public void run(DevelopmentObject developmentObject) {
        if (developmentObject instanceof ViewUsage) {
            ViewUsage viewUsage = (ViewUsage)developmentObject;
            Window window = this.getCorrespondingWindow(viewUsage);
            if (window == null) {
                return;
            }
            UniqueName windowUIN = DataSourceManager.createUniqueName((DevelopmentObject)window, "Window");
            String projectName = developmentObject.getRoot().getMetamodel().getName();
            UniqueName modelUIN = ModelAccess.createModelUniqueName((String)projectName);
            Model model = ModelAccess.getModel((UniqueName)modelUIN);
            if (model == null) {
                return;
            }
            Entity windowEntity = model.findEntity(windowUIN);
            if (windowEntity != null) {
                Utils.openDiagram((Element)windowEntity);
            }
        } else {
            TsmodelWebDynproPlugin.internalError(this.getClass(), "run", "developmentObject is no ViewUsage: " + developmentObject.toString(), null, false);
            return;
        }
    }

    private Window getCorrespondingWindow(ViewUsage viewUsage) {
        AbstractView abstractView = viewUsage.getView();
        if (abstractView == null || !(abstractView instanceof InterfaceView)) {
            return null;
        }
        InterfaceView interfaceView = (InterfaceView)abstractView;
        if (interfaceView.getWindow() != null) {
            return interfaceView.getWindow();
        }
        return null;
    }
}

