/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.tsmodel.application.actions;

import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.webdynpro.tsmodel.application.actions.BaseAction;
import com.sap.ide.webdynpro.tsmodel.application.plugin.TsmodelWebDynproPlugin;
import com.sap.ide.webdynpro.tsmodel.application.provider.DataSourceManager;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IObjectActionDelegate;

public abstract class DevelopmentObjectAction
extends BaseAction
implements IObjectActionDelegate {
    public void run(IAction action) {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                DevelopmentObjectAction.this.runInternal();
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(runnable, null);
        }
        catch (CoreException e) {
            TsmodelWebDynproPlugin.internalError(this.getClass(), "run", "run failed", e, false);
        }
    }

    protected void runInternal() {
        if (this.mEntity == null) {
            return;
        }
        String projectName = this.mEntity.getModel().getUniqueName().getName();
        DevelopmentObject developmentObject = DataSourceManager.getDataSourceManager(projectName).getDevelopmentObject(this.mEntity.getUniqueName());
        if (developmentObject == null) {
            TsmodelWebDynproPlugin.internalError(this.getClass(), "runInternal", "developmentObject == null", null, false);
            return;
        }
        try {
            this.run(developmentObject);
        }
        catch (Throwable e) {
            TsmodelWebDynproPlugin.internalError(this.getClass(), "runInternal", "Exception occured", e, false);
        }
    }

    public abstract void run(DevelopmentObject var1);
}

