/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.tsmodel.application.actions;

import com.sap.ide.webdynpro.tsmodel.application.actions.BaseAction;
import com.sap.ide.webdynpro.tsmodel.application.plugin.TsmodelWebDynproPlugin;
import com.tssap.selena.model.elements.Entity;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IObjectActionDelegate;

public class CreationAction
extends BaseAction
implements IObjectActionDelegate {
    private static Set sSaveRelevantSubdomains = new HashSet();
    private String mMetaClass;
    private Entity mCreatedEntity;

    public CreationAction(String metaClass) {
        sSaveRelevantSubdomains.add("View");
        sSaveRelevantSubdomains.add("CustomController");
        this.mMetaClass = metaClass;
    }

    public void run(IAction action) {
        String subdomain = this.mEntity.getUniqueName().getSubDomain();
        if (sSaveRelevantSubdomains.contains(subdomain)) {
            this.runInternal();
        } else {
            IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    CreationAction.this.runInternal();
                }
            };
            try {
                ResourcesPlugin.getWorkspace().run(runnable, null);
            }
            catch (CoreException e) {
                TsmodelWebDynproPlugin.internalError(this.getClass(), "run", "run failed", e, false);
            }
        }
    }

    private void runInternal() {
        if (this.mEntity == null) {
            return;
        }
        try {
            if (this.mEntity.canCreateChildEntity(this.mMetaClass, null)) {
                this.mCreatedEntity = this.mEntity.createChildEntity(this.mMetaClass, null);
            }
        }
        catch (Throwable e) {
            TsmodelWebDynproPlugin.internalError(this.getClass(), "runInternal", "Exception occured", e, false);
        }
    }

    public boolean isEnabled(Entity entity) {
        if (entity == null) {
            return false;
        }
        return entity.canCreateChildEntity(this.mMetaClass, null);
    }

    public Entity getCreatedEntity() {
        return this.mCreatedEntity;
    }
}

