/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.tsmodel.application.actions;

import com.sap.ide.metamodel.core.repository.MMRepositoryObject;
import com.sap.ide.metamodel.core.repository.RepositoryServices;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.webdynpro.component.Window;
import com.sap.ide.metamodel.webdynpro.component.navigation.OutboundPlug;
import com.sap.ide.metamodel.webdynpro.component.viewset.ViewUsage;
import com.sap.ide.webdynpro.service.applicationmodeler.CreationWithUI;
import com.sap.ide.webdynpro.service.applicationmodeler.ServicesDeletion;
import com.sap.ide.webdynpro.service.applicationmodeler.ServicesVSH;
import com.sap.ide.webdynpro.service.applicationmodeler.wizards.link.LinkWizardTargetPair;
import com.sap.ide.webdynpro.tsmodel.application.actions.BaseAction;
import com.sap.ide.webdynpro.tsmodel.application.plugin.TsmodelWebDynproPlugin;
import com.sap.ide.webdynpro.tsmodel.application.provider.DataSourceManager;
import com.sap.ide.webdynpro.tsmodel.application.provider.InboundPlugUsageNodeProvider;
import com.sap.ide.webdynpro.tsmodel.application.provider.OutboundPlugUsage;
import com.sap.ide.webdynpro.tsmodel.application.provider.OutboundPlugUsageNodeProvider;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.UniqueName;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IObjectActionDelegate;

public class CreateLinkAction
extends BaseAction
implements IObjectActionDelegate {
    private String mMetaClass = "WDNavigationLink";

    public void run(IAction action) {
        try {
            if (this.mEntity.canCreateChildEntity(this.mMetaClass, null)) {
                this.createLink(this.mEntity);
            }
        }
        catch (Throwable e) {
            TsmodelWebDynproPlugin.internalError(this.getClass(), "run", "Exception occured", e, false);
        }
    }

    void createLink(Entity outboundPlugUsageEntity) {
        Model model = outboundPlugUsageEntity.getModel();
        String projectName = model.getUniqueName().getName();
        DataSourceManager dataSourceManager = DataSourceManager.getDataSourceManager(projectName);
        if (dataSourceManager == null) {
            TsmodelWebDynproPlugin.internalError(this.getClass(), "createLink", "dataSourceManager == null", null, false);
            return;
        }
        OutboundPlugUsage outboundPlugUsage = OutboundPlugUsageNodeProvider.getOutboundPlugUsage(dataSourceManager, (Element)outboundPlugUsageEntity);
        if (outboundPlugUsage == null) {
            return;
        }
        ViewUsage sourceViewUsage = outboundPlugUsage.getViewUsage();
        Window window = ServicesVSH.getWindow((DevelopmentObject)sourceViewUsage);
        if (window == null) {
            TsmodelWebDynproPlugin.internalError(this.getClass(), "createLink", "window == null", null, false);
            return;
        }
        MMRepositoryObject[] repositoryObjects = ServicesDeletion.getRepositoryObjectsAffectedByWindowModification((DevelopmentObject)window);
        if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects)) {
            return;
        }
        LinkWizardTargetPair pair = CreationWithUI.selectNavigationLinkTarget((OutboundPlug)outboundPlugUsage.getOutboundPlug(), (ViewUsage)sourceViewUsage, (Window)window);
        if (pair == null) {
            return;
        }
        UniqueName uniqueName = InboundPlugUsageNodeProvider.createInboundPlugUsageUniqueName(pair.fetchViewUsage(), pair.fetchInboundPlug());
        Entity inboundPlugUsageEntity = model.findEntity(uniqueName);
        if (inboundPlugUsageEntity == null) {
            TsmodelWebDynproPlugin.internalError(this.getClass(), "createLink", "inboundPlugUsageEntity == null", null, false);
            return;
        }
        Entity link = outboundPlugUsageEntity.createChildEntity(this.mMetaClass, null);
        if (link == null) {
            TsmodelWebDynproPlugin.internalError(this.getClass(), "createLink", "link == null", null, false);
            return;
        }
        link.setParticipant("Client", null, (Element)outboundPlugUsageEntity);
        link.setParticipant("Supplier", null, (Element)inboundPlugUsageEntity);
        dataSourceManager.commitChanges();
    }
}

