/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.templates;

import com.tssap.dtr.client.lib.protocol.IAuthenticator;
import com.tssap.dtr.client.lib.protocol.IConnectionTemplate;
import com.tssap.dtr.client.lib.protocol.requests.ParserException;
import com.tssap.dtr.client.lib.protocol.session.Certificates;
import com.tssap.dtr.client.lib.protocol.session.Cookies;
import com.tssap.dtr.client.lib.protocol.session.SSO2Authenticator;
import com.tssap.dtr.client.lib.protocol.session.SessionContext;
import com.tssap.dtr.client.lib.protocol.templates.ConnectionTemplate;
import com.tssap.dtr.client.lib.protocol.templates.ITemplateProvider;
import com.tssap.dtr.client.lib.protocol.templates.TemplateException;
import com.tssap.dtr.client.lib.protocol.util.XMLWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class TemplateSerializer {
    private ITemplateProvider provider;

    public TemplateSerializer(ITemplateProvider provider) {
        this.provider = provider;
    }

    public void serialize(OutputStream out) throws IOException {
        List templates = this.provider.listConnectionTemplates();
        XMLWriter writer = new XMLWriter(out);
        writer.wrapAttributeLists(true);
        writer.beginDocument();
        writer.writeRootTag("servers");
        int i = 0;
        while (i < templates.size()) {
            IConnectionTemplate template = (IConnectionTemplate)templates.get(i);
            new PersistableTemplate(template).serialize(writer);
            ++i;
        }
        writer.endDocument();
        writer.serialize();
        writer.close();
    }

    public void initialize(InputStream in) throws IOException, TemplateException {
        try {
            XMLReader reader = this.createXMLReader();
            if (reader != null) {
                InitHandler handler = new InitHandler(this.provider);
                reader.setContentHandler(handler);
                InputSource s = new InputSource(in);
                reader.parse(s);
            }
        }
        catch (SAXException ex) {
            throw new TemplateException("Invalid templates detected", ex);
        }
    }

    private XMLReader createXMLReader() {
        XMLReader saxParser = null;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                saxParser = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
            }
            catch (SAXException ex) {
                throw new ParserException("Unable to find or instantiate XML parser", ex);
            }
            catch (FactoryConfigurationError ex) {
                throw new ParserException("Failed to instantiate XML parser factory", ex);
            }
            catch (ParserConfigurationException ex) {
                throw new ParserException("Unable to find or instantiate XML parser", ex);
            }
            Object var7_3 = null;
            Thread.currentThread().setContextClassLoader(cl);
        }
        catch (Throwable throwable) {
            Object var7_4 = null;
            Thread.currentThread().setContextClassLoader(cl);
            throw throwable;
        }
        return saxParser;
    }

    private static class InitHandler
    extends DefaultHandler {
        private final int START_STATE = 0;
        private final int SERVERS_STATE = 1;
        private int _state = 0;
        private ITemplateProvider provider;

        public InitHandler(ITemplateProvider provider) {
            this.provider = provider;
        }

        public void startElement(String namespaceURI, String localName, String rawName, Attributes attributes) throws SAXException {
            switch (this._state) {
                case 0: {
                    if (rawName.equalsIgnoreCase("servers")) {
                        this._state = 1;
                        break;
                    }
                }
                case 1: {
                    if (rawName.equalsIgnoreCase("server")) {
                        PersistableTemplate template = new PersistableTemplate();
                        try {
                            template.initialize(attributes);
                        }
                        catch (TemplateException e) {
                            throw new SAXException("Invalid template", e);
                        }
                        this.provider.addConnectionTemplate(template);
                        break;
                    }
                }
                default: {
                    throw new SAXException("internal state error: startTag(" + localName + ") state(" + this._state + ")");
                }
            }
        }
    }

    private static class PersistableTemplate
    extends ConnectionTemplate {
        private static final String SERVER = "server";
        private static final String URL = "url";
        private static final String PROXY = "proxy";
        private static final String USE_PROXY = "useProxy";
        private static final String TUNNEL_PROXY = "tunnelProxy";
        private static final String BYPASS_PROXY = "bypassProxyFor";
        private static final String READ_TIMEOUT = "readTimeout";
        private static final String CONNECT_TIMEOUT = "connectTimeout";
        private static final String EXPIRE_TIMEOUT = "expireTimeout";
        private static final String REPEAT = "repeat";
        private static final String REPEAT_ON_TIMEOUT = "repeatOnTimeout";
        private static final String FOLLOW_REDIRECTS = "followRedirects";
        private static final String FOLLOW_PERMANENT_REDIRECTS = "redirectPermanent";
        private static final String FOLLOW_FOREIGN_REDIRECTS = "redirectsToForeignDomains";
        private static final String FOLLOW_PROXY_REDIRECTS = "redirectsToProxies";
        private static final String FOLLOW_HTTPS_REDIRECTS = "redirectsToHTTPS";
        private static final String REDIRECT_ALL_METHODS = "redirectAllMethods";
        private static final String REDIRECT_MAX_HOPS = "redirectMaxHops";
        private static final String SENDBUFFER_SIZE = "sendbufferSize";
        private static final String RECEIVEBUFFER_SIZE = "receivebufferSize";
        private static final String COMPRESS = "compress";
        private static final String COMPRESS_REQUESTS = "compressRequests";
        private static final String COMPRESS_RESPONSES = "compressResponses";
        private static final String DIGEST = "digest";
        private static final String CERTIFY_ME = "certifyMe";
        private static final String CERTIFY_THEM = "certifyThem";
        private static final String KEYSTORE = "keystore";
        private static final String TRUSTSTORE = "truststore";
        private static final String AUTHENTICATE = "authenticate";
        private static final String AUTH_SCHEME = "authScheme";
        private static final String COOKIES = "cookies";
        private static final String COOKIE_PRIVACY = "cookiePrivacy";
        private static final String REJECT_COOKIES_FOR = "rejectCookiesFor";
        private static final String PROTOCOL_VERSION = "protocolVersion";
        private static final String USER_AGENT = "userAgent";

        protected PersistableTemplate() {
        }

        public PersistableTemplate(IConnectionTemplate template) {
            super(template);
        }

        protected void serialize(XMLWriter writer) throws IOException {
            boolean compressed;
            ArrayList<XMLWriter.Attribute> attributes = new ArrayList<XMLWriter.Attribute>();
            attributes.add(new XMLWriter.Attribute(URL, this.getUrl()));
            String proxyUrl = this.proxy != null ? this.proxy + ":" + this.proxyPort : "none";
            attributes.add(new XMLWriter.Attribute(PROXY, proxyUrl));
            attributes.add(new XMLWriter.Attribute(USE_PROXY, this.isUsingProxy() ? "on" : "off"));
            attributes.add(new XMLWriter.Attribute(TUNNEL_PROXY, this.isTunnelingProxy() ? "on" : "off"));
            if (this.context != null) {
                attributes.add(new XMLWriter.Attribute(AUTHENTICATE, this.context.getSendAuthentication() ? "on" : "off"));
                IAuthenticator auth = this.context.getAuthenticator();
                if (auth != null) {
                    String authScheme = auth.getAuthenticationScheme();
                    if (authScheme == "SSO2") {
                        IAuthenticator login = ((SSO2Authenticator)auth).getLoginAuthenticator();
                        if (login != null) {
                            attributes.add(new XMLWriter.Attribute(AUTH_SCHEME, authScheme + "," + login.getAuthenticationScheme()));
                        } else {
                            attributes.add(new XMLWriter.Attribute(AUTH_SCHEME, authScheme));
                        }
                    } else {
                        attributes.add(new XMLWriter.Attribute(AUTH_SCHEME, authScheme));
                    }
                } else {
                    attributes.add(new XMLWriter.Attribute(AUTH_SCHEME, "default"));
                }
                Certificates certs = this.context.certificates();
                attributes.add(new XMLWriter.Attribute(CERTIFY_ME, certs.authenticateMe() ? "on" : "off"));
                attributes.add(new XMLWriter.Attribute(CERTIFY_THEM, certs.authenticateThem() ? "on" : "off"));
                String certStore = certs.getClientCertStore();
                Certificates.KeyStoreType certStoreType = certs.getClientCertStoreType();
                attributes.add(new XMLWriter.Attribute(KEYSTORE, certStore != null ? certStoreType.toString() + "," + certStore : "none"));
                certStore = certs.getServerCertStore();
                certStoreType = certs.getServerCertStoreType();
                attributes.add(new XMLWriter.Attribute(TRUSTSTORE, certStore != null ? certStoreType.toString() + "," + certStore : "default"));
                attributes.add(new XMLWriter.Attribute(COOKIES, this.context.getSendCookies() ? "on" : "off"));
                attributes.add(new XMLWriter.Attribute(COOKIE_PRIVACY, this.context.cookies().getPrivacy().toString()));
            } else {
                attributes.add(new XMLWriter.Attribute(AUTHENTICATE, "off"));
                attributes.add(new XMLWriter.Attribute(AUTH_SCHEME, "default"));
                attributes.add(new XMLWriter.Attribute(CERTIFY_ME, "off"));
                attributes.add(new XMLWriter.Attribute(CERTIFY_THEM, "off"));
                attributes.add(new XMLWriter.Attribute(KEYSTORE, "none"));
                attributes.add(new XMLWriter.Attribute(TRUSTSTORE, "default"));
                attributes.add(new XMLWriter.Attribute(COOKIES, "on"));
                attributes.add(new XMLWriter.Attribute(COOKIE_PRIVACY, Cookies.Privacy.FROM_ORIGINAL_HOST_ONLY.toString()));
            }
            boolean bl = compressed = this.compressedRequests && this.compressedResponses;
            if (compressed || this.compressionAlgorithm != null) {
                if (this.compressionAlgorithm != null) {
                    attributes.add(new XMLWriter.Attribute(COMPRESS, (compressed ? "on" : "off") + "," + this.compressionAlgorithm));
                } else {
                    attributes.add(new XMLWriter.Attribute(COMPRESS, compressed ? "on" : "off"));
                }
            } else if (this.compressedRequests) {
                attributes.add(new XMLWriter.Attribute(COMPRESS_REQUESTS, "on"));
            } else if (this.compressedResponses) {
                attributes.add(new XMLWriter.Attribute(COMPRESS_RESPONSES, "on"));
            } else {
                attributes.add(new XMLWriter.Attribute(COMPRESS, "off"));
            }
            attributes.add(new XMLWriter.Attribute(READ_TIMEOUT, Integer.toString(this.readTimeout)));
            attributes.add(new XMLWriter.Attribute(CONNECT_TIMEOUT, Integer.toString(this.connectTimeout)));
            attributes.add(new XMLWriter.Attribute(EXPIRE_TIMEOUT, Integer.toString(this.expirationTimeout)));
            attributes.add(new XMLWriter.Attribute(REPEAT, Integer.toString(this.requestRepetitions)));
            attributes.add(new XMLWriter.Attribute(REPEAT_ON_TIMEOUT, this.repeatOnTimeout ? "on" : "off"));
            attributes.add(new XMLWriter.Attribute(FOLLOW_REDIRECTS, this.followRedirects ? "on" : "off"));
            attributes.add(new XMLWriter.Attribute(FOLLOW_PERMANENT_REDIRECTS, this.followPermanentRedirects ? "on" : "off"));
            attributes.add(new XMLWriter.Attribute(FOLLOW_FOREIGN_REDIRECTS, this.followForeignRedirects ? "on" : "off"));
            attributes.add(new XMLWriter.Attribute(FOLLOW_PROXY_REDIRECTS, this.followProxyRedirects ? "on" : "off"));
            attributes.add(new XMLWriter.Attribute(FOLLOW_HTTPS_REDIRECTS, "off"));
            attributes.add(new XMLWriter.Attribute(REDIRECT_ALL_METHODS, this.followRedirectAllMethods ? "on" : "off"));
            attributes.add(new XMLWriter.Attribute(REDIRECT_MAX_HOPS, Integer.toString(this.maxRedirects)));
            attributes.add(new XMLWriter.Attribute(SENDBUFFER_SIZE, this.sendBufferSize < 0 ? "default" : Integer.toString(this.sendBufferSize)));
            attributes.add(new XMLWriter.Attribute(RECEIVEBUFFER_SIZE, this.receiveBufferSize < 0 ? "default" : Integer.toString(this.receiveBufferSize)));
            attributes.add(new XMLWriter.Attribute(PROTOCOL_VERSION, this.version));
            attributes.add(new XMLWriter.Attribute(USER_AGENT, this.userAgent));
            writer.writeEmptyTag(SERVER, attributes.toArray(new XMLWriter.Attribute[attributes.size()]));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected void initialize(Attributes attributes) throws TemplateException {
            String userAgent;
            String version;
            String digest;
            String compressResponses;
            String compressRequests;
            String domains;
            String url = attributes.getValue(URL);
            if (url == null) {
                throw new TemplateException("Missing URL");
            }
            try {
                if (!url.endsWith("/")) {
                    url = url.concat("/");
                }
                this.setUrl(url);
            }
            catch (MalformedURLException e) {
                throw new TemplateException("Malformed URL encountered [" + url + "]");
            }
            String proxy = attributes.getValue(PROXY);
            if (proxy != null && !"none".equalsIgnoreCase(proxy)) {
                String tunnelProxy;
                String bypassProxy;
                try {
                    int n = proxy.indexOf("://");
                    if (n > 0) {
                        this.setProxyUrl(proxy);
                    } else {
                        n = proxy.indexOf(58);
                        if (n > 0) {
                            this.setProxyHost(proxy.substring(0, n).trim());
                            this.setProxyPort(Integer.parseInt(proxy.substring(n + 1).trim()));
                        } else {
                            this.setProxyHost(proxy);
                        }
                    }
                }
                catch (NumberFormatException e) {
                    throw new TemplateException("Malformed proxy port [" + proxy + "]");
                }
                catch (MalformedURLException e) {
                    throw new TemplateException("Malformed proxy URL [" + proxy + "]");
                }
                String useProxy = attributes.getValue(USE_PROXY);
                if (useProxy != null) {
                    this.setUseProxy("on".equalsIgnoreCase(useProxy));
                }
                if ((bypassProxy = attributes.getValue(BYPASS_PROXY)) != null) {
                    this.setUseProxy("on".equalsIgnoreCase(useProxy), bypassProxy);
                }
                if ((tunnelProxy = attributes.getValue(TUNNEL_PROXY)) != null) {
                    this.setTunnelProxy("on".equalsIgnoreCase(tunnelProxy));
                }
            }
            SessionContext ctx = new SessionContext();
            this.setSessionContext(ctx);
            String authenticate = attributes.getValue(AUTHENTICATE);
            String authScheme = attributes.getValue(AUTH_SCHEME);
            if (authenticate != null) {
                ctx.setSendAuthentication("on".equalsIgnoreCase(authenticate));
            }
            if (authScheme != null && !"default".equalsIgnoreCase(authScheme)) {
                try {
                    if (authScheme.startsWith("SSO2")) {
                        SSO2Authenticator auth = new SSO2Authenticator(ctx);
                        int n = authScheme.indexOf(",");
                        if (n > 0) {
                            authScheme = authScheme.substring(n + 1).trim();
                            auth.setLoginAuthenticator(authScheme);
                        }
                        ctx.setAuthenticator(auth);
                    } else {
                        ctx.setAuthenticator(authScheme);
                    }
                }
                catch (NoSuchAlgorithmException e) {
                    throw new TemplateException("Unknown authentication scheme [" + authScheme + "]");
                }
            }
            Certificates certs = ctx.certificates();
            String keystore = attributes.getValue(KEYSTORE);
            String clientStoreType = null;
            String clientStoreFile = null;
            if (keystore != null && !"none".equalsIgnoreCase(keystore)) {
                int n = keystore.indexOf(44);
                if (n > 0) {
                    clientStoreType = keystore.substring(0, n).trim();
                    clientStoreFile = keystore.substring(n + 1).trim();
                } else {
                    clientStoreFile = keystore.trim();
                }
            }
            String truststore = attributes.getValue(TRUSTSTORE);
            String serverStoreType = null;
            String serverStoreFile = null;
            if (truststore != null && !"default".equalsIgnoreCase(truststore)) {
                int n = truststore.indexOf(44);
                if (n > 0) {
                    serverStoreType = truststore.substring(0, n).trim();
                    serverStoreFile = truststore.substring(n + 1).trim();
                } else {
                    serverStoreFile = truststore.trim();
                }
            }
            if ("SERVER".equalsIgnoreCase(clientStoreType) || "SERVER".equalsIgnoreCase(serverStoreType)) {
                if (!"SERVER".equalsIgnoreCase(clientStoreType) || !"SERVER".equalsIgnoreCase(serverStoreType)) throw new TemplateException("Cannot handle mixed keystore types [" + clientStoreType.toString() + "," + serverStoreType.toString() + "]");
                certs.setEngineCertificateStores(serverStoreFile, clientStoreFile);
            } else {
                if (clientStoreFile != null) {
                    if (clientStoreType == null) {
                        try {
                            certs.setClientCertificates(clientStoreFile);
                        }
                        catch (KeyStoreException e) {
                            throw new TemplateException("Unable to determine type of keystore [" + clientStoreFile + "]");
                        }
                    } else {
                        certs.setClientCertificates(clientStoreFile, Certificates.KeyStoreType.valueOf(clientStoreType));
                    }
                }
                if (serverStoreFile != null) {
                    if (serverStoreType == null) {
                        certs.setServerCertificates(serverStoreFile);
                    } else {
                        certs.setServerCertificates(serverStoreFile, Certificates.KeyStoreType.valueOf(serverStoreType));
                    }
                }
            }
            certs.setAuthenticateMe("on".equalsIgnoreCase(attributes.getValue(CERTIFY_ME)));
            certs.setAuthenticateThem("on".equalsIgnoreCase(attributes.getValue(CERTIFY_THEM)));
            String cookies = attributes.getValue(COOKIES);
            if (cookies != null) {
                ctx.setSendCookies("on".equalsIgnoreCase(cookies));
            }
            String privacy = attributes.getValue(COOKIE_PRIVACY);
            if (Cookies.Privacy.FROM_ALL_HOSTS.toString().equalsIgnoreCase(privacy)) {
                ctx.cookies().setPrivacy(Cookies.Privacy.FROM_ALL_HOSTS);
            }
            if ((domains = attributes.getValue(REJECT_COOKIES_FOR)) != null && !"none".equalsIgnoreCase(domains)) {
                ctx.cookies().rejectCookiesFor(domains);
            }
            try {
                String timeout = attributes.getValue(READ_TIMEOUT);
                if (timeout != null) {
                    this.setSocketReadTimeout(Integer.parseInt(timeout));
                }
            }
            catch (NumberFormatException e) {
                throw new TemplateException("Invalid read timeout [not an integer number]");
            }
            try {
                String connectTimeout = attributes.getValue(CONNECT_TIMEOUT);
                if (connectTimeout != null) {
                    this.setSocketConnectTimeout(Integer.parseInt(connectTimeout));
                }
            }
            catch (NumberFormatException e) {
                throw new TemplateException("Invalid connect timeout [not an integer number]");
            }
            try {
                String expirationTimeout = attributes.getValue(EXPIRE_TIMEOUT);
                if (expirationTimeout != null) {
                    this.setSocketExpirationTimeout(Integer.parseInt(expirationTimeout));
                }
            }
            catch (NumberFormatException e) {
                throw new TemplateException("Invalid expire timeout [not an integer number]");
            }
            try {
                String repeat = attributes.getValue(REPEAT);
                String repeatOnTimeout = attributes.getValue(REPEAT_ON_TIMEOUT);
                if (repeat != null) {
                    this.setRequestRepetitions(Integer.parseInt(repeat), "on".equalsIgnoreCase(repeatOnTimeout));
                }
            }
            catch (NumberFormatException e) {
                throw new TemplateException("Invalid repetition count [not an integer number]");
            }
            String redirect = attributes.getValue(FOLLOW_REDIRECTS);
            if (redirect != null) {
                this.setFollowRedirects("on".equalsIgnoreCase(redirect));
            }
            redirect = attributes.getValue(FOLLOW_PERMANENT_REDIRECTS);
            boolean redirectPermanent = "on".equalsIgnoreCase(redirect);
            redirect = attributes.getValue(FOLLOW_FOREIGN_REDIRECTS);
            boolean redirectForeign = "on".equalsIgnoreCase(redirect);
            redirect = attributes.getValue(FOLLOW_PROXY_REDIRECTS);
            boolean redirectProxy = "on".equalsIgnoreCase(redirect);
            redirect = attributes.getValue(FOLLOW_HTTPS_REDIRECTS);
            boolean redirectHttps = "on".equalsIgnoreCase(redirect);
            redirect = attributes.getValue(REDIRECT_ALL_METHODS);
            boolean allMethods = "on".equalsIgnoreCase(redirect);
            redirect = attributes.getValue(REDIRECT_MAX_HOPS);
            int maxHops = redirect != null ? Integer.parseInt(redirect) : 1;
            try {
                String sendbufferSize = attributes.getValue(SENDBUFFER_SIZE);
                if (sendbufferSize != null && !"default".equalsIgnoreCase(sendbufferSize)) {
                    this.setSendBufferSize(Integer.parseInt(sendbufferSize));
                }
            }
            catch (NumberFormatException e) {
                throw new TemplateException("Invalid send buffer size [not an integer number]");
            }
            try {
                String receivebufferSize = attributes.getValue(RECEIVEBUFFER_SIZE);
                if (receivebufferSize != null && !"default".equalsIgnoreCase(receivebufferSize)) {
                    this.setReceiveBufferSize(Integer.parseInt(receivebufferSize));
                }
            }
            catch (NumberFormatException e) {
                throw new TemplateException("Invalid receive buffer size [not an integer number]");
            }
            String compress = attributes.getValue(COMPRESS);
            if (compress != null) {
                int n = compress.indexOf(44);
                if (n < 0) {
                    this.enableCompression("on".equals(compress));
                } else {
                    this.enableCompression("on".equals(compress.substring(0, n)));
                    this.setCompressionAlgorithm(compress.substring(n + 1).toLowerCase());
                }
            }
            if ((compressRequests = attributes.getValue(COMPRESS_REQUESTS)) != null) {
                int n = compressRequests.indexOf(44);
                if (n < 0) {
                    this.enableRequestCompression("on".equals(compressRequests));
                } else {
                    this.enableRequestCompression("on".equals(compressRequests.substring(0, n)));
                    if (compress == null) {
                        this.setCompressionAlgorithm(compressRequests.substring(n + 1).toLowerCase());
                    }
                }
            }
            if ((compressResponses = attributes.getValue(COMPRESS_RESPONSES)) != null) {
                int n = compressResponses.indexOf(44);
                if (n < 0) {
                    this.enableRequestCompression("on".equals(compressResponses));
                } else {
                    this.enableResponseCompression("on".equals(compressResponses.substring(0, n)));
                    if (compress == null) {
                        this.setCompressionAlgorithm(compressResponses.substring(n + 1).toLowerCase());
                    }
                }
            }
            if ((digest = attributes.getValue(DIGEST)) != null) {
                int n = digest.indexOf(44);
                if (n < 0) {
                    this.enableResponseDigest("on".equals(digest));
                } else {
                    this.enableResponseDigest("on".equals(digest.substring(0, n)));
                    this.setDigestAlgorithm(digest.substring(n + 1).toUpperCase());
                }
            }
            if ((version = attributes.getValue(PROTOCOL_VERSION)) != null && !"default".equalsIgnoreCase(version)) {
                this.setHTTPVersion(version);
            }
            if ((userAgent = attributes.getValue(USER_AGENT)) == null || "default".equalsIgnoreCase(userAgent)) return;
            this.setUserAgent(userAgent);
        }
    }
}

