/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.templates;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.protocol.IConnectionTemplate;
import com.tssap.dtr.client.lib.protocol.URL;
import com.tssap.dtr.client.lib.protocol.templates.ITemplateProvider;
import com.tssap.dtr.client.lib.protocol.templates.InvalidTemplateIDException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;

public class SimpleTemplateProvider
implements ITemplateProvider {
    private List templates = new ArrayList();
    private static Location TRACE = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$protocol$templates$SimpleTemplateProvider == null ? (class$com$tssap$dtr$client$lib$protocol$templates$SimpleTemplateProvider = SimpleTemplateProvider.class$("com.tssap.dtr.client.lib.protocol.templates.SimpleTemplateProvider")) : class$com$tssap$dtr$client$lib$protocol$templates$SimpleTemplateProvider));
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$protocol$templates$SimpleTemplateProvider;

    public int addConnectionTemplate(IConnectionTemplate template) {
        int templateID = -1;
        List list = this.templates;
        synchronized (list) {
            this.templates.add(template);
            templateID = this.templates.size() - 1;
            if (TRACE.beInfo()) {
                TRACE.infoT("addConnectionTemplate(IConnectionTemplate)", "template<" + templateID + "> " + template.toString());
            }
        }
        return templateID;
    }

    public IConnectionTemplate getConnectionTemplate(int templateId) throws InvalidTemplateIDException {
        if (templateId < 0 || templateId >= this.templates.size()) {
            throw new InvalidTemplateIDException("Invalid template id");
        }
        return (IConnectionTemplate)this.templates.get(templateId);
    }

    public int[] searchTemplate(String url) throws MalformedURLException {
        URL theURL = new URL(url);
        int count = 0;
        int numberTemplares = this.templates.size();
        BitSet resultSet = new BitSet(numberTemplares);
        int i = 0;
        while (i < numberTemplares) {
            IConnectionTemplate template = (IConnectionTemplate)this.templates.get(i);
            if (theURL.getHost().equals(template.getHost()) && theURL.getPort() == template.getPort() && theURL.getProtocol().equals(template.getProtocol().toString()) && theURL.getPath().startsWith(template.getBasePath())) {
                resultSet.set(i);
                ++count;
            }
            ++i;
        }
        int[] result = new int[count];
        if (count == 1) {
            result[0] = resultSet.length() - 1;
        } else if (count > 1) {
            int i2 = 0;
            int j = 0;
            while (i2 < numberTemplares) {
                if (resultSet.get(i2)) {
                    result[j++] = i2;
                }
                ++i2;
            }
        }
        return result;
    }

    public List listConnectionTemplates() {
        return Collections.unmodifiableList(this.templates);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

