/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.templates;

import com.tssap.dtr.client.lib.protocol.IConnectionTemplate;
import com.tssap.dtr.client.lib.protocol.ISessionContext;
import com.tssap.dtr.client.lib.protocol.Protocol;
import com.tssap.dtr.client.lib.protocol.URL;
import com.tssap.dtr.client.lib.protocol.session.SessionContext;
import com.tssap.dtr.client.lib.protocol.socks.ISOCKSProvider;
import com.tssap.dtr.client.lib.protocol.ssl.ISecureSocketProvider;
import com.tssap.dtr.client.lib.protocol.util.Tokenizer;
import java.net.MalformedURLException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ConnectionTemplate
implements IConnectionTemplate {
    protected ISessionContext context;
    protected String host;
    protected int port = 80;
    protected String basePath = "/";
    protected String proxy;
    protected int proxyPort;
    protected boolean useProxy = false;
    protected boolean tunnelProxy = false;
    private Set excludedHosts;
    private Set excludedDomains;
    protected boolean useSOCKS = false;
    protected ISOCKSProvider socksProvider;
    protected Protocol protocol = Protocol.HTTP;
    protected boolean secureProtocol = false;
    protected ISecureSocketProvider secureSocketProvider;
    protected String version = "HTTP/1.1";
    protected boolean usingHTTP10 = false;
    protected String userAgent = "SAP HTTP CLIENT/6.40";
    protected int readTimeout = 300000;
    protected int connectTimeout = 10000;
    protected int expirationTimeout = 10000;
    protected int requestRepetitions = 1;
    protected boolean repeatOnTimeout = false;
    protected boolean followRedirects = true;
    protected boolean followForeignRedirects = false;
    protected boolean followProxyRedirects = false;
    protected boolean followRedirectAllMethods = false;
    protected int maxRedirects = 1;
    protected boolean followPermanentRedirects = false;
    protected boolean compressedResponses = false;
    protected boolean compressedRequests = false;
    protected String compressionAlgorithm = "gzip";
    protected boolean digestEnabled = false;
    protected String digestAlgorithm = "MD5";
    protected int receiveBufferSize = -1;
    protected int sendBufferSize = -1;

    public ConnectionTemplate() {
    }

    public ConnectionTemplate(IConnectionTemplate template) {
        this.setHost(template.getHost());
        this.setPort(template.getPort());
        this.setProxyHost(template.getProxyHost());
        this.setProxyPort(template.getProxyPort());
        this.setUseProxy(template.isUsingProxy());
        this.setTunnelProxy(template.isTunnelingProxy());
        this.setProtocol(template.getProtocol());
        this.setSecureSocketProvider(template.getSecureSocketProvider());
        this.setFollowRedirects(template.getFollowRedirects());
        this.setFollowPermanentRedirects(template.getFollowPermanentRedirects());
        this.setBasePath(template.getBasePath());
        this.setHTTPVersion(template.getHTTPVersion());
        this.setUserAgent(template.getUserAgent());
        this.setSocketReadTimeout(template.getSocketReadTimeout());
        this.setSocketConnectTimeout(template.getSocketConnectTimeout());
        this.setSocketExpirationTimeout(template.getSocketExpirationTimeout());
        this.setRequestRepetitions(template.getRequestRepetitions(), template.getRepeatOnTimeout());
        this.setReceiveBufferSize(template.getReceiveBufferSize());
        this.setSendBufferSize(template.getSendBufferSize());
        this.enableResponseCompression(template.isResponseCompressionEnabled());
        this.enableRequestCompression(template.isRequestCompressionEnabled());
        this.setCompressionAlgorithm(template.getCompressionAlgorithm());
        this.setSessionContext(template.getSessionContext());
    }

    public ConnectionTemplate(String url) throws MalformedURLException {
        this.parseURL(url);
    }

    public ConnectionTemplate(String url, ISessionContext context) throws MalformedURLException {
        this(url);
        this.setSessionContext(context);
    }

    public ConnectionTemplate(URL url) throws MalformedURLException {
        this.parseURL(url);
    }

    public ConnectionTemplate(URL url, ISessionContext context) throws MalformedURLException {
        this(url);
        this.setSessionContext(context);
    }

    public ConnectionTemplate(String host, int port) {
        this.setHost(host);
        this.setPort(port);
    }

    public ConnectionTemplate(String host, int port, ISessionContext context) {
        this(host, port);
        this.setSessionContext(context);
    }

    public String getUrl() {
        return this.getProtocol() + "://" + this.getHost() + ":" + this.getPort() + this.getBasePath();
    }

    public URL getUrl(String path) {
        return new URL(this.protocol.toString(), this.host, this.port, this.getAbsolutePath(path));
    }

    public void setUrl(String url) throws MalformedURLException {
        this.parseURL(url);
    }

    public void setUrl(URL url) throws MalformedURLException {
        this.parseURL(url);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getProxyUrl() {
        String url = this.getProxyHost();
        if (this.getProxyPort() > 0) {
            url = url + ":" + this.getProxyPort();
        }
        return url;
    }

    public void setProxyUrl(String url) throws MalformedURLException {
        this.parseProxyURL(url);
    }

    public void setProxyUrl(String url, boolean useProxy) throws MalformedURLException {
        this.setProxyUrl(url);
        this.setUseProxy(useProxy);
    }

    public void setProxyUrl(URL url) throws MalformedURLException {
        this.parseProxyURL(url);
    }

    public void setProxyUrl(URL url, boolean useProxy) throws MalformedURLException {
        this.setProxyUrl(url);
        this.setUseProxy(useProxy);
    }

    public String getProxyHost() {
        return this.proxy;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyHost(String proxy) {
        this.proxy = proxy;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public void setUseProxy(boolean useProxy) {
        this.useProxy = useProxy;
    }

    public void setUseProxy(boolean useProxy, String exclusions) {
        this.useProxy = useProxy;
        List parts = Tokenizer.partsOf(exclusions, ",;");
        int i = 0;
        while (i < parts.size()) {
            String part = (String)parts.get(i);
            if (part.startsWith(".")) {
                if (this.excludedDomains == null) {
                    this.excludedDomains = new HashSet();
                }
                this.excludedDomains.add(part);
            } else {
                if (this.excludedHosts == null) {
                    this.excludedHosts = new HashSet();
                }
                this.excludedHosts.add(part);
            }
            ++i;
        }
    }

    public boolean isUsingProxy() {
        return this.useProxy;
    }

    public boolean isUsingSOCKS() {
        return this.useSOCKS;
    }

    public void setTunnelProxy(boolean tunnelProxy) {
        this.tunnelProxy = tunnelProxy;
    }

    public boolean isTunnelingProxy() {
        return this.tunnelProxy;
    }

    public String getHTTPVersion() {
        return this.version;
    }

    public void setHTTPVersion(String version) {
        if ("HTTP/1.0".equalsIgnoreCase(version)) {
            this.usingHTTP10 = true;
            this.version = version;
        } else if ("HTTP/1.1".equalsIgnoreCase(version)) {
            this.version = version;
        } else {
            throw new IllegalArgumentException("HTTP version " + version + "not supported");
        }
    }

    public boolean usingHTTP10() {
        return this.usingHTTP10;
    }

    public ISessionContext getSessionContext() {
        if (this.context == null) {
            this.context = new SessionContext();
        }
        return this.context;
    }

    public void setSessionContext(ISessionContext ctx) {
        this.context = ctx;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(Protocol protocol) {
        if (protocol.equals(Protocol.HTTPS)) {
            this.secureProtocol = true;
        } else if (protocol.equals(Protocol.HTTP)) {
            this.secureProtocol = false;
        }
        if (this.equalsDefaultPort(this.port)) {
            this.port = this.getDefaultPort(protocol);
        }
        this.protocol = protocol;
    }

    public boolean isSecureProtocol() {
        return this.secureProtocol;
    }

    public void setSecureSocketProvider(ISecureSocketProvider provider) {
        this.secureSocketProvider = provider;
    }

    public ISecureSocketProvider getSecureSocketProvider() {
        return this.secureSocketProvider;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String path) {
        StringBuffer buf = new StringBuffer();
        if (!path.startsWith("/")) {
            buf.append('/');
        }
        buf.append(path);
        if (!path.endsWith("/")) {
            buf.append('/');
        }
        this.basePath = buf.toString();
    }

    public String getAbsolutePath(String path) {
        if (path == null) {
            return "/";
        }
        if (!path.startsWith("/") && this.basePath != null) {
            return this.basePath + path;
        }
        return path;
    }

    public int getSocketReadTimeout() {
        return this.readTimeout;
    }

    public void setSocketReadTimeout(int timeout) {
        this.readTimeout = timeout;
    }

    public int getSocketConnectTimeout() {
        return this.connectTimeout;
    }

    public void setSocketConnectTimeout(int timeout) {
        this.connectTimeout = timeout;
    }

    public int getSocketExpirationTimeout() {
        return this.expirationTimeout;
    }

    public void setSocketExpirationTimeout(int timeout) {
        this.expirationTimeout = timeout;
    }

    public int getRequestRepetitions() {
        return this.requestRepetitions;
    }

    public boolean getRepeatOnTimeout() {
        return this.repeatOnTimeout;
    }

    public void setRequestRepetitions(int repetitions, boolean repeatOnTimeout) {
        this.requestRepetitions = repetitions;
        this.repeatOnTimeout = repeatOnTimeout;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setReceiveBufferSize(int size) {
        this.receiveBufferSize = size;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public void setSendBufferSize(int size) {
        this.sendBufferSize = size;
    }

    public void enableCompression(boolean enable) {
        this.compressedRequests = enable;
        this.compressedResponses = enable;
    }

    public boolean isCompressionEnabled() {
        return this.compressedRequests || this.compressedResponses;
    }

    public void enableRequestCompression(boolean enable) {
        this.compressedRequests = enable;
    }

    public boolean isRequestCompressionEnabled() {
        return this.compressedRequests;
    }

    public void enableResponseCompression(boolean enable) {
        this.compressedResponses = enable;
    }

    public boolean isResponseCompressionEnabled() {
        return this.compressedResponses;
    }

    public String getCompressionAlgorithm() {
        return this.compressionAlgorithm;
    }

    public void setCompressionAlgorithm(String algorithm) {
        this.compressionAlgorithm = algorithm;
    }

    public static String[] getSupportedCompressionAlgorithms() {
        return new String[]{"gzip", "deflate"};
    }

    public void enableResponseDigest(boolean enable) {
        this.digestEnabled = enable;
    }

    public boolean isResponseDigestEnabled() {
        return this.digestEnabled;
    }

    public String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public void setDigestAlgorithm(String algorithm) {
        this.digestAlgorithm = algorithm;
    }

    public boolean getFollowRedirects() {
        return this.followRedirects;
    }

    public void setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    public void setFollowPermanentRedirects(boolean followPermanentRedirects) {
        if (followPermanentRedirects) {
            this.followRedirects = true;
        }
        this.followPermanentRedirects = followPermanentRedirects;
    }

    public boolean getFollowPermanentRedirects() {
        return this.followPermanentRedirects;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("host<").append(this.getUrl()).append(">");
        if (this.context != null) {
            s.append(" ,").append(this.context.toString());
        }
        if (this.proxy != null) {
            s.append(", proxy<").append(this.getProxyUrl()).append(">");
            s.append("<state:").append(this.isUsingProxy() ? "on" : "off").append(">");
            s.append(",<connect:").append(this.isTunnelingProxy() ? "tunnel" : "direct").append(">");
        }
        s.append(", timeout<read:").append(this.getSocketReadTimeout()).append(">");
        s.append("<connect:").append(this.getSocketConnectTimeout()).append(">");
        s.append("<expires:").append(this.getSocketExpirationTimeout()).append(">");
        s.append(", repeat<").append(this.getRequestRepetitions()).append(">");
        s.append("<on-timeout:").append(this.getRepeatOnTimeout() ? "on" : "off").append(">");
        s.append(", compress<requests:").append(this.isRequestCompressionEnabled() ? "on" : "off").append(">");
        s.append("<responses:").append(this.isResponseCompressionEnabled() ? "on" : "off").append(">");
        s.append("<").append(this.getCompressionAlgorithm()).append(">");
        s.append(", buffer-sizes<send:").append(this.getSendBufferSize()).append(">");
        s.append("<receive:=").append(this.getReceiveBufferSize()).append(">");
        s.append(", digest<").append(this.isResponseDigestEnabled() ? "on" : "off").append(">");
        s.append("<").append(this.getDigestAlgorithm()).append(">");
        s.append(", version<").append(this.getHTTPVersion()).append(">");
        s.append(", user-agent<").append(this.getUserAgent()).append(">");
        s.append(", redirects<").append(this.getFollowRedirects() ? "follow" : "ignore").append(">");
        return s.toString();
    }

    private void parseURL(String s) throws MalformedURLException {
        URL url = new URL(s);
        this.parseURL(url);
    }

    private void parseURL(URL url) throws MalformedURLException {
        String protocol = url.getProtocol();
        if ("http".equals(protocol)) {
            this.setProtocol(Protocol.HTTP);
        } else if ("https".equals(protocol)) {
            this.setProtocol(Protocol.HTTPS);
        } else {
            throw new MalformedURLException("URI schema \"" + protocol + ":\" not suppported");
        }
        String host = url.getHost();
        if (host == null || host.length() <= 0) {
            throw new MalformedURLException("URL must have a host part");
        }
        this.setHost(host);
        int port = url.getPort();
        if (port > 0 && !this.equalsDefaultPort(port)) {
            this.setPort(port);
        } else {
            this.setPort(this.getDefaultPort(this.protocol));
        }
        this.setBasePath(url.getPath());
    }

    private void parseProxyURL(String s) throws MalformedURLException {
        URL url = new URL(s);
        this.parseProxyURL(url);
    }

    private void parseProxyURL(URL url) throws MalformedURLException {
        String proxyHost = url.getHost();
        if (proxyHost == null || proxyHost.length() <= 0) {
            throw new MalformedURLException("Proxy URL must have a host part");
        }
        this.setProxyHost(proxyHost);
        int proxyPort = url.getPort();
        if (proxyPort > 0 && !this.equalsDefaultPort(proxyPort)) {
            this.setProxyPort(proxyPort);
        } else {
            this.setProxyPort(this.getDefaultPort(this.protocol));
        }
    }

    private boolean equalsDefaultPort(int port) {
        return this.protocol == Protocol.HTTP && port == 80 || port == 443;
    }

    private int getDefaultPort(Protocol protocol) {
        return protocol == Protocol.HTTP ? 80 : 443;
    }
}

