/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.streams;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.protocol.IResponseStream;
import com.tssap.dtr.client.lib.protocol.streams.ChunkedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;

public class ResponseStream
extends InputStream
implements IResponseStream {
    private InputStream in;
    private ChunkedInputStream base;
    private InflaterInputStream compressedStream;
    private DigestInputStream digestStream;
    private String compressionAlgorithm;
    private boolean compressionEnabled = false;
    private String digestAlgorithm;
    private boolean digestEnabled = false;
    private byte[] digest;
    private static final Location TRACE = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$protocol$streams$ResponseStream == null ? (class$com$tssap$dtr$client$lib$protocol$streams$ResponseStream = ResponseStream.class$("com.tssap.dtr.client.lib.protocol.streams.ResponseStream")) : class$com$tssap$dtr$client$lib$protocol$streams$ResponseStream));
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$protocol$streams$ResponseStream;

    public ResponseStream(Socket socket) throws IOException {
        this.base = new ChunkedInputStream(socket);
        this.in = this.base;
    }

    public ResponseStream(Socket socket, int size) throws IOException {
        this.base = new ChunkedInputStream(socket, size);
        this.in = this.base;
    }

    public ResponseStream(InputStream in, int size) throws IOException {
        this.base = new ChunkedInputStream(in, size);
        this.in = this.base;
    }

    public InputStream asStream() {
        return this;
    }

    public int available() throws IOException {
        if (this.in == null) {
            IOException ex = new IOException("stream is closed");
            TRACE.throwing("available()", (Throwable)ex);
            throw ex;
        }
        return this.in.available();
    }

    public int read() throws IOException {
        if (this.in == null) {
            IOException ex = new IOException("stream is closed");
            TRACE.throwing("read()", (Throwable)ex);
            throw ex;
        }
        return this.in.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.in == null) {
            IOException ex = new IOException("stream is closed");
            TRACE.throwing("read(byte[],int,int)", (Throwable)ex);
            throw ex;
        }
        int read = this.in.read(b, off, len);
        return read;
    }

    public int read(StringBuffer b, String enc) throws IOException, UnsupportedEncodingException {
        if (this.in == null) {
            IOException ex = new IOException("stream is closed");
            TRACE.throwing("read(StringBuffer,String)", (Throwable)ex);
            throw ex;
        }
        if (this.in == this.base) {
            return this.base.read(b, enc);
        }
        byte[] sb = new byte[16384];
        int read = this.in.read(sb);
        if (read <= 0) {
            return read;
        }
        b.append(new String(sb, 0, read, enc));
        while (this.in.available() > 0) {
            int cnt = this.in.read(sb);
            if (cnt <= 0) break;
            b.append(new String(sb, 0, cnt, enc));
            read += cnt;
        }
        return read;
    }

    public int read(OutputStream destination) throws IOException {
        if (this.in == null) {
            IOException ex = new IOException("stream is closed");
            TRACE.throwing("read(OutputStream)", (Throwable)ex);
            throw ex;
        }
        if (this.in == this.base) {
            return this.base.read(destination);
        }
        byte[] sb = new byte[16384];
        int read = this.in.read(sb);
        if (read <= 0) {
            return read;
        }
        destination.write(sb, 0, read);
        while (this.in.available() > 0) {
            int cnt = this.in.read(sb);
            if (cnt <= 0) break;
            destination.write(sb, 0, cnt);
            read += cnt;
        }
        return read;
    }

    public String readLine(boolean skipEmptyLines, boolean skipWhitespace) throws IOException {
        return this.base.readLine(skipEmptyLines, skipWhitespace);
    }

    public long skip(long n) throws IOException {
        if (this.in == null) {
            IOException ex = new IOException("stream is closed");
            TRACE.throwing("skip(long)", (Throwable)ex);
            throw ex;
        }
        return this.in.skip(n);
    }

    public void skipContent() throws IOException {
        if (this.in == null) {
            IOException ex = new IOException("stream is closed");
            TRACE.throwing("skipContent()", (Throwable)ex);
            throw ex;
        }
        if (this.in == this.base) {
            this.base.skipContent();
        } else {
            byte[] sb = new byte[512];
            try {
                while (this.in.read(sb) > 0) {
                }
            }
            catch (EOFException ex) {
                TRACE.catching("skipContent()", (Throwable)ex);
            }
        }
    }

    public void close() throws IOException {
        if (this.in != null) {
            if (this.in == this.base) {
                this.base.close();
            } else {
                this.in.close();
                this.in = this.base;
                this.compressedStream = null;
                this.digestStream = null;
                this.compressionEnabled = false;
                this.digestEnabled = false;
            }
        }
    }

    public void shutdown() {
        try {
            try {
                this.base.shutdown();
            }
            catch (Exception ex) {
                TRACE.catching("shutdown()", (Throwable)ex);
                Object var3_2 = null;
                this.compressedStream = null;
                this.in = null;
                this.base = null;
            }
            Object var3_1 = null;
            this.compressedStream = null;
            this.in = null;
            this.base = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.compressedStream = null;
            this.in = null;
            this.base = null;
            throw throwable;
        }
    }

    public void release() throws IOException {
        if (this.in == null) {
            IOException ex = new IOException("stream is closed");
            TRACE.throwing("release()", (Throwable)ex);
            throw ex;
        }
        this.close();
        this.disableLimit();
        this.enableChunking(false);
        this.disableWireTrace();
    }

    public void enableChunking(boolean enable) {
        this.base.enableChunking(enable);
    }

    public boolean chunking() {
        return this.base.chunking();
    }

    public void enableLimit(long limit) {
        this.base.enableLimit(limit);
    }

    public void disableLimit() {
        this.base.disableLimit();
    }

    public void enableWireTrace() {
        if (!this.compressionEnabled) {
            this.base.enableWireTrace();
        }
    }

    public void enableWireTrace(Location location) {
        if (!this.compressionEnabled) {
            this.base.enableWireTrace(location);
        }
    }

    public void disableWireTrace() {
        this.base.disableWireTrace();
    }

    public boolean isWireTraceEnabled() {
        return this.base.isWireTraceEnabled();
    }

    public String getCompressionAlgorithm() {
        return this.compressionAlgorithm;
    }

    public void setCompressionAlgorithm(String algorithm) {
        this.compressionAlgorithm = algorithm.toLowerCase();
    }

    public void enableCompression() throws IOException {
        if (this.in == null) {
            IOException ex = new IOException("stream is closed");
            TRACE.throwing("skip(long)", (Throwable)ex);
            throw ex;
        }
        try {
            if (this.compressionAlgorithm == null || this.compressionAlgorithm.equals("gzip")) {
                this.compressedStream = new GZIPInputStream(this.in);
                TRACE.debugT("enableCompression()", "GZIP decoding [enabled]");
            } else if (this.compressionAlgorithm.equals("deflate")) {
                this.compressedStream = new InflaterInputStream(this.in);
                TRACE.debugT("enableCompression()", "DEFLATE decoding [enabled]");
            } else {
                IOException ex = new IOException("unsupported content coding " + this.compressionAlgorithm);
                TRACE.throwing("enableCompression()", (Throwable)ex);
                throw ex;
            }
            this.in = this.compressedStream;
            this.compressionEnabled = true;
            this.base.disableWireTrace();
        }
        catch (EOFException ex) {
            TRACE.catching("enableCompression()", (Throwable)ex);
        }
    }

    public String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public void setDigestAlgorithm(String algorithm) {
        this.digestAlgorithm = algorithm;
    }

    public void enableDigest() throws IOException {
        if (this.in == null) {
            IOException ex = new IOException("stream is closed");
            TRACE.throwing("skip(long)", (Throwable)ex);
            throw ex;
        }
        try {
            if (this.digestAlgorithm == null) {
                this.digestStream = new DigestInputStream(this.in, MessageDigest.getInstance("MD5"));
                TRACE.debugT("enableDigest()", "MD5 digest [enabled]");
            } else {
                this.digestStream = new DigestInputStream(this.in, MessageDigest.getInstance(this.digestAlgorithm));
                TRACE.debugT("enableDigest()", "{0} digest [enabled]", new Object[]{this.digestAlgorithm});
            }
        }
        catch (NoSuchAlgorithmException ex) {
            TRACE.catching("enableDigest()", (Throwable)ex);
        }
        this.in = this.digestStream;
        this.digestEnabled = true;
        this.digest = null;
    }

    public byte[] getDigest() {
        return this.digest;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

