/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.streams;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.protocol.IRequestStream;
import com.tssap.dtr.client.lib.protocol.streams.ChunkedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;

public class RequestStream
extends OutputStream
implements IRequestStream {
    private OutputStream out;
    private ChunkedOutputStream base;
    private DeflaterOutputStream compressedStream;
    private String compressionAlgorithm;
    private boolean compressionEnabled = false;
    private static final Location TRACE = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$protocol$streams$RequestStream == null ? (class$com$tssap$dtr$client$lib$protocol$streams$RequestStream = RequestStream.class$("com.tssap.dtr.client.lib.protocol.streams.RequestStream")) : class$com$tssap$dtr$client$lib$protocol$streams$RequestStream));
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$protocol$streams$RequestStream;

    public RequestStream(Socket socket) throws IOException {
        this.base = new ChunkedOutputStream(socket);
        this.out = this.base;
    }

    public RequestStream(Socket socket, int size) throws IOException {
        this.base = new ChunkedOutputStream(socket, size);
        this.out = this.base;
    }

    public RequestStream(OutputStream out, int size) throws IOException {
        this.base = new ChunkedOutputStream(out, size);
        this.out = this.base;
    }

    public void write(int b) throws IOException {
        this.out.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    public void write(String s, String enc) throws IOException, UnsupportedEncodingException {
        if (this.out == this.base) {
            this.base.write(s, enc);
        } else {
            this.out.write(s.getBytes(enc));
        }
    }

    public void write(InputStream source) throws IOException {
        if (this.out == this.base) {
            this.base.write(source);
        } else {
            byte[] sb = new byte[16384];
            int read = source.read(sb);
            while (read > 0) {
                this.out.write(sb, 0, read);
                read = source.read(sb);
            }
        }
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void close() throws IOException {
        this.out.close();
    }

    public OutputStream asStream() {
        return this;
    }

    public void shutdown() {
        try {
            try {
                this.close();
                this.base.shutdown();
            }
            catch (Exception ex) {
                TRACE.catching("shutdown()", (Throwable)ex);
                Object var3_2 = null;
                this.compressedStream = null;
                this.out = null;
                this.base = null;
            }
            Object var3_1 = null;
            this.compressedStream = null;
            this.out = null;
            this.base = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.compressedStream = null;
            this.out = null;
            this.base = null;
            throw throwable;
        }
    }

    public void enableChunking(boolean enable) throws IOException {
        this.base.enableChunking(enable);
    }

    public boolean chunking() {
        return this.base.chunking();
    }

    public void enableLimit(long limit) throws IOException {
        this.base.enableLimit(limit);
    }

    public void disableLimit() throws IOException {
        this.base.disableLimit();
    }

    public String getCompressionAlgorithm() {
        return this.compressionAlgorithm;
    }

    public void setCompressionAlgorithm(String algorithm) {
        this.compressionAlgorithm = algorithm.toLowerCase();
    }

    public void enableCompression() throws IOException {
        if (this.compressionAlgorithm == null || this.compressionAlgorithm.equals("gzip")) {
            this.compressedStream = new GZIPOutputStream(this.base);
            this.out = this.compressedStream;
            this.compressionEnabled = true;
            TRACE.debugT("enableCompression()", "GZIP encoding [enabled]");
        } else if (this.compressionAlgorithm.equals("deflate")) {
            this.compressedStream = new DeflaterOutputStream(this.base);
            this.out = this.compressedStream;
            this.compressionEnabled = true;
            TRACE.debugT("enableCompression()", "DEFLATE encoding [enabled]");
        } else {
            IOException ex = new IOException("unsupported content coding " + this.compressionAlgorithm);
            TRACE.throwing("enableCompression()", (Throwable)ex);
            throw ex;
        }
    }

    public void enableWireTrace() {
        if (!this.compressionEnabled) {
            this.base.enableWireTrace();
        }
    }

    public void enableWireTrace(Location location) {
        if (!this.compressionEnabled) {
            this.base.enableWireTrace(location);
        }
    }

    public void disableWireTrace() {
        this.base.disableWireTrace();
    }

    public boolean isWireTraceEnabled() {
        return this.base.isWireTraceEnabled();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

