/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.streams;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.protocol.IResponseStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class PartitionInputStream
extends InputStream
implements IResponseStream {
    private static final int DEFAULT_SIZE = 4096;
    private static final String END_OF_LINE = "\r\n";
    protected byte[] buf;
    protected int count = 0;
    protected int pos = 0;
    private IResponseStream in;
    private boolean readingPart;
    private byte[] partBoundary;
    private long partCount = -1L;
    private int matchNext;
    private int markBoundary = -1;
    private static Location TRACE = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$protocol$streams$PartitionInputStream == null ? (class$com$tssap$dtr$client$lib$protocol$streams$PartitionInputStream = PartitionInputStream.class$("com.tssap.dtr.client.lib.protocol.streams.PartitionInputStream")) : class$com$tssap$dtr$client$lib$protocol$streams$PartitionInputStream));
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$protocol$streams$PartitionInputStream;

    public PartitionInputStream(IResponseStream in) {
        this(in, 4096);
    }

    public PartitionInputStream(IResponseStream in, int size) {
        this.in = in;
        this.buf = new byte[size];
    }

    public InputStream asStream() {
        return this;
    }

    public int available() throws IOException {
        return this.in.available() + this.count - this.pos;
    }

    public int read() throws IOException {
        int avail = this.count - this.pos;
        if (avail <= 0 && (avail = this.fill()) <= 0) {
            return -1;
        }
        int b = this.buf[this.pos++] & 0xFF;
        return b;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int cnt;
        int read = cnt = this.readAvailable(b, off, len);
        while (cnt > 0) {
            cnt = this.readAvailable(b, off + read, len - read);
            if (cnt <= 0) continue;
            read += cnt;
        }
        return read;
    }

    public int read(StringBuffer b, String enc) throws IOException, UnsupportedEncodingException {
        int cnt;
        int read = cnt = this.readAvailable(b, enc);
        while (cnt > 0) {
            cnt = this.readAvailable(b, enc);
            if (cnt <= 0) continue;
            read += cnt;
        }
        return read;
    }

    public int read(OutputStream destination) throws IOException {
        int cnt;
        int read = cnt = this.readAvailable(destination);
        while (cnt > 0) {
            cnt = this.readAvailable(destination);
            if (cnt <= 0) continue;
            read += cnt;
        }
        return read;
    }

    public String readLine(boolean skipEmptyLines, boolean skipWhitespace) throws IOException {
        StringBuffer b = new StringBuffer();
        String result = null;
        boolean done = false;
        block5: while (!done) {
            int next = this.in.read();
            switch (next) {
                case -1: {
                    result = skipWhitespace ? b.toString().trim() : b.toString();
                    done = true;
                    break;
                }
                case 10: {
                    if (b.length() == 0) {
                        if (skipEmptyLines) continue block5;
                        result = END_OF_LINE;
                        done = true;
                        break;
                    }
                    result = skipWhitespace ? b.toString().trim() : b.toString();
                    done = true;
                    break;
                }
                case 13: {
                    break;
                }
                default: {
                    b.append((char)next);
                }
            }
        }
        if (result == null) {
            IOException ex = new IOException("unexpected end of stream");
            TRACE.throwing("readLine(boolean,boolean)", (Throwable)ex);
            throw ex;
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public long skip(long n) throws IOException {
        skipped = this.skipAvailable(n);
        if (skipped > 0L) ** GOTO lbl6
        return skipped;
        while ((cnt = this.skipAvailable(n)) > 0L) {
            skipped += cnt;
lbl6:
            // 2 sources

            if (skipped < n && this.in.available() > 0) continue;
        }
        return skipped;
    }

    public void skipContent() throws IOException {
        while (this.skipAvailable() > 0L) {
        }
    }

    public void close() throws IOException {
        this.in.close();
        this.readingPart = false;
        this.matchNext = 0;
        this.markBoundary = -1;
    }

    public void release() throws IOException {
        this.in.release();
        this.readingPart = false;
        this.matchNext = 0;
        this.markBoundary = -1;
    }

    public void enableWireTrace() {
        this.in.enableWireTrace();
    }

    public void enableWireTrace(Location location) {
        this.in.enableWireTrace(location);
    }

    public void disableWireTrace() {
        this.in.disableWireTrace();
    }

    public boolean isWireTraceEnabled() {
        return this.in.isWireTraceEnabled();
    }

    public void beginPart(long contentLength) throws IOException {
        if (this.readingPart) {
            this.skipContent();
            this.endPart(true);
        }
        this.readingPart = true;
        this.partCount = contentLength;
        this.partBoundary = null;
        this.matchNext = 0;
        this.markBoundary = -1;
    }

    public void beginPart(byte[] boundary) throws IOException {
        if (this.readingPart) {
            this.skipContent();
            this.endPart(true);
        }
        this.readingPart = true;
        this.partCount = -1L;
        this.partBoundary = boundary;
        this.matchNext = 0;
        this.markBoundary = -1;
        if (boundary.length > this.buf.length) {
            byte[] newbuf = new byte[boundary.length];
            System.arraycopy(this.buf, this.pos, newbuf, 0, this.count - this.pos);
            this.buf = newbuf;
        }
    }

    public void beginPart(byte[] boundary, long contentLength) throws IOException {
        this.beginPart(boundary);
        this.partCount = contentLength;
    }

    public void endPart() throws IOException {
        if (this.readingPart) {
            this.skipContent();
            this.readingPart = false;
            this.matchNext = 0;
            this.markBoundary = -1;
        }
    }

    public void endPart(boolean skipBoundary) throws IOException {
        if (this.readingPart) {
            this.endPart();
            if (skipBoundary && this.partBoundary != null) {
                this.skip(this.partBoundary.length);
            }
        }
    }

    private int readAvailable(byte[] b, int off, int len) throws IOException {
        int avail = this.count - this.pos;
        if (this.readingPart) {
            if (this.partCount == 0L) {
                return -1;
            }
            if (this.partCount > 0L) {
                avail = (long)avail < this.partCount ? avail : (int)this.partCount;
            } else if (this.matchNext > 0) {
                avail = 0;
            }
        }
        if (avail <= 0 && (avail = this.fill()) <= 0) {
            return -1;
        }
        int cnt = avail < len ? avail : len;
        System.arraycopy(this.buf, this.pos, b, off, cnt);
        this.pos += cnt;
        this.partCount -= (long)cnt;
        return cnt;
    }

    private int readAvailable(StringBuffer b, String enc) throws IOException, UnsupportedEncodingException {
        int avail = this.count - this.pos;
        if (this.readingPart) {
            if (this.partCount == 0L) {
                return -1;
            }
            if (this.partCount > 0L) {
                avail = (long)avail < this.partCount ? avail : (int)this.partCount;
            } else if (this.matchNext > 0) {
                avail = 0;
            }
        }
        if (avail <= 0 && (avail = this.fill()) <= 0) {
            return -1;
        }
        b.append(new String(this.buf, this.pos, avail, enc));
        this.pos += avail;
        this.partCount -= (long)avail;
        return avail;
    }

    private int readAvailable(OutputStream destination) throws IOException {
        int avail = this.count - this.pos;
        if (this.readingPart) {
            if (this.partCount == 0L) {
                return -1;
            }
            if (this.partCount > 0L) {
                avail = (long)avail < this.partCount ? avail : (int)this.partCount;
            } else if (this.matchNext > 0) {
                avail = 0;
            }
        }
        if (avail <= 0 && (avail = this.fill()) <= 0) {
            return -1;
        }
        destination.write(this.buf, this.pos, avail);
        this.pos += avail;
        this.partCount -= (long)avail;
        return avail;
    }

    private long skipAvailable() throws IOException {
        long avail = this.count - this.pos;
        if (this.readingPart) {
            if (this.partCount == 0L) {
                return -1L;
            }
            if (this.partCount > 0L) {
                avail = avail < this.partCount ? avail : (long)((int)this.partCount);
            } else if (this.matchNext > 0) {
                avail = 0L;
            }
        }
        if (avail <= 0L && (avail = (long)this.fill()) <= 0L) {
            return -1L;
        }
        this.pos = (int)((long)this.pos + avail);
        this.partCount -= avail;
        return avail;
    }

    private long skipAvailable(long n) throws IOException {
        long avail = this.count - this.pos;
        if (this.readingPart) {
            if (this.partCount == 0L) {
                return -1L;
            }
            if (this.partCount > 0L) {
                avail = avail < this.partCount ? avail : (long)((int)this.partCount);
            } else if (this.matchNext > 0) {
                avail = 0L;
            }
        }
        if (avail <= 0L && (avail = (long)this.fill()) <= 0L) {
            return -1L;
        }
        long cnt = avail < n ? avail : n;
        this.pos = (int)((long)this.pos + cnt);
        this.partCount -= cnt;
        return cnt;
    }

    private int fill() throws IOException {
        int n;
        if (this.markBoundary < 0) {
            this.pos = 0;
            this.count = 0;
            n = this.in.read(this.buf, 0, this.buf.length);
            if (n < 0) {
                return -1;
            }
            this.count = n;
        } else {
            this.pos = 0;
            this.count -= this.markBoundary;
            System.arraycopy(this.buf, this.markBoundary, this.buf, 0, this.count);
            n = this.in.read(this.buf, this.count, this.buf.length - this.count);
            if (n < 0) {
                return -1;
            }
            this.count += n;
        }
        if (this.readingPart && this.count > 0) {
            if (this.partCount > 0L) {
                return (long)this.count < this.partCount ? this.count : (int)this.partCount;
            }
            int cnt = this.indexOf(this.partBoundary) - this.pos;
            if (cnt >= 0) {
                if (this.markBoundary < 0) {
                    this.partCount = cnt;
                }
                return cnt;
            }
        }
        return this.count;
    }

    private int indexOf(byte[] b) {
        int i = this.pos + this.matchNext;
        byte first = b[this.matchNext];
        block0: while (true) {
            if (i < this.count && this.buf[i] != first) {
                ++i;
                continue;
            }
            if (i == this.count) {
                this.markBoundary = -1;
                return -1;
            }
            ++this.matchNext;
            int j = i + 1;
            while (j < this.count && this.matchNext < this.partBoundary.length) {
                if (this.buf[j++] == b[this.matchNext++]) continue;
                ++i;
                this.matchNext = 0;
                continue block0;
            }
            break;
        }
        if (this.matchNext < this.partBoundary.length) {
            this.markBoundary = i;
        } else if (this.markBoundary >= 0) {
            i = this.pos;
            this.matchNext = 0;
            this.markBoundary = -1;
        } else {
            this.matchNext = 0;
            this.markBoundary = -1;
        }
        return i;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

