/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.ssl.util;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.protocol.ssl.util.ICertificateImport;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;

public class X509CertificateImport
implements ICertificateImport {
    private static Location TRACE = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$protocol$ssl$util$X509CertificateImport == null ? (class$com$tssap$dtr$client$lib$protocol$ssl$util$X509CertificateImport = X509CertificateImport.class$("com.tssap.dtr.client.lib.protocol.ssl.util.X509CertificateImport")) : class$com$tssap$dtr$client$lib$protocol$ssl$util$X509CertificateImport));
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$protocol$ssl$util$X509CertificateImport;

    public KeyStore importCertificates(InputStream certStream, String password) throws KeyStoreException, CertificateException {
        KeyStore ks = null;
        CertificateFactory cf = null;
        try {
            cf = CertificateFactory.getInstance("X.509", "IAIK");
            ks = KeyStore.getInstance("IAIKKeyStore", "IAIK");
        }
        catch (NoSuchProviderException e) {
            TRACE.catching("importCertificates(InputStream,String)", (Throwable)e);
            cf = CertificateFactory.getInstance("X.509");
            ks = KeyStore.getInstance("JKS");
        }
        try {
            ks.load(null, null);
        }
        catch (Exception e) {
            throw new KeyStoreException("Unable to create keystore: " + e.getMessage());
        }
        X509Certificate cert = (X509Certificate)cf.generateCertificate(certStream);
        String principal = cert.getSubjectDN().getName();
        ks.setCertificateEntry(principal, cert);
        return ks;
    }

    public boolean hasClientCertificates() {
        return false;
    }

    public List getClientAliases() {
        return Collections.EMPTY_LIST;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

