/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.ssl.util;

import com.tssap.dtr.client.lib.protocol.ssl.util.ICertificateImport;
import iaik.pkcs.pkcs12.CertificateBag;
import iaik.pkcs.pkcs12.KeyBag;
import iaik.pkcs.pkcs12.PKCS12;
import iaik.security.provider.IAIK;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchProviderException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PKCS12CertificateImport
implements ICertificateImport {
    private Map localKeyIDs = new HashMap();
    private List clientAliases = new ArrayList();

    public boolean hasClientCertificates() {
        return this.clientAliases.size() > 0;
    }

    public List getClientAliases() {
        return this.clientAliases;
    }

    public KeyStore importCertificates(InputStream certStream, String password) throws KeyStoreException, CertificateException {
        PKCS12 pkcs12 = null;
        try {
            pkcs12 = new PKCS12(certStream);
            pkcs12.decrypt(password.toCharArray());
        }
        catch (Exception e) {
            throw new CertificateException("Unable to import from PKCS12 stream: " + e.getMessage());
        }
        KeyStore ks = null;
        try {
            ks = KeyStore.getInstance("IAIKKeyStore", "IAIK");
        }
        catch (NoSuchProviderException e) {
            throw new KeyStoreException("Unable to create keystore: " + e.getMessage());
        }
        try {
            ks.load(null, null);
        }
        catch (Exception e) {
            throw new KeyStoreException("Unable to create keystore: " + e.getMessage());
        }
        CertificateBag[] certs = pkcs12.getCertificateBags();
        int i = 0;
        while (i < certs.length) {
            iaik.x509.X509Certificate cert = certs[i].getCertificate();
            byte[] id = certs[i].getLocalKeyID();
            if (id != null) {
                this.localKeyIDs.put(new String(id), this.getPrincipal((X509Certificate)cert));
            }
            ks.setCertificateEntry(this.getPrincipal((X509Certificate)cert), (Certificate)cert);
            ++i;
        }
        KeyBag[] keys = pkcs12.getKeyBags();
        int i2 = 0;
        while (i2 < keys.length) {
            Certificate[] chain = this.getCertificateChain(ks, keys[i2]);
            String principal = this.getPrincipal(chain[0]);
            this.clientAliases.add(principal);
            ks.setKeyEntry(principal, keys[i2].getPrivateKey(), password.toCharArray(), chain);
            ++i2;
        }
        return ks;
    }

    private String getPrincipal(X509Certificate cert) {
        return cert.getSubjectDN().getName();
    }

    private X509Certificate[] getCertificateChain(KeyStore ks, KeyBag key) throws KeyStoreException {
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        String subject = (String)this.localKeyIDs.get(new String(key.getLocalKeyID()));
        X509Certificate cert = (X509Certificate)ks.getCertificate(subject);
        if (cert == null) {
            throw new KeyStoreException("Private key must have a certificate chain [missing certificate for " + subject + "]");
        }
        String issuer = cert.getIssuerDN().getName();
        while (!subject.equals(issuer)) {
            certs.add(cert);
            subject = issuer;
            cert = (X509Certificate)ks.getCertificate(subject);
            if (cert == null) {
                throw new KeyStoreException("Private key must have a complete certificate chain [missing certificate for " + subject + "]");
            }
            issuer = cert.getIssuerDN().getName();
        }
        certs.add(cert);
        return certs.toArray(new X509Certificate[certs.size()]);
    }

    static {
        IAIK.addAsJDK14Provider();
    }
}

