/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.session;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.protocol.IAuthenticator;
import com.tssap.dtr.client.lib.protocol.IConnection;
import com.tssap.dtr.client.lib.protocol.IRequest;
import com.tssap.dtr.client.lib.protocol.IResponse;
import com.tssap.dtr.client.lib.protocol.ISessionContext;
import com.tssap.dtr.client.lib.protocol.URL;
import com.tssap.dtr.client.lib.protocol.session.BasicAuthenticator;
import com.tssap.dtr.client.lib.protocol.session.Certificates;
import com.tssap.dtr.client.lib.protocol.session.Cookie;
import com.tssap.dtr.client.lib.protocol.session.Cookies;
import com.tssap.dtr.client.lib.protocol.session.DigestAuthenticator;
import com.tssap.dtr.client.lib.protocol.session.SSO2Authenticator;
import com.tssap.dtr.client.lib.protocol.util.Pair;
import com.tssap.dtr.client.lib.protocol.util.Query;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class SessionContext
implements ISessionContext {
    private String user;
    private String password;
    private IAuthenticator authenticator;
    private String proxyUser;
    private String proxyPassword;
    private IAuthenticator proxyAuthenticator;
    private Cookies cookies;
    private Certificates certificates;
    private boolean sendCookies = true;
    private boolean sendAuthentication = true;
    private boolean sendSessionQueries = true;
    private Query sessionQuery = new Query();
    private List logoutSessionIDs = new ArrayList();
    private boolean performLogout = false;
    private static Location TRACE = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$protocol$session$SessionContext == null ? (class$com$tssap$dtr$client$lib$protocol$session$SessionContext = SessionContext.class$("com.tssap.dtr.client.lib.protocol.session.SessionContext")) : class$com$tssap$dtr$client$lib$protocol$session$SessionContext));
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$protocol$session$SessionContext;

    public SessionContext() {
    }

    public SessionContext(String user, String password) {
        this();
        this.setUser(user);
        this.setPassword(password);
    }

    public SessionContext(String user, String password, String authScheme) throws NoSuchAlgorithmException {
        this();
        this.setUser(user);
        this.setPassword(password);
        this.setAuthenticator(authScheme);
    }

    public SessionContext(String user, String password, IAuthenticator authenticator) {
        this();
        this.setUser(user);
        this.setPassword(password);
        this.setAuthenticator(authenticator);
    }

    public SessionContext(Certificates certificates) {
        this();
        if (certificates != null) {
            certificates = new Certificates(certificates);
        }
    }

    public SessionContext(ISessionContext context) {
        this(context.getUser(), context.getPassword());
        this.setSendCookies(context.getSendCookies());
        this.setSendAuthentication(context.getSendAuthentication());
        IAuthenticator auth = context.getAuthenticator();
        if (auth != null) {
            this.setAuthenticator(SessionContext.createAuthenticator(this, auth));
        }
        this.cookies().setCookies(context.cookies().getCookies());
        this.certificates = new Certificates(context.certificates());
    }

    public void closeSession() {
        this.cookies().removeAll();
        if (this.authenticator != null) {
            this.authenticator.reset();
        }
        if (this.logoutSessionIDs != null) {
            Iterator it = this.logoutSessionIDs.iterator();
            while (it.hasNext()) {
                Pair next = (Pair)it.next();
                this.sessionQuery.appendQueryParameter(next);
            }
            this.performLogout = true;
        }
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public void setProxyUser(String user) {
        this.proxyUser = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String password) {
        this.proxyPassword = password;
    }

    public boolean getSendCookies() {
        return this.sendCookies;
    }

    public void setSendCookies(boolean enable) {
        this.sendCookies = enable;
    }

    public Cookies cookies() {
        if (this.cookies == null) {
            this.cookies = new Cookies();
        }
        return this.cookies;
    }

    public Certificates certificates() {
        if (this.certificates == null) {
            this.certificates = new Certificates();
        }
        return this.certificates;
    }

    public List getCookies(String host, String path) {
        return this.cookies().getCookies(host, path);
    }

    public void setCookie(Cookie cookie) {
        this.cookies().setCookie(cookie);
    }

    public boolean getSendAuthentication() {
        return this.sendAuthentication;
    }

    public void setSendAuthentication(boolean enable) {
        this.sendAuthentication = enable;
    }

    public IAuthenticator getAuthenticator() {
        return this.authenticator;
    }

    public void setAuthenticator(IAuthenticator authenticator) {
        TRACE.infoT("setupCredentials(IResponse)", "authentication scheme changed [new scheme={0}]", new Object[]{authenticator.getAuthenticationScheme()});
        this.authenticator = authenticator;
    }

    public void setAuthenticator(String authScheme) throws NoSuchAlgorithmException {
        this.authenticator = SessionContext.createAuthenticator(this, authScheme, false);
        TRACE.infoT("setupCredentials(IResponse)", "authentication scheme changed [new scheme={0}]", new Object[]{this.authenticator.getAuthenticationScheme()});
    }

    public IAuthenticator getProxyAuthenticator() {
        return this.proxyAuthenticator;
    }

    public void setProxyAuthenticator(IAuthenticator authenticator) {
        TRACE.infoT("setupCredentials(IResponse)", "proxy authentication scheme changed [new scheme={0}]", new Object[]{this.proxyAuthenticator.getAuthenticationScheme()});
        this.proxyAuthenticator = authenticator;
    }

    public void setProxyAuthenticator(String authScheme) throws NoSuchAlgorithmException {
        this.proxyAuthenticator = SessionContext.createAuthenticator(this, authScheme, true);
        TRACE.infoT("setupCredentials(IResponse)", "proxy authentication scheme changed [new scheme={0}]", new Object[]{this.proxyAuthenticator.getAuthenticationScheme()});
    }

    public void enableServerSessionTrace(String id, String level) {
        this.sessionQuery.appendQueryParameter(id, "scope-session,level-" + level.toLowerCase());
        this.logoutSessionIDs.add(new Pair(id, "scope-none", '='));
    }

    public static IAuthenticator createAuthenticator(ISessionContext context, String authScheme, boolean forProxy) throws NoSuchAlgorithmException {
        String scheme = authScheme.toLowerCase();
        if (scheme.startsWith("digest")) {
            return new DigestAuthenticator(context, forProxy);
        }
        if (scheme.startsWith("basic")) {
            return new BasicAuthenticator(context, forProxy);
        }
        if (scheme.startsWith("sso2")) {
            return new SSO2Authenticator(context);
        }
        throw new NoSuchAlgorithmException("Unknown authentication scheme [" + authScheme + "]");
    }

    public static IAuthenticator createAuthenticator(IAuthenticator auth) {
        String scheme = auth.getAuthenticationScheme().toLowerCase();
        ISessionContext ctx = auth.getSessionContext();
        if (scheme.startsWith("digest")) {
            return new DigestAuthenticator(ctx, (DigestAuthenticator)auth);
        }
        if (scheme.startsWith("basic")) {
            return new BasicAuthenticator(ctx, (BasicAuthenticator)auth);
        }
        if (scheme.startsWith("sso2")) {
            return new SSO2Authenticator(ctx, (SSO2Authenticator)auth);
        }
        return auth;
    }

    public static IAuthenticator createAuthenticator(ISessionContext context, IAuthenticator auth) {
        String scheme = auth.getAuthenticationScheme().toLowerCase();
        if (scheme.startsWith("digest")) {
            return new DigestAuthenticator(context, (DigestAuthenticator)auth);
        }
        if (scheme.startsWith("basic")) {
            return new BasicAuthenticator(context, (BasicAuthenticator)auth);
        }
        if (scheme.startsWith("sso2")) {
            return new SSO2Authenticator(context, (SSO2Authenticator)auth);
        }
        return auth;
    }

    public void applyCookies(IRequest request, IConnection connection) {
        if (this.sendCookies) {
            this.cookies().applyCookies(request, connection);
        }
    }

    public void setupCookies(IResponse response, IConnection connection) {
        this.cookies().setupCookies(response, connection);
    }

    public void applyCredentials(URL uri, IRequest request) {
        if (this.sendAuthentication) {
            if (this.authenticator != null) {
                this.authenticator.applyCredentials(uri, request);
            }
            if (this.proxyAuthenticator != null) {
                this.proxyAuthenticator.applyCredentials(uri, request);
            }
        }
    }

    public void setupCredentials(IResponse response) {
        String authScheme;
        if (this.authenticator == null && (authScheme = response.getHeaderValue("WWW-Authenticate")) != null) {
            try {
                this.setAuthenticator(authScheme);
            }
            catch (NoSuchAlgorithmException e) {
                TRACE.catching("setupCredentials(IResponse)", (Throwable)e);
                TRACE.infoT("setupCredentials(IResponse)", "Ignoring credentials due to unknown or invalid authentication scheme [{0}]", new Object[]{authScheme});
            }
        }
        if (this.authenticator != null) {
            this.authenticator.setupCredentials(response);
        }
        if (this.proxyAuthenticator == null && (authScheme = response.getHeaderValue("Proxy-Authenticate")) != null) {
            try {
                this.setProxyAuthenticator(authScheme);
            }
            catch (NoSuchAlgorithmException e) {
                TRACE.catching("setupCredentials(IResponse)", (Throwable)e);
                TRACE.infoT("setupCredentials(IResponse)", "Ignoring proxy credentials due to unknown or invalid proxy authentication scheme [{0}]", new Object[]{authScheme});
            }
        }
        if (this.proxyAuthenticator != null) {
            this.proxyAuthenticator.setupCredentials(response);
        }
    }

    public void applyQueryParameters(IRequest request) {
        if (this.sendSessionQueries) {
            Query query = request.getQuery();
            if (query == null) {
                query = new Query();
            }
            query.appendQuery(this.sessionQuery);
            request.setQuery(query);
            if (this.performLogout) {
                Iterator it = this.logoutSessionIDs.iterator();
                while (it.hasNext()) {
                    this.sessionQuery.removeQueryParameter(((Pair)it.next()).getName());
                }
                this.logoutSessionIDs.clear();
                this.performLogout = false;
            }
        }
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("user<").append(this.user != null ? this.user : "unknown user").append(">");
        s.append(", auth<");
        s.append(this.authenticator != null ? this.authenticator.getAuthenticationScheme() : "none");
        s.append(">");
        s.append(", cookies<").append(this.sendCookies ? "allowed" : "blocked").append(">");
        if (this.sendCookies) {
            s.append("<privacy:").append(this.cookies().getPrivacy().toString()).append(">");
            Iterator blocked = this.cookies().rejectedDomains().iterator();
            if (blocked.hasNext()) {
                s.append("<blocked-sites:");
                while (blocked.hasNext()) {
                    s.append(" \"").append((String)blocked.next()).append("\"");
                }
                s.append(">");
            }
        }
        return s.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

