/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.session;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.protocol.IAuthenticator;
import com.tssap.dtr.client.lib.protocol.IRequest;
import com.tssap.dtr.client.lib.protocol.IResponse;
import com.tssap.dtr.client.lib.protocol.ISessionContext;
import com.tssap.dtr.client.lib.protocol.URL;
import com.tssap.dtr.client.lib.protocol.session.BasicAuthenticator;
import com.tssap.dtr.client.lib.protocol.session.Cookie;
import com.tssap.dtr.client.lib.protocol.session.DigestAuthenticator;
import com.tssap.dtr.client.lib.protocol.session.SessionContext;
import java.util.List;

public class SSO2Authenticator
implements IAuthenticator {
    private ISessionContext context;
    private String ticket;
    private URL originalHost;
    private IAuthenticator login;
    private boolean forProxyAuthentication = false;
    public static final String SSO_COOKIE_NAME = "MYSAPSSO2";
    public static final String AUTH_SCHEME = "SSO2";
    private static Location TRACE = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$protocol$session$SSO2Authenticator == null ? (class$com$tssap$dtr$client$lib$protocol$session$SSO2Authenticator = SSO2Authenticator.class$("com.tssap.dtr.client.lib.protocol.session.SSO2Authenticator")) : class$com$tssap$dtr$client$lib$protocol$session$SSO2Authenticator));
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$protocol$session$SSO2Authenticator;

    public SSO2Authenticator(ISessionContext context) {
        this.context = context;
    }

    public SSO2Authenticator(ISessionContext context, String ticket) {
        this.context = context;
        this.ticket = ticket;
    }

    public SSO2Authenticator(ISessionContext context, IAuthenticator login) {
        this.context = context;
        this.login = login;
    }

    public SSO2Authenticator(ISessionContext context, String ticket, IAuthenticator login) {
        this.context = context;
        this.login = login;
        this.ticket = ticket;
    }

    public SSO2Authenticator(ISessionContext context, SSO2Authenticator auth) {
        this(context);
        this.forProxyAuthentication = auth.forProxyAuthentication();
        IAuthenticator loginAuthenticator = auth.login;
        if (loginAuthenticator != null) {
            this.login = SessionContext.createAuthenticator(context, loginAuthenticator);
        }
        this.ticket = auth.ticket;
        this.originalHost = auth.originalHost;
    }

    public String getAuthenticationScheme() {
        return AUTH_SCHEME;
    }

    public IAuthenticator getLoginAuthenticator() {
        return this.login;
    }

    public void setLoginAuthenticator(IAuthenticator login) {
        this.login = login;
    }

    public void setLoginAuthenticator(String loginScheme) {
        this.login = this.createAuthenticator(this.context, loginScheme);
    }

    public ISessionContext getSessionContext() {
        return this.context;
    }

    public String getTicket() {
        return this.ticket;
    }

    public void setTicket(String ticket) {
        this.ticket = ticket;
    }

    public String getOriginalDomain() {
        return this.originalHost.getDomain();
    }

    public void applyCredentials(URL uri, IRequest request) {
        if (this.ticket != null) {
            Cookie sso2cookie = new Cookie(SSO_COOKIE_NAME, this.ticket, uri.getDomain(), uri.getPath());
            request.setHeader("Cookie", sso2cookie.toString(), true);
        } else if (this.login != null) {
            this.login.applyCredentials(uri, request);
        }
    }

    public void setupCredentials(IResponse response) {
        List matches;
        if (response.getStatus() == 407) {
            this.forProxyAuthentication = true;
        }
        if ((matches = this.context.cookies().searchCookiesByName(SSO_COOKIE_NAME)).size() == 1) {
            Cookie sso2Cookie = (Cookie)matches.get(0);
            this.ticket = sso2Cookie.getValue();
            this.originalHost = sso2Cookie.getOriginalHost();
            TRACE.infoT("setupCredentials(IResponse)", "Received Single Sign On ({0}) ticket for  domain \"{1}\". Switching to SSO2 authentication.", new Object[]{SSO_COOKIE_NAME, sso2Cookie.getDomain()});
            this.context.cookies().removeCookie(sso2Cookie);
        } else {
            if (this.login == null) {
                String auth = null;
                if (response.getStatus() == 401) {
                    auth = response.getHeaderValue("WWW-Authenticate");
                } else if (response.getStatus() == 407) {
                    auth = response.getHeaderValue("Proxy-Authenticate");
                }
                if (auth != null) {
                    this.login = this.createAuthenticator(this.context, auth);
                }
            }
            if (this.login != null) {
                this.login.setupCredentials(response);
            }
        }
    }

    public void reset() {
        this.ticket = null;
        this.originalHost = null;
        if (this.login != null) {
            this.login.reset();
        }
    }

    public boolean forProxyAuthentication() {
        return false;
    }

    private IAuthenticator createAuthenticator(ISessionContext context, String authScheme) {
        String scheme = authScheme.toLowerCase();
        if (scheme.startsWith("digest")) {
            return new DigestAuthenticator(context);
        }
        if (scheme.startsWith("basic")) {
            return new BasicAuthenticator(context);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

