/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.session;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.protocol.URL;
import com.tssap.dtr.client.lib.protocol.util.Pair;
import com.tssap.dtr.client.lib.protocol.util.Tokenizer;
import java.util.Arrays;
import java.util.List;

public final class Cookie
implements Comparable {
    private String name;
    private String value;
    private String comment;
    private String commentURL;
    private boolean discard = false;
    private String domain;
    private long maxAge = -1L;
    private String path = "/";
    private int[] portList;
    private String ports;
    private boolean secure = false;
    private int version = 1;
    private boolean valid = false;
    private long expirationTime = -1L;
    private URL originalHost;
    private static Location TRACE = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$protocol$session$Cookie == null ? (class$com$tssap$dtr$client$lib$protocol$session$Cookie = Cookie.class$("com.tssap.dtr.client.lib.protocol.session.Cookie")) : class$com$tssap$dtr$client$lib$protocol$session$Cookie));
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$protocol$session$Cookie;

    public Cookie(String name, String value, String domain, String path) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Cookie name must not be null or an empty string.");
        }
        if (value == null || value.length() == 0) {
            throw new IllegalArgumentException("Cookie value must not be null or an empty string.");
        }
        if (this.version != 1) {
            throw new IllegalArgumentException("Cookie version not supported.");
        }
        if (domain == null || domain.length() == 0) {
            domain = ".local";
        }
        if (!domain.equals(".local") && domain.indexOf(46, 1) == -1) {
            throw new IllegalArgumentException("Invalid cookie domain.");
        }
        this.name = name;
        this.value = value;
        this.domain = domain;
        if (path != null && path.length() > 0) {
            this.path = path.startsWith("/") ? path : "/" + path;
        }
        this.valid = true;
    }

    public Cookie(String cookieHeader, URL requestUrl, boolean lazy) {
        this.initialize(cookieHeader);
        String requestDomain = Cookie.getDomainOf(requestUrl.getHost());
        if (this.domain == null) {
            this.domain = requestDomain;
        }
        this.path = this.path == null ? requestUrl.getPath() : (this.path.startsWith("/") ? this.path : "/" + this.path);
        this.originalHost = new URL(requestUrl.getProtocol(), requestUrl.getHost(), requestUrl.getPort(), "/");
        this.valid = this.checkValidity(requestDomain, requestUrl.getPort(), lazy);
    }

    public Cookie(Cookie cookie) {
        this.name = cookie.getName();
        this.value = cookie.getValue();
        this.comment = cookie.getComment();
        this.commentURL = cookie.getCommentURL();
        this.discard = cookie.getDiscard();
        this.domain = cookie.getDomain();
        this.maxAge = cookie.getMaxAge();
        this.path = cookie.getPath();
        this.ports = cookie.getPorts();
        int[] plist = cookie.getPortList();
        this.portList = new int[plist.length];
        if (plist.length > 0) {
            System.arraycopy(plist, 0, this.portList, 0, plist.length);
        }
        this.secure = cookie.requiresSecurity();
        this.version = cookie.getVersion();
        this.valid = cookie.isValid();
        this.expirationTime = cookie.getExpires();
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getComment() {
        return this.comment;
    }

    public String getCommentURL() {
        return this.commentURL;
    }

    public boolean getDiscard() {
        return this.discard;
    }

    public String getDomain() {
        return this.domain;
    }

    public long getMaxAge() {
        return this.maxAge;
    }

    public long getExpires() {
        return this.expirationTime;
    }

    public String getPath() {
        return this.path;
    }

    public int[] getPortList() {
        return this.portList;
    }

    public String getPorts() {
        return this.ports;
    }

    public boolean requiresSecurity() {
        return this.secure;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean isValid() {
        return this.valid;
    }

    public URL getOriginalHost() {
        return this.originalHost;
    }

    public boolean matchesHost(String host) {
        return this.domain.equals(Cookie.getDomainOf(host));
    }

    public boolean matchesPath(String requestPath) {
        return this.path == null || this.path != null && requestPath.startsWith(this.path);
    }

    public boolean matchesPort(int port) {
        return this.portList == null || port > 0 && Arrays.binarySearch(this.portList, port) >= 0;
    }

    public boolean matches(String host, String path) {
        return this.matches(host, path, -1);
    }

    public boolean matches(String host, String path, int port) {
        return this.matchesHost(host) && this.matchesPath(path) && this.matchesPort(port);
    }

    public boolean matches(URL url) {
        return this.matches(url.getHost(), url.getPath(), url.getPort());
    }

    public static String getDomainOf(String hostURL) {
        return URL.getDomainOf(hostURL);
    }

    public static int getPortOf(String hostURL) {
        int hostPort = -1;
        int m = hostURL.lastIndexOf(58);
        if (m > 0) {
            try {
                hostPort = Integer.parseInt(hostURL.substring(m + 1));
            }
            catch (NumberFormatException ex) {
                TRACE.catching("getPortOf(String)", (Throwable)ex);
            }
        }
        return hostPort;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("$Version=").append(this.version).append(';');
        s.append(this.name).append('=').append(this.value);
        if (this.path != null) {
            s.append(";$Path=").append(this.path);
        }
        if (!".local".equals(this.domain)) {
            s.append(";$Domain=").append(this.domain);
        }
        if (this.ports != null) {
            s.append(";$Port=\"").append(this.ports).append("\"");
        }
        return s.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Cookie)) {
            return false;
        }
        Cookie c = (Cookie)obj;
        if (!this.name.equals(c.name)) {
            return false;
        }
        if (!this.domain.equals(c.domain)) {
            return false;
        }
        if (this.path != null && c.path != null && !this.path.equals(c.path)) {
            return false;
        }
        return this.portList == null || c.portList == null || Arrays.equals(this.portList, c.portList);
    }

    public int hashCode() {
        int result = 17;
        result = this.name != null ? 37 * result + this.name.hashCode() : result;
        result = this.domain != null ? 37 * result + this.domain.hashCode() : result;
        int n = result = this.path != null ? 37 * result + this.path.hashCode() : result;
        if (this.portList != null) {
            int i = 0;
            while (i < this.portList.length) {
                result = 37 * result + this.portList[i];
                ++i;
            }
        }
        return result;
    }

    public int compareTo(Object obj) {
        int comp;
        if (!(obj instanceof Cookie)) {
            throw new ClassCastException();
        }
        Cookie c = (Cookie)obj;
        if (!this.domain.equals(c.domain)) {
            return this.domain.compareTo(c.domain);
        }
        if (this.path != null && c.path != null && ((comp = this.path.compareTo(c.path)) < 0 && c.path.startsWith(this.path) || comp > 0 && this.path.startsWith(c.path))) {
            return -comp;
        }
        if (!this.name.equals(c.name)) {
            return this.name.compareTo(c.name);
        }
        return 0;
    }

    private void initialize(String setCookieHeader) {
        List parts;
        if (setCookieHeader != null && (parts = Tokenizer.partsOf(setCookieHeader, ";", 0, 61)).size() > 0) {
            Pair p = (Pair)parts.get(0);
            this.name = p.getName();
            this.value = p.getValue();
            int i = 1;
            while (i < parts.size()) {
                p = (Pair)parts.get(i);
                String s = p.getName().toLowerCase();
                if (this.version == -1 && s.equals("version")) {
                    try {
                        this.version = Integer.parseInt(p.getValue());
                    }
                    catch (NumberFormatException ex) {
                        TRACE.catching("initialize(String)", (Throwable)ex);
                        this.version = -1;
                    }
                } else if (s.equals("domain")) {
                    this.domain = p.getValue();
                    if (!this.domain.startsWith(".")) {
                        this.domain = "." + p.getValue();
                    }
                } else if (s.equals("discard")) {
                    this.discard = true;
                } else if (this.path == null && s.equals("path")) {
                    this.path = p.getValue();
                } else if (this.comment == null && s.equals("comment")) {
                    this.comment = p.getValue();
                } else if (this.commentURL == null && s.equals("commenturl")) {
                    this.commentURL = p.getValue();
                } else if (this.maxAge == -1L && s.equals("max-age")) {
                    try {
                        this.maxAge = Long.parseLong(p.getValue());
                    }
                    catch (NumberFormatException ex) {
                        TRACE.catching("initialize(String)", (Throwable)ex);
                        this.maxAge = -1L;
                    }
                    if (this.maxAge != -1L) {
                        this.expirationTime = System.currentTimeMillis() + this.maxAge * 1000L;
                    }
                } else if (this.portList == null && s.equals("port")) {
                    this.ports = p.getValue();
                    List plist = Tokenizer.partsOf(this.ports, ",");
                    this.portList = new int[plist.size()];
                    try {
                        int j = 0;
                        while (j < this.portList.length) {
                            this.portList[j] = Integer.parseInt((String)plist.get(j));
                            ++j;
                        }
                        Arrays.sort(this.portList);
                    }
                    catch (NumberFormatException ex) {
                        TRACE.catching("initialize(String)", (Throwable)ex);
                        this.portList = null;
                    }
                } else if (s.equals("secure")) {
                    this.secure = true;
                }
                ++i;
            }
        }
    }

    private boolean checkValidity(String hostDomain, int hostPort, boolean lazy) {
        if (this.name == null || this.value == null || this.name.length() == 0 || this.value.length() == 0 || this.version <= 0 || this.domain == null || this.domain.length() == 0) {
            return false;
        }
        if (!this.domain.equals(".local") && this.domain.indexOf(46, 1) == -1) {
            return false;
        }
        if (!lazy) {
            if (!hostDomain.equals(this.domain)) {
                return false;
            }
            if (this.portList != null && hostPort > 0 && Arrays.binarySearch(this.portList, hostPort) < 0) {
                return false;
            }
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

