/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.session;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.protocol.IAuthenticator;
import com.tssap.dtr.client.lib.protocol.IRequest;
import com.tssap.dtr.client.lib.protocol.IResponse;
import com.tssap.dtr.client.lib.protocol.ISessionContext;
import com.tssap.dtr.client.lib.protocol.URL;
import com.tssap.dtr.client.lib.protocol.util.Encoder;

public final class BasicAuthenticator
implements IAuthenticator {
    private ISessionContext context;
    private boolean forProxyAuthentication = false;
    private static Location TRACE = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$protocol$session$BasicAuthenticator == null ? (class$com$tssap$dtr$client$lib$protocol$session$BasicAuthenticator = BasicAuthenticator.class$("com.tssap.dtr.client.lib.protocol.session.BasicAuthenticator")) : class$com$tssap$dtr$client$lib$protocol$session$BasicAuthenticator));
    public static final String AUTH_SCHEME = "Basic";
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$protocol$session$BasicAuthenticator;

    public BasicAuthenticator(ISessionContext context) {
        this.context = context;
    }

    public BasicAuthenticator(ISessionContext context, boolean forProxyAuthentication) {
        this.context = context;
        this.forProxyAuthentication = forProxyAuthentication;
    }

    public BasicAuthenticator(ISessionContext context, BasicAuthenticator auth) {
        this(context);
        this.forProxyAuthentication = auth.forProxyAuthentication();
    }

    public String getAuthenticationScheme() {
        return AUTH_SCHEME;
    }

    public ISessionContext getSessionContext() {
        return this.context;
    }

    public void applyCredentials(URL uri, IRequest request) {
        String header;
        String user = this.forProxyAuthentication ? this.context.getProxyUser() : this.context.getUser();
        String password = this.forProxyAuthentication ? this.context.getProxyPassword() : this.context.getPassword();
        String string = header = this.forProxyAuthentication ? "Proxy-Authorization" : "Authorization";
        if (user == null || password == null) {
            TRACE.warningT("applyCredentials(String,IRequest)", "no credentials applied [user or password undefined]");
            return;
        }
        request.setHeader(header, "Basic " + Encoder.encodeBase64(user + ":" + password));
    }

    public void setupCredentials(IResponse response) {
        if (response.getStatus() == 407) {
            this.forProxyAuthentication = true;
        }
    }

    public void reset() {
    }

    public boolean forProxyAuthentication() {
        return this.forProxyAuthentication;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

