/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.requests.xcm;

import com.tssap.dtr.client.lib.protocol.IRequestEntity;
import com.tssap.dtr.client.lib.protocol.XCM;
import com.tssap.dtr.client.lib.protocol.entities.MultiStatusEntity;
import com.tssap.dtr.client.lib.protocol.entities.ResourceElement;
import com.tssap.dtr.client.lib.protocol.entities.StringEntity;
import com.tssap.dtr.client.lib.protocol.requests.MultiStatusRequest;
import com.tssap.dtr.client.lib.protocol.util.Encoder;
import java.util.ArrayList;
import java.util.Iterator;

public class PopulatePropListRequest
extends MultiStatusRequest {
    private ArrayList entries;

    public PopulatePropListRequest(String path) {
        super("POPULATEPROPLIST", path);
    }

    public void addEntry(ActionEntry entry) {
        if (this.entries == null) {
            this.entries = new ArrayList();
        }
        this.entries.add(entry);
    }

    public int countResources() {
        MultiStatusEntity entity = MultiStatusEntity.valueOf(this.getResponse().getEntity());
        return entity != null ? entity.countResources() : 0;
    }

    public ResourceElement getResource(int i) {
        MultiStatusEntity entity = MultiStatusEntity.valueOf(this.getResponse().getEntity());
        return entity != null ? entity.getResource(i) : null;
    }

    public Iterator getResources() {
        MultiStatusEntity entity = MultiStatusEntity.valueOf(this.getResponse().getEntity());
        return entity != null ? entity.getResources() : null;
    }

    public IRequestEntity prepareRequestEntity() {
        StringEntity body = null;
        body = new StringEntity("text/xml", "UTF-8");
        body.append("<?xml version=\"1.0\" encoding=\"").append("utf-8").append("\"?>");
        body.append("<").append("XCM:").append("populateproplist");
        body.append(" xmlns=\"DAV:\"").append(XCM.PREFIXED_XMLNS).append(">");
        if (this.entries != null) {
            int i = 0;
            while (i < this.entries.size()) {
                ((ActionEntry)this.entries.get(i)).writeEntry(body);
                ++i;
            }
        }
        body.append("</").append("XCM:").append("populateproplist>");
        this.setRequestEntity(body);
        return body;
    }

    public final class ActionEntry {
        private Action action;
        private String rangeFrom;
        private String rangeTo;
        private ArrayList set;
        private ArrayList pathSet;
        private ArrayList excludePathSet;
        private String snapshot;
        private int sourceSelection = 0;
        private static final int BY_DATE = 1;
        private static final int BY_ISN = 2;
        private static final int BY_VERSION_SET = 3;
        private static final int BY_VCR_SET = 4;
        private static final int BY_ACTIVITY_SET = 5;
        private static final int BY_PROP_SET = 6;
        private static final int BY_SNAPSHOT = 7;

        public ActionEntry(Action action) {
            this.action = action;
            if (action == Action.REMOVE) {
                this.sourceSelection = 3;
            }
        }

        public void selectPath(String path) {
            if (this.action == Action.REMOVE || this.action == Action.REMOVE_ALL) {
                throw new IllegalStateException("Method not allowed for action REMOVE");
            }
            if (this.pathSet == null) {
                this.pathSet = new ArrayList();
            }
            this.pathSet.add(path);
        }

        public void selectPaths(String[] paths) {
            if (this.action == Action.REMOVE || this.action == Action.REMOVE_ALL) {
                throw new IllegalStateException("Method not allowed for action REMOVE");
            }
            if (this.pathSet == null) {
                this.pathSet = new ArrayList();
            }
            int i = 0;
            while (i < paths.length) {
                this.pathSet.add(paths[i]);
                ++i;
            }
        }

        public void selectExcludedPath(String path) {
            if (this.action == Action.REMOVE || this.action == Action.REMOVE_ALL) {
                throw new IllegalStateException("Method not allowed for action REMOVE");
            }
            if (this.excludePathSet == null) {
                this.excludePathSet = new ArrayList();
            }
            this.excludePathSet.add(path);
        }

        public void selectExcludedPaths(String[] paths) {
            if (this.action == Action.REMOVE || this.action == Action.REMOVE_ALL) {
                throw new IllegalStateException("Method not allowed for action REMOVE");
            }
            if (this.excludePathSet == null) {
                this.excludePathSet = new ArrayList();
            }
            int i = 0;
            while (i < paths.length) {
                this.excludePathSet.add(paths[i]);
                ++i;
            }
        }

        public void selectIntegrationDate(String from, String to) {
            if (this.action == Action.REMOVE || this.action == Action.REMOVE_ALL) {
                throw new IllegalStateException("Method not allowed for action REMOVE");
            }
            this.rangeFrom = from;
            this.rangeTo = to;
            this.sourceSelection = 1;
        }

        public void selectIntegrationSequenceRange(int from, int to) {
            if (this.action == Action.REMOVE || this.action == Action.REMOVE_ALL) {
                throw new IllegalStateException("Method not allowed for action REMOVE");
            }
            this.rangeFrom = Integer.toString(from);
            this.rangeTo = Integer.toString(to);
            this.sourceSelection = 2;
        }

        public void selectVersionSet(String[] versionSet) {
            if (this.action == Action.REMOVE_ALL) {
                throw new IllegalStateException("Method not allowed for action REMOVE_ALL");
            }
            this.selectSet(versionSet, 3);
        }

        public void selectVCRSet(String[] vcrSet) {
            if (this.action == Action.REMOVE || this.action == Action.REMOVE_ALL) {
                throw new IllegalStateException("Method not allowed for action REMOVE");
            }
            this.selectSet(vcrSet, 4);
        }

        public void selectActivitySet(String[] activitySet) {
            if (this.action == Action.REMOVE || this.action == Action.REMOVE_ALL) {
                throw new IllegalStateException("Method not allowed for action REMOVE");
            }
            this.selectSet(activitySet, 5);
        }

        public void selectPropagationSet(String[] propagationSet) {
            if (this.action == Action.REMOVE || this.action == Action.REMOVE_ALL) {
                throw new IllegalStateException("Method not allowed for action REMOVE");
            }
            this.selectSet(propagationSet, 6);
        }

        public void selectSnapshot(String snapshot) {
            if (this.action == Action.REMOVE || this.action == Action.REMOVE_ALL) {
                throw new IllegalStateException("Method not allowed for action REMOVE");
            }
            this.snapshot = snapshot;
            this.sourceSelection = 7;
        }

        public void selectSnapshotNow() {
            this.selectSnapshot(null);
        }

        private void selectSet(String[] newSet, int select) {
            if (this.set == null) {
                this.set = new ArrayList();
            } else if (this.sourceSelection != select) {
                this.set.clear();
            }
            int i = 0;
            while (i < newSet.length) {
                this.set.add(newSet[i]);
                ++i;
            }
            this.sourceSelection = select;
        }

        private void writeEntry(StringEntity body) {
            if (this.action == Action.ADD || this.action == Action.REPLACE) {
                if (this.sourceSelection > 0) {
                    int i;
                    body.append("<").append("XCM:").append(this.action.toString()).append(">");
                    if (this.pathSet != null) {
                        body.append("<").append("XCM:").append("path-set>");
                        i = 0;
                        while (i < this.pathSet.size()) {
                            body.append("<").append("XCM:").append("path>");
                            body.append(Encoder.encodeXml((String)this.pathSet.get(i)));
                            body.append("</").append("XCM:").append("path>");
                            ++i;
                        }
                        body.append("</").append("XCM:").append("path-set>");
                    }
                    if (this.excludePathSet != null) {
                        body.append("<").append("XCM:").append("exclude-path-set>");
                        i = 0;
                        while (i < this.excludePathSet.size()) {
                            body.append("<").append("XCM:").append("path>");
                            body.append(Encoder.encodeXml((String)this.excludePathSet.get(i)));
                            body.append("</").append("XCM:").append("path>");
                            ++i;
                        }
                        body.append("</").append("XCM:").append("exclude-path-set>");
                    }
                    switch (this.sourceSelection) {
                        case 1: {
                            body.append("<").append("XCM:").append("integration-date>");
                            this.writeRange(body);
                            body.append("</").append("XCM:").append("integration-date>");
                            break;
                        }
                        case 2: {
                            body.append("<").append("XCM:").append("integration-sequence-range>");
                            this.writeRange(body);
                            body.append("</").append("XCM:").append("integration-sequence-range>");
                            break;
                        }
                        case 3: {
                            body.append("<version-set>");
                            this.writeSet(body);
                            body.append("</version-set>");
                            break;
                        }
                        case 4: {
                            body.append("<").append("XCM:").append("vcr-set>");
                            this.writeSet(body);
                            body.append("</").append("XCM:").append("vcr-set>");
                            break;
                        }
                        case 5: {
                            body.append("<activity-set>");
                            this.writeSet(body);
                            body.append("</activity-set>");
                            break;
                        }
                        case 6: {
                            body.append("<").append("XCM:").append("propagation-set>");
                            this.writeSet(body);
                            body.append("</").append("XCM:").append("propagation-set>");
                            break;
                        }
                        case 7: {
                            body.append("<").append("XCM:").append("snapshot");
                            if (this.snapshot == null) {
                                body.append("/>");
                                break;
                            }
                            body.append(">").append(Encoder.encodeXml(this.snapshot));
                            body.append("<").append("XCM:").append("/snapshot>");
                            break;
                        }
                        default: {
                            body = null;
                        }
                    }
                    body.append("</").append("XCM:").append(this.action.toString()).append(">");
                }
            } else if (this.action == Action.REMOVE) {
                body.append("<version-set>");
                this.writeSet(body);
                body.append("</version-set>");
            } else if (this.action == Action.REMOVE_ALL) {
                body.append("</").append("XCM:").append("all>");
            }
        }

        private void writeRange(StringEntity body) {
            body.append("<").append("XCM:").append("from>");
            body.append(Encoder.encodeXml(this.rangeFrom));
            body.append("</").append("XCM:").append("from>");
            body.append("<").append("XCM:").append("to>");
            body.append(Encoder.encodeXml(this.rangeTo));
            body.append("</").append("XCM:").append("to>");
        }

        private void writeSet(StringEntity body) {
            if (this.set != null) {
                int i = 0;
                while (i < this.set.size()) {
                    body.append("<href>").append(Encoder.encodeXml((String)this.set.get(i))).append("</href>");
                    ++i;
                }
            }
        }
    }

    public static final class Action {
        private final String name;
        public static final Action ADD = new Action("add");
        public static final Action REPLACE = new Action("replace");
        public static final Action REMOVE = new Action("remove");
        public static final Action REMOVE_ALL = new Action("remove all");

        private Action(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

