/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.requests.xcm;

import com.tssap.dtr.client.lib.protocol.IRequestEntity;
import com.tssap.dtr.client.lib.protocol.XCM;
import com.tssap.dtr.client.lib.protocol.entities.MultiStatusEntity;
import com.tssap.dtr.client.lib.protocol.entities.ResourceElement;
import com.tssap.dtr.client.lib.protocol.entities.StringEntity;
import com.tssap.dtr.client.lib.protocol.requests.MultiStatusRequest;
import com.tssap.dtr.client.lib.protocol.util.Encoder;
import java.util.Iterator;

public class IntegrateRequest
extends MultiStatusRequest {
    private String source;
    private boolean keepActive = false;
    private boolean forceIntegrated = false;

    public IntegrateRequest(String path, String source) {
        super("INTEGRATE", path);
        this.source = source;
    }

    public void keepActiveVersions() {
        this.keepActive = true;
        this.forceIntegrated = false;
    }

    public void forceIntegratedVersions() {
        this.keepActive = false;
        this.forceIntegrated = true;
    }

    public int countResources() {
        MultiStatusEntity entity = MultiStatusEntity.valueOf(this.getResponse().getEntity());
        return entity != null ? entity.countResources() : 0;
    }

    public ResourceElement getResource(int i) {
        MultiStatusEntity entity = MultiStatusEntity.valueOf(this.getResponse().getEntity());
        return entity != null ? entity.getResource(i) : null;
    }

    public Iterator getResources() {
        MultiStatusEntity entity = MultiStatusEntity.valueOf(this.getResponse().getEntity());
        return entity != null ? entity.getResources() : null;
    }

    public IRequestEntity prepareRequestEntity() {
        StringEntity body = null;
        if (this.source != null) {
            body = new StringEntity("text/xml", "UTF-8");
            body.append("<?xml version=\"1.0\" encoding=\"").append("utf-8").append("\"?>");
            body.append("<").append("XCM:").append("integrate");
            body.append(" xmlns=\"DAV:\"").append(XCM.PREFIXED_XMLNS).append(">");
            body.append("<").append("XCM:").append("source><href>").append(Encoder.encodeXml(this.source)).append("</href></").append("XCM:").append("source>");
            if (this.keepActive) {
                body.append("<").append("XCM:").append("options><").append("XCM:").append("keep-workspace-version/></").append("XCM:").append("options>");
            } else if (this.forceIntegrated) {
                body.append("<").append("XCM:").append("options><").append("XCM:").append("force-integrate-version/></").append("XCM:").append("options>");
            }
            body.append("</").append("XCM:").append("integrate>");
        }
        this.setRequestEntity(body);
        return body;
    }
}

