/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.requests.xcm;

import com.tssap.dtr.client.lib.protocol.HTTPException;
import com.tssap.dtr.client.lib.protocol.IResponse;
import com.tssap.dtr.client.lib.protocol.IResponseEntity;
import com.tssap.dtr.client.lib.protocol.requests.XMLRequest;

public class ExportRequest
extends XMLRequest {
    private static final String EXPORT_MODE = "export-mode";
    private static final String RELOCATION_REPOSITORYID = "relocation-repositoryid";
    private static final String SEGEMENTED_EXPORT_SUPPORT = "export-in-segments-allowed";
    public static final String WORKING_PROPAGATABLE = "working-propagatable-id";

    public ExportRequest(String path) {
        super("EXPORT", path);
        this.setDefaultParser(this);
    }

    public IResponseEntity parse(String path, IResponse response) throws HTTPException {
        IResponseEntity entity = null;
        if (response.getStatus() != 200) {
            entity = super.parse(path, response);
        }
        return entity;
    }

    public void setExportMode(int mode) {
        this.removeHeader(EXPORT_MODE);
        this.setHeader(EXPORT_MODE, String.valueOf(mode));
    }

    public void setRelocationRepositoryID(String repositoryID) {
        this.removeHeader(RELOCATION_REPOSITORYID);
        this.setHeader(RELOCATION_REPOSITORYID, repositoryID);
    }

    public void setAllowSegmentedExport(boolean segmentedExportSupport) {
        this.removeHeader(SEGEMENTED_EXPORT_SUPPORT);
        this.setHeader(SEGEMENTED_EXPORT_SUPPORT, segmentedExportSupport ? "true" : "false");
    }
}

