/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.requests.xcm;

import com.tssap.dtr.client.lib.protocol.IRequestEntity;
import com.tssap.dtr.client.lib.protocol.XCM;
import com.tssap.dtr.client.lib.protocol.entities.StringEntity;
import com.tssap.dtr.client.lib.protocol.requests.XMLRequest;
import com.tssap.dtr.client.lib.protocol.util.Encoder;

public class DiscardRequest
extends XMLRequest {
    private String discardTarget;
    private String activity;
    private String targetWorkspace;
    private boolean undoDiscard = false;

    public DiscardRequest(String path, String discardTarget, String activity, String targetWorkspace) {
        super("DISCARD", path);
        this.discardTarget = discardTarget;
        this.activity = activity;
        this.targetWorkspace = targetWorkspace;
    }

    public void undoDiscard() {
        this.undoDiscard = true;
    }

    public IRequestEntity prepareRequestEntity() {
        StringEntity body = null;
        body = new StringEntity("text/xml", "UTF-8");
        body.append("<?xml version=\"1.0\" encoding=\"").append("utf-8").append("\"?>");
        body.append("<").append("XCM:").append("discard");
        body.append(" xmlns=\"DAV:\"").append(XCM.PREFIXED_XMLNS).append(">");
        if (this.undoDiscard) {
            body.append("<").append("XCM:").append("undo-discard/>");
        }
        body.append("<").append("XCM:").append("discard-target><href>").append(Encoder.encodeXml(this.discardTarget));
        body.append("</href></").append("XCM:").append("discard-target>");
        body.append("<activity-set><href>").append(Encoder.encodeXml(this.activity)).append("</href></activity-set>");
        if (!this.undoDiscard) {
            body.append("<").append("XCM:").append("target-workspace><href>").append(Encoder.encodeXml(this.targetWorkspace)).append("</href></").append("XCM:").append("target-workspace>");
        }
        body.append("</").append("XCM:").append("discard>");
        this.setRequestEntity(body);
        return body;
    }
}

