/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.requests.xcm;

import com.tssap.dtr.client.lib.protocol.IRequestEntity;
import com.tssap.dtr.client.lib.protocol.XCM;
import com.tssap.dtr.client.lib.protocol.entities.CollisionState;
import com.tssap.dtr.client.lib.protocol.entities.CollisionType;
import com.tssap.dtr.client.lib.protocol.entities.MultiStatusEntity;
import com.tssap.dtr.client.lib.protocol.entities.ResourceElement;
import com.tssap.dtr.client.lib.protocol.entities.StringEntity;
import com.tssap.dtr.client.lib.protocol.requests.MultiStatusRequest;
import com.tssap.dtr.client.lib.protocol.requests.dav.ExpandPropertyDef;
import com.tssap.dtr.client.lib.protocol.util.Encoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class CollisionReport
extends MultiStatusRequest {
    private ExpandPropertyDef top;
    private ArrayList properties;
    private HashMap namespaces;
    private ArrayList workspaceSet;
    private String activeVersionOwner;
    private String integrateVersionOwner;
    private String owner;
    private String creationDateFrom;
    private String creationDateTo;
    private String createdBy;
    private String resolutionDateFrom;
    private String resolutionDateTo;
    private String resolvedBy;
    private String sequenceNumber;
    private String resolvingSequenceNumber;
    private String integratedActivity;
    private String resolvingActivity;
    private CollisionState collisionState = CollisionState.ALL;
    private CollisionType collisionType = CollisionType.ALL;

    public CollisionReport(String path) {
        super("REPORT", path);
        this.top = new ExpandPropertyDef("");
        this.addNamespace("XCM:", XCM.NAMESPACE);
    }

    public void addSelectProperty(String propertyName) {
        if (this.properties == null) {
            this.properties = new ArrayList();
        }
        this.properties.add(propertyName);
    }

    public void addSelectProperty(String propertyName, String namespaceURI) {
        int n = propertyName.indexOf(58);
        if (n > 0) {
            this.addNamespace(propertyName.substring(0, n), namespaceURI);
        }
        this.addSelectProperty(propertyName);
    }

    public void addSelectProperty(String[] propertyNames) {
        if (this.properties == null) {
            this.properties = new ArrayList();
        }
        int i = 0;
        while (i < propertyNames.length) {
            this.properties.add(propertyNames[i]);
            ++i;
        }
    }

    public ExpandPropertyDef addPropertyExpand(String propertyName, ExpandPropertyDef parent) {
        ExpandPropertyDef property = new ExpandPropertyDef(propertyName);
        this.addPropertyExpand(property, parent);
        return property;
    }

    public ExpandPropertyDef addPropertyExpand(String propertyName, String namespaceURI, ExpandPropertyDef parent) {
        ExpandPropertyDef property = new ExpandPropertyDef(propertyName, namespaceURI);
        this.addPropertyExpand(property, parent);
        return property;
    }

    public void addPropertyExpand(ExpandPropertyDef property, ExpandPropertyDef parent) {
        if (parent != null) {
            parent.addChild(property);
        } else {
            this.top.addChild(property);
        }
    }

    public void addNamespace(String prefix, String namespaceURI) {
        if (this.namespaces == null) {
            this.namespaces = new HashMap();
        }
        if (prefix.endsWith(":")) {
            this.namespaces.put(prefix.substring(0, prefix.length() - 1), namespaceURI);
        } else {
            this.namespaces.put(prefix, namespaceURI);
        }
    }

    public void addWorkspaceQuery(String workspace) {
        if (this.workspaceSet == null) {
            this.workspaceSet = new ArrayList();
        }
        this.workspaceSet.add(workspace);
    }

    public void addOwnerQuery(String owner) {
        this.owner = owner;
    }

    public void addActiveVersionOwnerQuery(String owner) {
        this.activeVersionOwner = owner;
    }

    public void addIntegrateVersionOwnerQuery(String owner) {
        this.integrateVersionOwner = owner;
    }

    public void addCollisionStateQuery(CollisionState collisionState) {
        this.collisionState = collisionState;
    }

    public void addCreationDateQuery(String from, String to) {
        this.creationDateFrom = from;
        this.creationDateTo = to;
    }

    public void addCreatedByQuery(String creator) {
        this.createdBy = creator;
    }

    public void addResolutionDateQuery(String from, String to) {
        this.resolutionDateFrom = from;
        this.resolutionDateTo = to;
    }

    public void addResolvedByQuery(String resolver) {
        this.resolvedBy = resolver;
    }

    public void addIntegrateSequenceQuery(String sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public void addResolvingSequenceQuery(String sequenceNumber) {
        this.resolvingSequenceNumber = sequenceNumber;
    }

    public void addIntegratedActivityQuery(String activity) {
        this.integratedActivity = activity;
    }

    public void addResolvingActivityQuery(String activity) {
        this.resolvingActivity = activity;
    }

    public void addCollisionTypeQuery(CollisionType collisionType) {
        this.collisionType = collisionType;
    }

    public int countResources() {
        MultiStatusEntity entity = MultiStatusEntity.valueOf(this.getResponse().getEntity());
        return entity != null ? entity.countResources() : 0;
    }

    public ResourceElement getResource(int i) {
        MultiStatusEntity entity = MultiStatusEntity.valueOf(this.getResponse().getEntity());
        return entity != null ? entity.getResource(i) : null;
    }

    public Iterator getResources() {
        MultiStatusEntity entity = MultiStatusEntity.valueOf(this.getResponse().getEntity());
        return entity != null ? entity.getResources() : null;
    }

    public IRequestEntity prepareRequestEntity() {
        StringEntity body = null;
        body = new StringEntity("text/xml", "UTF-8");
        body.append("<?xml version=\"1.0\" encoding=\"").append("utf-8").append("\"?>");
        body.append("<").append("XCM:").append("collision-query");
        body.append(" xmlns=\"DAV:\"");
        if (this.namespaces != null && this.namespaces.size() > 0) {
            Iterator keys = this.namespaces.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                body.append(" xmlns:").append(key).append("=\"").append(this.namespaces.get(key)).append("\"");
            }
        }
        body.append(">");
        if (this.properties != null || this.top.firstChild != null) {
            body.append("<").append("XCM:").append("select>");
            if (this.properties != null) {
                body.append("<prop>");
                int i = 0;
                while (i < this.properties.size()) {
                    body.append("<").append(this.properties.get(i)).append("/>");
                    ++i;
                }
                body.append("</prop>");
            }
            if (this.top.firstChild != null) {
                ExpandPropertyDef child = this.top.firstChild;
                while (child != null) {
                    this.appendChildren(body, child);
                    child = child.next;
                }
            }
            body.append("</").append("XCM:").append("select>");
        }
        body.append("<").append("XCM:").append("where>");
        if (this.workspaceSet != null) {
            body.append("<").append("XCM:").append("workspace-set>");
            int i = 0;
            while (i < this.workspaceSet.size()) {
                body.append("<href>").append(Encoder.encodeXml((String)this.workspaceSet.get(i))).append("</href>");
                ++i;
            }
            body.append("</").append("XCM:").append("workspace-set>");
        }
        if (this.activeVersionOwner != null) {
            body.append("<").append("XCM:").append("active-version-owner>").append(Encoder.encodeXml(this.activeVersionOwner)).append("</").append("XCM:").append("active-version-owner>");
        }
        if (this.integrateVersionOwner != null) {
            body.append("<").append("XCM:").append("integrate-version-owner>").append(Encoder.encodeXml(this.integrateVersionOwner)).append("</").append("XCM:").append("integrate-version-owner>");
        }
        if (this.owner != null) {
            body.append("<owner>").append(Encoder.encodeXml(this.owner)).append("</owner>");
        }
        if (this.collisionState != CollisionState.ALL) {
            body.append("<").append("XCM:").append("collision-state>").append(this.collisionState.toString()).append("</").append("XCM:").append("collision-state>");
        }
        if (this.creationDateFrom != null && this.creationDateTo != null) {
            body.append("<").append("XCM:").append("creation-date><").append("XCM:").append("from>").append(this.creationDateFrom).append("</").append("XCM:").append("from>");
            body.append("<").append("XCM:").append("to>").append(this.creationDateTo).append("</").append("XCM:").append("to></").append("XCM:").append("creation-date>");
        }
        if (this.createdBy != null) {
            body.append("<").append("XCM:").append("creator-displayname>").append(Encoder.encodeXml(this.createdBy)).append("</").append("XCM:").append("creator-displayname>");
        }
        if (this.resolutionDateFrom != null && this.resolutionDateTo != null) {
            body.append("<").append("XCM:").append("resolution-date><").append("XCM:").append("from>").append(this.resolutionDateFrom).append("</").append("XCM:").append("from>");
            body.append("<").append("XCM:").append("to>").append(this.resolutionDateTo).append("</").append("XCM:").append("to></").append("XCM:").append("resolution-date>");
        }
        if (this.sequenceNumber != null) {
            body.append("<").append("XCM:").append("isn>").append(this.sequenceNumber).append("</").append("XCM:").append("isn>");
        }
        if (this.collisionType != CollisionType.ALL) {
            body.append("<").append("XCM:").append("collision-type>").append(this.collisionType.toString()).append("</").append("XCM:").append("collision-type>");
        }
        if (this.resolvedBy != null) {
            body.append("<").append("XCM:").append("resolved-by>").append(Encoder.encodeXml(this.resolvedBy)).append("</").append("XCM:").append("resolved-by>");
        }
        if (this.resolvingSequenceNumber != null) {
            body.append("<").append("XCM:").append("resolving-isn>").append(this.resolvingSequenceNumber).append("</").append("XCM:").append("resolving-isn>");
        }
        if (this.integratedActivity != null) {
            body.append("<").append("XCM:").append("integrated-activity><href>").append(Encoder.encodeXml(this.integratedActivity)).append("</href></").append("XCM:").append("integrated-activity>");
        }
        if (this.resolvingActivity != null) {
            body.append("<").append("XCM:").append("resolving-activity><href>").append(Encoder.encodeXml(this.resolvingActivity)).append("</href></").append("XCM:").append("resolving-activity>");
        }
        body.append("</").append("XCM:").append("where>");
        body.append("</").append("XCM:").append("collision-query>");
        this.setRequestEntity(body);
        return body;
    }

    private void appendChildren(StringEntity body, ExpandPropertyDef property) {
        ExpandPropertyDef child;
        body.append("<property name=\"").append(property.name).append("\"");
        if (property.namespaceURI != null) {
            body.append(" namespace=\"").append(property.namespaceURI).append("\"");
        }
        if ((child = property.firstChild) == null) {
            body.append("/>");
        } else {
            body.append(">");
            while (child != null) {
                this.appendChildren(body, child);
                child = child.next;
            }
            body.append("</property>");
        }
    }
}

