/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.requests.xcm;

import com.tssap.dtr.client.lib.protocol.IRequestEntity;
import com.tssap.dtr.client.lib.protocol.XCM;
import com.tssap.dtr.client.lib.protocol.entities.MultiStatusEntity;
import com.tssap.dtr.client.lib.protocol.entities.ResourceElement;
import com.tssap.dtr.client.lib.protocol.entities.StringEntity;
import com.tssap.dtr.client.lib.protocol.requests.XMLRequest;
import com.tssap.dtr.client.lib.protocol.util.Encoder;
import java.util.HashSet;
import java.util.Iterator;

public class AdminOperationRequest
extends XMLRequest {
    public static final String ENCODING = "utf-8";
    private String workspaceRemotePath;
    private HashSet resourceTypes = new HashSet();
    private String comments;
    private boolean isPreview = false;
    private boolean forceReopenWorkspace = false;
    private static final int OPERATION_TYPE_GC = 1;
    private static final int OPERATION_TYPE_WS_DELETE = 2;
    private static final int OPERATION_TYPE_WS_STATE_UPDATE = 4;
    private static final String WORKSPACE_STATE_OPEN = "open";
    private static final String WORKSPACE_STATE_CLOSED = "closed";
    private String workspaceState;
    private int operationType = 0;

    public AdminOperationRequest(String path) {
        super("ADMINOPERATION", path);
        this.setDefaultParser(this);
        this.operationType = 1;
    }

    public AdminOperationRequest() {
        this("");
    }

    public IRequestEntity prepareRequestEntity() {
        StringEntity body = new StringEntity("text/xml", "UTF-8");
        body.append("<?xml version=\"1.0\" encoding=\"").append(ENCODING).append("\"?>");
        body.append("<").append("XCM:").append("admin");
        body.append(" xmlns:D=\"DAV:\"").append(XCM.PREFIXED_XMLNS).append(">");
        if (this.operationType == 2) {
            this.addDeleteWorkspaceTags(body);
        } else if (this.operationType == 1) {
            this.addGarbageCollectionTags(body);
        } else if (this.operationType == 4) {
            this.addWorkspaceStateUpdateTags(body);
        }
        if (this.isPreview) {
            body.append("<").append("XCM:").append("preview/>");
        }
        if (this.comments != null) {
            body.append("<").append("XCM:").append("shorttext>").append(Encoder.encodeXml(this.comments)).append("</").append("XCM:").append("shorttext>");
        }
        body.append("</").append("XCM:").append("admin>");
        this.setRequestEntity(body);
        return body;
    }

    private void addWorkspaceStateUpdateTags(StringEntity body) {
        body.append("<").append("XCM:").append("workspace-set-state>").append("<").append("D:").append("href>").append(Encoder.encodeXml(Encoder.encodeXml(this.workspaceRemotePath))).append("</").append("D:").append("href>").append("<").append("XCM:").append("state>").append(this.workspaceState).append("</").append("XCM:").append("state>");
        if (this.forceReopenWorkspace) {
            body.append("<").append("XCM:").append("force/>");
        }
        body.append("</").append("XCM:").append("workspace-set-state>");
    }

    private void addGarbageCollectionTags(StringEntity body) {
        body.append("<").append("XCM:").append("gc>");
        Iterator it = this.resourceTypes.iterator();
        while (it.hasNext()) {
            body.append("<").append("XCM:").append("resource-type>").append(Encoder.encodeXml(it.next().toString())).append("</").append("XCM:").append("resource-type>");
        }
        body.append("</").append("XCM:").append("gc>");
    }

    private void addDeleteWorkspaceTags(StringEntity body) {
        body.append("<").append("XCM:").append("delete>").append("<").append("D:").append("href>").append(Encoder.encodeXml(Encoder.encodeXml(this.workspaceRemotePath))).append("</").append("D:").append("href>").append("</").append("XCM:").append("delete>");
    }

    public void setResourceType(ResourceType resourceType) {
        this.resourceTypes.clear();
        this.addResourceType(resourceType);
    }

    public void addResourceType(ResourceType resourceType) {
        this.resourceTypes.add(resourceType);
    }

    public void setPreviewOnly(boolean preview) {
        this.isPreview = preview;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public void setWorkspaceToDelete(String workspaceRemotePath) {
        this.workspaceRemotePath = workspaceRemotePath;
        this.operationType = 2;
    }

    public void closeWorkspace(String workspaceRemotePath) {
        this.workspaceRemotePath = workspaceRemotePath;
        this.workspaceState = WORKSPACE_STATE_CLOSED;
        this.operationType = 4;
    }

    public void reOpenWorkspace(String workspaceRemotePath, boolean forceReopenWorkspace) {
        this.workspaceRemotePath = workspaceRemotePath;
        this.forceReopenWorkspace = forceReopenWorkspace;
        this.workspaceState = WORKSPACE_STATE_OPEN;
        this.operationType = 4;
    }

    public int countResources() {
        MultiStatusEntity entity = MultiStatusEntity.valueOf(this.getResponse().getEntity());
        return entity != null ? entity.countResources() : 0;
    }

    public ResourceElement getResource(int i) {
        MultiStatusEntity entity = MultiStatusEntity.valueOf(this.getResponse().getEntity());
        return entity != null ? entity.getResource(i) : null;
    }

    public Iterator getResources() {
        MultiStatusEntity entity = MultiStatusEntity.valueOf(this.getResponse().getEntity());
        return entity != null ? entity.getResources() : null;
    }

    public static final class ResourceType {
        private final String name;
        public static final ResourceType ACTIVITIES = new ResourceType("ACTIVITY");
        public static final ResourceType PROPAGATION_LISTS = new ResourceType("PROPAGATION_LIST");
        public static final ResourceType VERSIONED_RESOURCES = new ResourceType("VERSIONED_OBJECT");

        private ResourceType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

