/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.requests.xcm;

import com.tssap.dtr.client.lib.protocol.IRequestEntity;
import com.tssap.dtr.client.lib.protocol.XCM;
import com.tssap.dtr.client.lib.protocol.entities.MultiStatusEntity;
import com.tssap.dtr.client.lib.protocol.entities.ResourceElement;
import com.tssap.dtr.client.lib.protocol.entities.StringEntity;
import com.tssap.dtr.client.lib.protocol.requests.MultiStatusRequest;
import com.tssap.dtr.client.lib.protocol.requests.dasl.Query;
import com.tssap.dtr.client.lib.protocol.requests.dav.ExpandPropertyDef;
import com.tssap.dtr.client.lib.protocol.util.Encoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ActivityReport
extends MultiStatusRequest {
    private ExpandPropertyDef top = new ExpandPropertyDef("");
    private List properties;
    private Map namespaces;
    private List workspaceSet;
    private String user;
    private String displayName;
    private String namePrefix;
    private List propertyQueries;
    private int sequenceNumber = -1;
    private int sequenceNumberFrom = -1;
    private int sequenceNumberTo = -1;
    private boolean closedOnly;
    private boolean openedOnly;
    private boolean emptyOnly;
    private boolean nonEmptyOnly;
    private boolean createdInWorkspaceOnly;
    private boolean containsFiles;
    private boolean includePropagations;
    private boolean propagationsOnly;
    private boolean noPropgationRequestID = false;
    private String creationDateFrom;
    private String creationDateTo;
    private String integrationDateFrom;
    private String integrationDateTo;
    private List activitySet;

    public ActivityReport(String path) {
        super("REPORT", path);
        this.addNamespace("XCM:", XCM.NAMESPACE);
    }

    public void addSelectProperty(String propertyName) {
        if (this.properties == null) {
            this.properties = new ArrayList();
        }
        this.properties.add(propertyName);
    }

    public void addSelectProperty(String propertyName, String namespaceURI) {
        int n = propertyName.indexOf(58);
        if (n > 0) {
            this.addNamespace(propertyName.substring(0, n), namespaceURI);
        }
        this.addSelectProperty(propertyName);
    }

    public void addSelectProperty(String[] propertyNames) {
        if (this.properties == null) {
            this.properties = new ArrayList();
        }
        int i = 0;
        while (i < propertyNames.length) {
            this.properties.add(propertyNames[i]);
            ++i;
        }
    }

    public ExpandPropertyDef addPropertyExpand(String propertyName, ExpandPropertyDef parent) {
        ExpandPropertyDef property = new ExpandPropertyDef(propertyName);
        this.addPropertyExpand(property, parent);
        return property;
    }

    public ExpandPropertyDef addPropertyExpand(String propertyName, String namespaceURI, ExpandPropertyDef parent) {
        ExpandPropertyDef property = new ExpandPropertyDef(propertyName, namespaceURI);
        this.addPropertyExpand(property, parent);
        return property;
    }

    public void addPropertyExpand(ExpandPropertyDef property, ExpandPropertyDef parent) {
        if (parent != null) {
            parent.addChild(property);
        } else {
            this.top.addChild(property);
        }
    }

    public void addNamespace(String prefix, String namespaceURI) {
        if (this.namespaces == null) {
            this.namespaces = new HashMap();
        }
        if (prefix.endsWith(":")) {
            this.namespaces.put(prefix.substring(0, prefix.length() - 1), namespaceURI);
        } else {
            this.namespaces.put(prefix, namespaceURI);
        }
    }

    public void addWorkspaceQuery(String workspace) {
        if (this.workspaceSet == null) {
            this.workspaceSet = new ArrayList();
        }
        this.workspaceSet.add(workspace);
    }

    public void addUserQuery(String user) {
        this.user = user;
    }

    public void addNameQuery(String namePrefix) {
        this.namePrefix = namePrefix;
    }

    public void addPropertyEqualsQuery(String propertyName, String literal) {
        if (this.propertyQueries == null) {
            this.propertyQueries = new ArrayList();
        }
        this.propertyQueries.add(Query.equal(propertyName, literal));
    }

    public void addPropertyEqualsQuery(String propertyName, String literal, String namespaceURI) {
        int n = propertyName.indexOf(58);
        if (n > 0) {
            this.addNamespace(propertyName.substring(0, n), namespaceURI);
        }
        this.addPropertyEqualsQuery(propertyName, literal);
    }

    public void applyToClosedActivitiesOnly() {
        this.closedOnly = true;
        this.openedOnly = false;
    }

    public void applyToOpenActivitiesOnly() {
        this.closedOnly = false;
        this.openedOnly = true;
    }

    public void applyToEmptyActivitiesOnly() {
        this.emptyOnly = true;
        this.nonEmptyOnly = false;
    }

    public void applyToNonEmptyActivitiesOnly() {
        this.emptyOnly = false;
        this.nonEmptyOnly = true;
    }

    public void applyToActivitiesContainingFiles() {
        this.containsFiles = true;
    }

    public void applyToCreatedInWorkspaceOnly() {
        this.createdInWorkspaceOnly = true;
    }

    public void applyToPropagationsOnly() {
        this.propagationsOnly = true;
        this.includePropagations = false;
    }

    public void applyToPropagations() {
        this.includePropagations = true;
        this.propagationsOnly = false;
    }

    public void applyToActivitiesWithoutPropagationRequestId() {
        this.noPropgationRequestID = true;
    }

    public void addCreationDateQuery(String from, String to) {
        this.creationDateFrom = from;
        this.creationDateTo = to;
    }

    public void addIntegrationDateQuery(String from, String to) {
        this.integrationDateFrom = from;
        this.integrationDateTo = to;
    }

    public void addIntegrationSequenceQuery(int sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
        this.sequenceNumberFrom = -1;
        this.sequenceNumberTo = -1;
    }

    public void addIntegrationSequenceQuery(int from, int to) {
        this.sequenceNumberFrom = from;
        this.sequenceNumberTo = to;
        this.sequenceNumber = -1;
    }

    public void addActivityQuery(String activity) {
        if (this.activitySet == null) {
            this.activitySet = new ArrayList();
        }
        this.activitySet.add(activity);
    }

    public void addActivityQuery(String[] activities) {
        int i = 0;
        while (i < activities.length) {
            this.addActivityQuery(activities[i]);
            ++i;
        }
    }

    public int countResources() {
        MultiStatusEntity entity = MultiStatusEntity.valueOf(this.getResponse().getEntity());
        return entity != null ? entity.countResources() : 0;
    }

    public ResourceElement getResource(int i) {
        MultiStatusEntity entity = MultiStatusEntity.valueOf(this.getResponse().getEntity());
        return entity != null ? entity.getResource(i) : null;
    }

    public Iterator getResources() {
        MultiStatusEntity entity = MultiStatusEntity.valueOf(this.getResponse().getEntity());
        return entity != null ? entity.getResources() : null;
    }

    public IRequestEntity prepareRequestEntity() {
        StringEntity body = null;
        body = new StringEntity("text/xml", "UTF-8");
        body.append("<?xml version=\"1.0\" encoding=\"").append("utf-8").append("\"?>");
        body.append("<").append("XCM:").append("activity-query");
        body.append(" xmlns=\"DAV:\"");
        if (this.namespaces != null && this.namespaces.size() > 0) {
            Iterator keys = this.namespaces.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                body.append(" xmlns:").append(key).append("=\"").append(this.namespaces.get(key)).append("\"");
            }
        }
        body.append(">");
        if (this.properties != null || this.top.firstChild != null) {
            body.append("<").append("XCM:").append("select>");
            if (this.properties != null) {
                body.append("<prop>");
                int i = 0;
                while (i < this.properties.size()) {
                    body.append("<").append(this.properties.get(i)).append("/>");
                    ++i;
                }
                body.append("</prop>");
            }
            if (this.top.firstChild != null) {
                ExpandPropertyDef child = this.top.firstChild;
                while (child != null) {
                    this.appendChildren(body, child);
                    child = child.next;
                }
            }
            body.append("</").append("XCM:").append("select>");
        }
        body.append("<").append("XCM:").append("where>");
        if (this.propertyQueries != null) {
            int i = 0;
            while (i < this.propertyQueries.size()) {
                body.append(((Query)this.propertyQueries.get(i)).toString());
                ++i;
            }
        }
        if (this.workspaceSet != null) {
            if (this.workspaceSet.size() > 1) {
                body.append("<").append("XCM:").append("workspace-set>");
                int i = 0;
                while (i < this.workspaceSet.size()) {
                    body.append("<href>").append(Encoder.encodeXml((String)this.workspaceSet.get(i))).append("</href>");
                    ++i;
                }
                body.append("</").append("XCM:").append("workspace-set>");
            } else {
                body.append("<workspace><href>").append(Encoder.encodeXml((String)this.workspaceSet.get(0))).append("</href></workspace>");
            }
        }
        if (this.user != null) {
            body.append("<").append("XCM:").append("user>").append(Encoder.encodeXml(this.user));
            body.append("</").append("XCM:").append("user>");
        }
        if (this.displayName != null) {
            body.append("<displayname>").append(Encoder.encodeXml(this.displayName)).append("</displayname>");
        }
        if (this.openedOnly) {
            body.append("<").append("XCM:").append("opened-activities-only/>");
        }
        if (this.closedOnly) {
            body.append("<").append("XCM:").append("closed-activities-only/>");
        }
        if (this.createdInWorkspaceOnly) {
            body.append("<").append("XCM:").append("created-in-workspace-only/>");
        }
        if (this.propagationsOnly) {
            body.append("<").append("XCM:").append("propagation-lists-only/>");
        }
        if (this.noPropgationRequestID) {
            body.append("<").append("XCM:").append("propagation-request-id/>");
        }
        if (this.includePropagations) {
            body.append("<").append("XCM:").append("include-propagation-lists/>");
        }
        if (this.creationDateFrom != null || this.creationDateTo != null) {
            body.append("<").append("XCM:").append("creation-date>");
            if (this.creationDateFrom != null) {
                body.append("<").append("XCM:").append("from>");
                body.append(this.creationDateFrom).append("</").append("XCM:").append("from>");
            }
            if (this.creationDateTo != null) {
                body.append("<").append("XCM:").append("to>");
                body.append(this.creationDateTo).append("</").append("XCM:").append("to>");
            }
            body.append("</").append("XCM:").append("creation-date>");
        }
        if (this.integrationDateFrom != null || this.integrationDateTo != null) {
            body.append("<").append("XCM:").append("integration-date>");
            if (this.integrationDateFrom != null) {
                body.append("<").append("XCM:").append("from>");
                body.append(this.integrationDateFrom).append("</").append("XCM:").append("from>");
            }
            if (this.integrationDateTo != null) {
                body.append("<").append("XCM:").append("to>");
                body.append(this.integrationDateTo).append("</").append("XCM:").append("to>");
            }
            body.append("</").append("XCM:").append("integration-date>");
        }
        if (this.namePrefix != null) {
            body.append("<").append("XCM:").append("name-prefix>");
            body.append(Encoder.encodeXml(this.namePrefix)).append("</");
            body.append("XCM:").append("name-prefix>");
        }
        if (this.sequenceNumber > 0) {
            body.append("<").append("XCM:").append("isn>").append(this.sequenceNumber).append("</").append("XCM:").append("isn>");
        }
        if (this.sequenceNumberFrom > 0 || this.sequenceNumberTo > 0) {
            body.append("<").append("XCM:").append("isn-range>");
            if (this.sequenceNumberFrom > 0) {
                body.append("<").append("XCM:");
                body.append("from>").append(this.sequenceNumberFrom).append("</");
                body.append("XCM:").append("from>");
            }
            if (this.sequenceNumberTo > 0) {
                body.append("<").append("XCM:").append("to>").append(this.sequenceNumberTo);
                body.append("</").append("XCM:").append("to>");
            }
            body.append("</").append("XCM:").append("isn-range>");
        }
        if (this.activitySet != null) {
            body.append("<").append("XCM:").append("activity-set>");
            Iterator iter = this.activitySet.iterator();
            while (iter.hasNext()) {
                body.append("<href>").append(Encoder.encodeXml((String)iter.next())).append("</href>");
            }
            body.append("</").append("XCM:").append("activity-set>");
        }
        if (this.emptyOnly) {
            body.append("<").append("XCM:").append("empty-activities-only/>");
        }
        if (this.nonEmptyOnly) {
            body.append("<").append("XCM:").append("non-empty-activities-only/>");
        }
        if (this.containsFiles) {
            body.append("<").append("XCM:").append("contains-files/>");
        }
        body.append("</").append("XCM:").append("where></").append("XCM:");
        body.append("activity-query>");
        this.setRequestEntity(body);
        return body;
    }

    private void appendChildren(StringEntity body, ExpandPropertyDef property) {
        ExpandPropertyDef child;
        body.append("<property name=\"").append(property.name).append("\"");
        if (property.namespaceURI != null) {
            body.append(" namespace=\"").append(property.namespaceURI).append("\"");
        }
        if ((child = property.firstChild) == null) {
            body.append("/>");
        } else {
            body.append(">");
            while (child != null) {
                this.appendChildren(body, child);
                child = child.next;
            }
            body.append("</property>");
        }
    }
}

