/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.requests.http;

import com.tssap.dtr.client.lib.protocol.HTTPException;
import com.tssap.dtr.client.lib.protocol.IRequestEntity;
import com.tssap.dtr.client.lib.protocol.IResponse;
import com.tssap.dtr.client.lib.protocol.IResponseEntity;
import com.tssap.dtr.client.lib.protocol.IResponseParser;
import com.tssap.dtr.client.lib.protocol.entities.FileEntity;
import com.tssap.dtr.client.lib.protocol.entities.ResponseEntityBase;
import com.tssap.dtr.client.lib.protocol.entities.StreamEntity;
import com.tssap.dtr.client.lib.protocol.entities.StringEntity;
import com.tssap.dtr.client.lib.protocol.requests.RequestBase;
import com.tssap.dtr.client.lib.protocol.util.Encoder;
import com.tssap.dtr.client.lib.protocol.util.Pair;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;

public class PostRequest
extends RequestBase
implements IResponseParser {
    private ArrayList params;
    private File file;
    private OutputStream destination;

    public PostRequest(String path) {
        super("POST", path);
        this.enableResponseEntityLog(false);
    }

    public PostRequest(String path, File file) {
        super("POST", path);
        this.file = file;
        this.setDefaultParser(this);
        this.enableResponseEntityLog(false);
    }

    public PostRequest(String path, OutputStream destination) {
        super("POST", path);
        this.destination = destination;
        this.setDefaultParser(this);
        this.enableResponseEntityLog(false);
    }

    public void addParameter(String name, String value) {
        if (this.params == null) {
            this.params = new ArrayList();
        }
        this.params.add(new Pair(Encoder.encodePath(name), Encoder.encodePath(value), '='));
    }

    public IRequestEntity prepareRequestEntity() {
        StringEntity body = null;
        if (this.params != null && this.params.size() > 0) {
            body = new StringEntity("application/x-www-form-urlencoded", null);
            int i = 0;
            while (i < this.params.size()) {
                if (i > 0) {
                    body.append("&");
                }
                body.append(this.params.get(i).toString());
                ++i;
            }
            this.setRequestEntity(body);
        }
        return body;
    }

    public IResponseEntity parse(String path, IResponse response) throws HTTPException {
        ResponseEntityBase entity = null;
        int status = response.getStatus();
        if (status == 200) {
            if (this.destination != null) {
                entity = new StreamEntity(this.destination, response);
            } else if (this.file != null) {
                entity = new FileEntity(this.file, response);
            }
        }
        return entity;
    }
}

