/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.requests.http;

import com.tssap.dtr.client.lib.protocol.Header;
import com.tssap.dtr.client.lib.protocol.IRequestEntity;
import com.tssap.dtr.client.lib.protocol.IResponse;
import com.tssap.dtr.client.lib.protocol.XCM;
import com.tssap.dtr.client.lib.protocol.entities.Element;
import com.tssap.dtr.client.lib.protocol.entities.OptionEntity;
import com.tssap.dtr.client.lib.protocol.entities.SAXResponseEntity;
import com.tssap.dtr.client.lib.protocol.entities.StringEntity;
import com.tssap.dtr.client.lib.protocol.requests.XMLRequest;
import com.tssap.dtr.client.lib.protocol.util.Encoder;
import java.util.Iterator;
import java.util.List;

public class OptionsRequest
extends XMLRequest {
    private String DAVHeader;
    private Header DASLHeader;
    private int checkFeatures = 0;
    private boolean noOptions;
    private List functionalities;
    public static final int WORKSPACE = 1;
    public static final int VERSION_HISTORY = 2;
    public static final int ACTIVITY = 4;
    public static final int FUNCTIONALITIES = 8;

    public OptionsRequest(String path) {
        super("OPTIONS", path);
    }

    public OptionsRequest(String path, int checkFeatures) {
        super("OPTIONS", path);
        this.checkFeatures = checkFeatures;
    }

    public OptionsRequest(String path, List functionalities, boolean noOptions) {
        super("OPTIONS", path);
        this.checkFeatures = 8;
        this.functionalities = functionalities;
        this.noOptions = noOptions;
    }

    public String getDAVHeader() {
        if (this.DAVHeader == null) {
            this.DAVHeader = this.getResponse().getHeaderValue("DAV");
        }
        return this.DAVHeader;
    }

    public String getDASLHeader() {
        if (this.DASLHeader == null) {
            this.DASLHeader = this.getResponse().getHeader("DASL");
        }
        return this.DASLHeader != null ? this.DASLHeader.getValue() : null;
    }

    public boolean supports(String feature) {
        return this.getDAVHeader().indexOf(feature) != -1 || this.getDASLHeader().indexOf(feature) != -1;
    }

    public boolean supportsDAV() {
        return this.getDAVHeader() != null;
    }

    public boolean supportsDASL() {
        return this.getDASLHeader() != null;
    }

    public boolean supportsDAV(int level) {
        return this.supportsDAV() && this.DAVHeader.indexOf(String.valueOf(level)) != -1;
    }

    public boolean supportsVersionControl() {
        return this.supports("version-control");
    }

    public boolean supportsCheckoutInPlace() {
        return this.supports("checkout-in-place");
    }

    public boolean supportsVersionHistories() {
        return this.supports("version-history");
    }

    public boolean supportsWorkspaces() {
        return this.supports("workspace");
    }

    public boolean supportsUpdate() {
        return this.supports("update");
    }

    public boolean supportsLabels() {
        return this.supports("label");
    }

    public boolean supportsWorkingResources() {
        return this.supports("working-resource");
    }

    public boolean supportsMerge() {
        return this.supports("merge");
    }

    public boolean supportsBaselines() {
        return this.supports("baseline");
    }

    public boolean supportsActivities() {
        return this.supports("activity");
    }

    public boolean supportsVersionedCollections() {
        return this.supports("version-controlled-collection");
    }

    public boolean supportsSearch() {
        return this.supports("search");
    }

    public String[] getSupportedQueryGrammars() {
        this.getDASLHeader();
        return this.DASLHeader != null ? (String[])this.DASLHeader.getParts().toArray() : null;
    }

    public Element getCollectionSet(int feature) {
        Element collectionSet = null;
        if ("OptionEntity".equals(this.getResponse().getEntityType())) {
            String set = null;
            switch (feature) {
                case 1: {
                    set = "workspace-collection-set";
                    break;
                }
                case 2: {
                    set = "version-history-collection-set";
                    break;
                }
                case 4: {
                    set = "activity-collection-set";
                    break;
                }
                case 8: {
                    set = null;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown feature: " + feature);
                }
            }
            if (set != null) {
                collectionSet = ((OptionEntity)this.getResponse().getEntity()).getCollectionsSet(set);
            }
        }
        return collectionSet;
    }

    public List getFunctionalitySet() {
        List functionalitySet = null;
        if ("OptionEntity".equals(this.getResponse().getEntityType())) {
            functionalitySet = ((OptionEntity)this.getResponse().getEntity()).getFunctionalitySet();
        }
        return functionalitySet;
    }

    public List getFunctionality(String functionality) {
        List optionsSet = null;
        if ("OptionEntity".equals(this.getResponse().getEntityType())) {
            optionsSet = ((OptionEntity)this.getResponse().getEntity()).getFunctionality(functionality);
        }
        return optionsSet;
    }

    public IRequestEntity prepareRequestEntity() {
        StringEntity body = null;
        if (this.checkFeatures != 0) {
            body = new StringEntity("text/xml", "UTF-8");
            body.append("<?xml version=\"1.0\" encoding=\"").append("utf-8").append("\"?>");
            body.append("<options").append(" xmlns=\"DAV:\"").append(">");
            if ((this.checkFeatures & 1) != 0) {
                body.append("<workspace-collection-set/>");
            }
            if ((this.checkFeatures & 2) != 0) {
                body.append("<version-history-collection-set/>");
            }
            if ((this.checkFeatures & 4) != 0) {
                body.append("<activity-collection-set/>");
            }
            if ((this.checkFeatures & 8) != 0) {
                body.append("<").append("XCM:").append("functionality-set").append(XCM.PREFIXED_XMLNS);
                if (this.noOptions) {
                    body.append(" no-options=\"true\"");
                }
                if (this.functionalities != null && this.functionalities.size() > 0) {
                    body.append(">");
                    Iterator iter = this.functionalities.iterator();
                    while (iter.hasNext()) {
                        body.append("<").append("XCM:").append("functionality name=\"");
                        body.append(Encoder.encodeXml((String)iter.next()));
                        body.append("\"/>");
                    }
                    body.append("</").append("XCM:").append("functionality-set>");
                } else {
                    body.append("/>");
                }
            }
            body.append("</options>");
        }
        this.setRequestEntity(body);
        return body;
    }

    protected SAXResponseEntity createResponseEntity(String path, IResponse response) {
        SAXResponseEntity entity = super.createResponseEntity(path, response);
        if (entity == null && response.isContentXML() && response.getStatus() == 200) {
            entity = new OptionEntity(response);
        }
        return entity;
    }
}

