/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.requests.http;

import com.tssap.dtr.client.lib.protocol.HTTPException;
import com.tssap.dtr.client.lib.protocol.IResponse;
import com.tssap.dtr.client.lib.protocol.IResponseEntity;
import com.tssap.dtr.client.lib.protocol.IResponseParser;
import com.tssap.dtr.client.lib.protocol.entities.FileEntity;
import com.tssap.dtr.client.lib.protocol.entities.ResponseEntityBase;
import com.tssap.dtr.client.lib.protocol.entities.StreamEntity;
import com.tssap.dtr.client.lib.protocol.requests.RequestBase;
import java.io.File;
import java.io.OutputStream;

public class GetRequest
extends RequestBase
implements IResponseParser {
    private File file;
    private String label;
    private OutputStream destination;

    public GetRequest(String path) {
        super("GET", path);
        this.enableResponseEntityLog(false);
    }

    public GetRequest(String path, File file) {
        super("GET", path);
        this.file = file;
        this.setDefaultParser(this);
        this.enableResponseEntityLog(false);
    }

    public GetRequest(String path, OutputStream destination) {
        super("GET", path);
        this.destination = destination;
        this.setDefaultParser(this);
        this.enableResponseEntityLog(false);
    }

    public void setApplyToLabel(String label) {
        this.label = label;
        if (label != null) {
            this.setHeader("Label", label);
        }
    }

    public IResponseEntity parse(String path, IResponse response) throws HTTPException {
        ResponseEntityBase entity = null;
        int status = response.getStatus();
        if (status == 200) {
            if (this.destination != null) {
                entity = new StreamEntity(this.destination, response);
            } else if (this.file != null) {
                entity = new FileEntity(this.file, response);
            }
        }
        return entity;
    }
}

