/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.requests.dav;

import com.tssap.dtr.client.lib.protocol.IRequestEntity;
import com.tssap.dtr.client.lib.protocol.entities.MultiStatusEntity;
import com.tssap.dtr.client.lib.protocol.entities.ResourceElement;
import com.tssap.dtr.client.lib.protocol.entities.StringEntity;
import com.tssap.dtr.client.lib.protocol.requests.MultiStatusRequest;
import com.tssap.dtr.client.lib.protocol.requests.dav.ExpandPropertyDef;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class VersionTreeReport
extends MultiStatusRequest {
    private ExpandPropertyDef top = new ExpandPropertyDef("");
    private ArrayList properties;
    private HashMap namespaces;

    public VersionTreeReport(String path) {
        super("REPORT", path);
    }

    public void addPropertyGet(String propertyName) {
        if (this.properties == null) {
            this.properties = new ArrayList();
        }
        this.properties.add(propertyName);
    }

    public void addPropertyGet(String propertyName, String namespaceURI) {
        int n = propertyName.indexOf(58);
        if (n > 0) {
            this.addNamespace(propertyName.substring(0, n), namespaceURI);
        }
        this.addPropertyGet(propertyName);
    }

    public void addPropertyGet(String[] propertyNames) {
        if (this.properties == null) {
            this.properties = new ArrayList();
        }
        int i = 0;
        while (i < propertyNames.length) {
            this.properties.add(propertyNames[i]);
            ++i;
        }
    }

    public ExpandPropertyDef addPropertyExpand(String propertyName, ExpandPropertyDef parent) {
        ExpandPropertyDef property = new ExpandPropertyDef(propertyName);
        this.addPropertyExpand(property, parent);
        return property;
    }

    public ExpandPropertyDef addPropertyExpand(String propertyName, String namespaceURI, ExpandPropertyDef parent) {
        ExpandPropertyDef property = new ExpandPropertyDef(propertyName, namespaceURI);
        this.addPropertyExpand(property, parent);
        return property;
    }

    public void addPropertyExpand(ExpandPropertyDef property, ExpandPropertyDef parent) {
        if (parent != null) {
            parent.addChild(property);
        } else {
            this.top.addChild(property);
        }
    }

    public void addNamespace(String prefix, String namespaceURI) {
        if (this.namespaces == null) {
            this.namespaces = new HashMap();
        }
        if (prefix.endsWith(":")) {
            this.namespaces.put(prefix.substring(0, prefix.length() - 1), namespaceURI);
        } else {
            this.namespaces.put(prefix, namespaceURI);
        }
    }

    public int countResources() {
        MultiStatusEntity entity = MultiStatusEntity.valueOf(this.getResponse().getEntity());
        return entity != null ? entity.countResources() : 0;
    }

    public ResourceElement getResource(int i) {
        MultiStatusEntity entity = MultiStatusEntity.valueOf(this.getResponse().getEntity());
        return entity != null ? entity.getResource(i) : null;
    }

    public Iterator getResources() {
        MultiStatusEntity entity = MultiStatusEntity.valueOf(this.getResponse().getEntity());
        return entity != null ? entity.getResources() : null;
    }

    public IRequestEntity prepareRequestEntity() {
        StringEntity body = null;
        body = new StringEntity("text/xml", "UTF-8");
        body.append("<?xml version=\"1.0\" encoding=\"").append("utf-8").append("\"?>");
        body.append("<version-tree").append(" xmlns=\"DAV:\"");
        if (this.namespaces != null) {
            Iterator keys = this.namespaces.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                body.append(" xmlns:").append(key).append("=\"").append(this.namespaces.get(key)).append("\"");
            }
        }
        if (this.properties != null || this.top.firstChild != null) {
            body.append(">");
            if (this.properties != null) {
                body.append("<prop>");
                int i = 0;
                while (i < this.properties.size()) {
                    body.append("<").append(this.properties.get(i)).append("/>");
                    ++i;
                }
                body.append("</prop>");
            }
            if (this.top.firstChild != null) {
                body.append("<expand-property>");
                ExpandPropertyDef child = this.top.firstChild;
                while (child != null) {
                    this.appendChildren(body, child);
                    child = child.next;
                }
                body.append("</expand-property>");
            }
            body.append("</version-tree>");
        } else {
            body.append("/>");
        }
        this.setRequestEntity(body);
        return body;
    }

    private void appendChildren(StringEntity body, ExpandPropertyDef property) {
        ExpandPropertyDef child;
        body.append("<property name=\"").append(property.name).append("\"");
        if (property.namespaceURI != null) {
            body.append(" namespace=\"").append(property.namespaceURI).append("\"");
        }
        if ((child = property.firstChild) == null) {
            body.append("/>");
        } else {
            body.append(">");
            while (child != null) {
                this.appendChildren(body, child);
                child = child.next;
            }
            body.append("</property>");
        }
    }
}

