/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.requests.dav;

import com.tssap.dtr.client.lib.protocol.IRequestEntity;
import com.tssap.dtr.client.lib.protocol.entities.MultiStatusEntity;
import com.tssap.dtr.client.lib.protocol.entities.ResourceElement;
import com.tssap.dtr.client.lib.protocol.entities.StringEntity;
import com.tssap.dtr.client.lib.protocol.requests.MultiStatusRequest;
import com.tssap.dtr.client.lib.protocol.util.Encoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class UpdateRequest
extends MultiStatusRequest {
    private ArrayList properties;
    private HashMap namespaces;
    private String updateSource;
    private boolean applyToLabel = false;

    public UpdateRequest(String path, String updateSource) {
        super("UPDATE", path);
        this.updateSource = updateSource;
    }

    public void applyToLabel() {
        this.applyToLabel = true;
    }

    public void addPropertyGet(String propertyName) {
        if (this.properties == null) {
            this.properties = new ArrayList();
        }
        this.properties.add(propertyName);
    }

    public void addPropertyGet(String propertyName, String namespaceURI) {
        int n = propertyName.indexOf(58);
        if (n > 0) {
            this.addNamespace(propertyName.substring(0, n), namespaceURI);
        }
        this.addPropertyGet(propertyName);
    }

    public void addPropertyGet(String[] propertyNames) {
        if (this.properties == null) {
            this.properties = new ArrayList();
        }
        int i = 0;
        while (i < propertyNames.length) {
            this.properties.add(propertyNames[i]);
            ++i;
        }
    }

    public void addNamespace(String prefix, String namespaceURI) {
        if (this.namespaces == null) {
            this.namespaces = new HashMap();
        }
        if (prefix.endsWith(":")) {
            this.namespaces.put(prefix.substring(0, prefix.length() - 1), namespaceURI);
        } else {
            this.namespaces.put(prefix, namespaceURI);
        }
    }

    public int countResources() {
        MultiStatusEntity entity = MultiStatusEntity.valueOf(this.getResponse().getEntity());
        return entity != null ? entity.countResources() : 0;
    }

    public ResourceElement getResource(int i) {
        MultiStatusEntity entity = MultiStatusEntity.valueOf(this.getResponse().getEntity());
        return entity != null ? entity.getResource(i) : null;
    }

    public Iterator getResources() {
        MultiStatusEntity entity = MultiStatusEntity.valueOf(this.getResponse().getEntity());
        return entity != null ? entity.getResources() : null;
    }

    public IRequestEntity prepareRequestEntity() {
        StringEntity body = null;
        body = new StringEntity("text/xml", "UTF-8");
        body.append("<?xml version=\"1.0\" encoding=\"").append("utf-8").append("\"?>");
        body.append("<update").append(" xmlns=\"DAV:\"");
        if (this.properties != null) {
            if (this.namespaces != null) {
                Iterator keys = this.namespaces.keySet().iterator();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    body.append(" xmlns:").append(key).append("=\"").append(this.namespaces.get(key)).append("\"");
                }
            }
            body.append(">");
        }
        String tagName = this.applyToLabel ? "label-name" : "version";
        body.append("<").append(tagName).append("><href>");
        body.append(Encoder.encodeXml(this.updateSource));
        body.append("</href></").append(tagName).append(">");
        if (this.properties != null) {
            body.append("<prop>");
            int i = 0;
            while (i < this.properties.size()) {
                body.append("<").append(this.properties.get(i)).append("/>");
                ++i;
            }
            body.append("</prop>");
        }
        body.append("</update>");
        this.setRequestEntity(body);
        return body;
    }
}

