/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.requests.dav;

import com.tssap.dtr.client.lib.protocol.IRequestEntity;
import com.tssap.dtr.client.lib.protocol.entities.Element;
import com.tssap.dtr.client.lib.protocol.entities.MultiStatusEntity;
import com.tssap.dtr.client.lib.protocol.entities.ResourceElement;
import com.tssap.dtr.client.lib.protocol.entities.StringEntity;
import com.tssap.dtr.client.lib.protocol.requests.MultiStatusRequest;
import com.tssap.dtr.client.lib.protocol.util.Encoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class ProppatchRequest
extends MultiStatusRequest {
    private ArrayList properties;
    private HashMap namespaces;

    public ProppatchRequest(String path) {
        super("PROPPATCH", path);
    }

    public void clear() {
        super.clear();
        if (this.properties != null) {
            this.properties.clear();
        }
        if (this.namespaces != null) {
            this.namespaces.clear();
        }
    }

    public void addPropertySet(String propertyName, String propertyValue) {
        if (this.properties == null) {
            this.properties = new ArrayList();
        }
        this.properties.add(new Action(true, propertyName, propertyValue));
    }

    public void addPropertySet(String propertyName, String propertyValue, String namespaceURI) {
        int n = propertyName.indexOf(58);
        if (n > 0) {
            this.addNamespace(propertyName.substring(0, n), namespaceURI);
        }
        this.addPropertySet(propertyName, propertyValue);
    }

    public void addPropertySet(Element property) {
        if (property.getNamespaceURI() != null) {
            this.addNamespace(property.getNamespacePrefix(), property.getNamespaceURI());
        }
        if (this.properties == null) {
            this.properties = new ArrayList();
        }
        this.properties.add(new Action(true, property.getQualifiedName(), property));
    }

    public void addPropertyRemove(String propertyName) {
        if (this.properties == null) {
            this.properties = new ArrayList();
        }
        this.properties.add(new Action(false, propertyName));
    }

    public void addPropertyRemove(String propertyName, String namespaceURI) {
        int n = propertyName.indexOf(58);
        if (n > 0) {
            this.addNamespace(propertyName.substring(0, n), namespaceURI);
        }
        this.addPropertyRemove(propertyName);
    }

    public void addNamespace(String prefix, String namespaceURI) {
        if (this.namespaces == null) {
            this.namespaces = new HashMap();
        }
        if (prefix.endsWith(":")) {
            this.namespaces.put(prefix.substring(0, prefix.length() - 1), namespaceURI);
        } else {
            this.namespaces.put(prefix, namespaceURI);
        }
    }

    public int countResources() {
        MultiStatusEntity entity = MultiStatusEntity.valueOf(this.getResponse().getEntity());
        return entity != null ? entity.countResources() : 0;
    }

    public ResourceElement getResource(int i) {
        MultiStatusEntity entity = MultiStatusEntity.valueOf(this.getResponse().getEntity());
        return entity != null ? entity.getResource(i) : null;
    }

    public Iterator getResources() {
        MultiStatusEntity entity = MultiStatusEntity.valueOf(this.getResponse().getEntity());
        return entity != null ? entity.getResources() : null;
    }

    public IRequestEntity prepareRequestEntity() {
        StringEntity body = null;
        body = new StringEntity("text/xml", "UTF-8");
        body.append("<?xml version=\"1.0\" encoding=\"").append("utf-8").append("\"?>");
        body.append("<propertyupdate").append(" xmlns=\"DAV:\"");
        if (this.namespaces != null) {
            Iterator keys = this.namespaces.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                body.append(" xmlns:").append(key).append("=\"").append(this.namespaces.get(key)).append("\"");
            }
        }
        body.append(">");
        if (this.properties != null && this.properties.size() > 0) {
            boolean tagOpen = false;
            boolean setTagOpen = false;
            int i = 0;
            while (i < this.properties.size()) {
                Action action = (Action)this.properties.get(i);
                if (action.set) {
                    if (tagOpen && !setTagOpen) {
                        body.append("</prop></remove>");
                        tagOpen = false;
                    }
                    if (!tagOpen) {
                        body.append("<set><prop>");
                        tagOpen = true;
                        setTagOpen = true;
                    }
                    body.append(action.toString());
                } else {
                    if (tagOpen && setTagOpen) {
                        body.append("</prop></set>");
                        tagOpen = false;
                    }
                    if (!tagOpen) {
                        body.append("<remove><prop>");
                        tagOpen = true;
                        setTagOpen = false;
                    }
                    body.append("<").append(action.name).append("/>");
                }
                ++i;
            }
            if (setTagOpen) {
                body.append("</prop></set>");
            } else {
                body.append("</prop></remove>");
            }
        }
        body.append("</propertyupdate>");
        this.setRequestEntity(body);
        return body;
    }

    private class Action {
        public boolean set;
        public String name;
        public Object value;

        public Action(boolean set, String name) {
            this.set = set;
            this.name = name;
        }

        public Action(boolean set, String name, String value) {
            this.set = set;
            this.name = name;
            if (value != null) {
                this.value = Encoder.encodeXml(value);
            }
        }

        public Action(boolean set, String name, Element value) {
            this.set = set;
            this.name = name;
            this.value = value;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            if (this.value == null || this.value == "") {
                sb.append("<").append(this.name).append("/>");
            } else {
                sb.append("<").append(this.name).append(">");
                sb.append(this.value.toString());
                sb.append("</").append(this.name).append(">");
            }
            return sb.toString();
        }
    }
}

