/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.requests.dav;

import com.tssap.dtr.client.lib.protocol.IRequestEntity;
import com.tssap.dtr.client.lib.protocol.entities.MultiStatusEntity;
import com.tssap.dtr.client.lib.protocol.entities.ResourceElement;
import com.tssap.dtr.client.lib.protocol.entities.StringEntity;
import com.tssap.dtr.client.lib.protocol.requests.MultiStatusRequest;
import com.tssap.dtr.client.lib.protocol.requests.dav.Depth;
import com.tssap.dtr.client.lib.protocol.requests.dav.PropfindOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class PropfindRequest
extends MultiStatusRequest {
    private ArrayList properties;
    private HashMap namespaces;
    private PropfindOption option = PropfindOption.PROPERTIES;
    private Depth depth = Depth.DEPTH_INFINITY;
    private String label;

    public PropfindRequest(String path) {
        super("PROPFIND", path);
    }

    public PropfindRequest(String path, Depth depth) {
        this(path);
        this.setDepth(depth);
    }

    public PropfindRequest(String path, Depth depth, String[] propertyNames) {
        this(path, depth);
        this.properties = new ArrayList();
        int i = 0;
        while (i < propertyNames.length) {
            this.properties.add(propertyNames[i]);
            ++i;
        }
    }

    public void clear() {
        super.clear();
        if (this.properties != null) {
            this.properties.clear();
        }
        if (this.namespaces != null) {
            this.namespaces.clear();
        }
        this.option = PropfindOption.PROPERTIES;
        this.depth = Depth.DEPTH_INFINITY;
        this.label = null;
    }

    public void setDepth(Depth depth) {
        if (depth.equals(Depth.DEPTH_0)) {
            this.setHeader("Depth", "0");
            this.depth = Depth.DEPTH_0;
        } else if (depth.equals(Depth.DEPTH_1)) {
            this.setHeader("Depth", "1");
            this.depth = Depth.DEPTH_1;
        } else if (depth.equals(Depth.DEPTH_INFINITY)) {
            this.setHeader("Depth", "infinity");
            this.depth = Depth.DEPTH_INFINITY;
        }
    }

    public void setOption(PropfindOption option) {
        this.option = option;
        if (option != PropfindOption.PROPERTIES && this.properties != null) {
            this.properties.clear();
            this.properties = null;
        }
    }

    public void setApplyToLabel(String label) {
        this.label = label;
        if (label != null) {
            this.setHeader("Label", label);
        }
    }

    public void addPropertyGet(String propertyName) {
        if (this.properties == null) {
            this.properties = new ArrayList();
        }
        this.properties.add(propertyName);
        this.option = PropfindOption.PROPERTIES;
    }

    public void addPropertyGet(String propertyName, String namespaceURI) {
        int n = propertyName.indexOf(58);
        if (n > 0) {
            this.addNamespace(propertyName.substring(0, n), namespaceURI);
        }
        this.addPropertyGet(propertyName);
        this.option = PropfindOption.PROPERTIES;
    }

    public void addPropertyGet(String[] propertyNames) {
        if (this.properties == null) {
            this.properties = new ArrayList();
        }
        int i = 0;
        while (i < propertyNames.length) {
            this.properties.add(propertyNames[i]);
            ++i;
        }
        this.option = PropfindOption.PROPERTIES;
    }

    public void addNamespace(String prefix, String namespaceURI) {
        if (this.namespaces == null) {
            this.namespaces = new HashMap();
        }
        if (prefix.endsWith(":")) {
            this.namespaces.put(prefix.substring(0, prefix.length() - 1), namespaceURI);
        } else {
            this.namespaces.put(prefix, namespaceURI);
        }
    }

    public int countResources() {
        MultiStatusEntity entity = MultiStatusEntity.valueOf(this.getResponse().getEntity());
        return entity != null ? entity.countResources() : 0;
    }

    public ResourceElement getResource(int i) {
        MultiStatusEntity entity = MultiStatusEntity.valueOf(this.getResponse().getEntity());
        return entity != null ? entity.getResource(i) : null;
    }

    public Iterator getResources() {
        MultiStatusEntity entity = MultiStatusEntity.valueOf(this.getResponse().getEntity());
        return entity != null ? entity.getResources() : null;
    }

    public IRequestEntity prepareRequestEntity() {
        StringEntity body = null;
        body = new StringEntity("text/xml", "UTF-8");
        body.append("<?xml version=\"1.0\" encoding=\"").append("utf-8").append("\"?>");
        body.append("<propfind").append(" xmlns=\"DAV:\"");
        if (this.namespaces != null && this.namespaces.size() > 0) {
            Iterator keys = this.namespaces.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                body.append(" xmlns:").append(key).append("=\"").append(this.namespaces.get(key)).append("\"");
            }
        }
        body.append(">");
        if (this.option.equals(PropfindOption.ALL_PROPERTIES)) {
            body.append("<allprop/>");
        } else if (this.option.equals(PropfindOption.PROPERTY_NAMES)) {
            body.append("<propname/>");
        } else if (this.properties != null && this.properties.size() > 0) {
            body.append("<prop>");
            int i = 0;
            while (i < this.properties.size()) {
                body.append("<").append(this.properties.get(i)).append("/>");
                ++i;
            }
            body.append("</prop>");
        }
        body.append("</propfind>");
        this.setRequestEntity(body);
        return body;
    }
}

