/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.requests.dav;

import com.tssap.dtr.client.lib.protocol.IRequestEntity;
import com.tssap.dtr.client.lib.protocol.entities.StringEntity;
import com.tssap.dtr.client.lib.protocol.requests.XMLRequest;
import com.tssap.dtr.client.lib.protocol.util.Encoder;

public class MergeRequest
extends XMLRequest {
    private String mergeSource;
    private boolean prohibitAutoMerge = false;
    private boolean prohibitAutoCheckout = false;
    private boolean checkinActivity = false;

    public MergeRequest(String mergeTarget, String mergeSource) {
        super("MERGE", mergeTarget);
        this.mergeSource = mergeSource;
    }

    public void prohibitAutoMerge(boolean prohibit) {
        this.prohibitAutoMerge = prohibit;
    }

    public void prohibitAutoCheckout(boolean prohibit) {
        this.prohibitAutoCheckout = prohibit;
    }

    public void checkinActivity(boolean checkinActivity) {
        this.checkinActivity = checkinActivity;
    }

    public IRequestEntity prepareRequestEntity() {
        StringEntity body = null;
        body = new StringEntity("text/xml", "UTF-8");
        body.append("<?xml version=\"1.0\" encoding=\"").append("utf-8").append("\"?>");
        body.append("<merge").append(" xmlns=\"DAV:\"").append("><source><href>");
        body.append(Encoder.encodeXml(this.mergeSource)).append("</href></source>");
        if (this.prohibitAutoMerge) {
            body.append("<no-auto-merge/>");
        }
        if (this.prohibitAutoCheckout) {
            body.append("<no-checkout/>");
        }
        if (this.checkinActivity) {
            body.append("<checkin-activity/>");
        }
        body.append("</merge>");
        this.setRequestEntity(body);
        return body;
    }
}

