/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.requests.dav;

import com.tssap.dtr.client.lib.protocol.IRequestEntity;
import com.tssap.dtr.client.lib.protocol.IResponse;
import com.tssap.dtr.client.lib.protocol.entities.MultiStatusEntity;
import com.tssap.dtr.client.lib.protocol.entities.SAXResponseEntity;
import com.tssap.dtr.client.lib.protocol.entities.StringEntity;
import com.tssap.dtr.client.lib.protocol.requests.XMLRequest;
import com.tssap.dtr.client.lib.protocol.requests.dav.Depth;
import com.tssap.dtr.client.lib.protocol.requests.dav.LockScope;
import com.tssap.dtr.client.lib.protocol.requests.dav.LockTimeout;
import com.tssap.dtr.client.lib.protocol.util.Encoder;

public class LockRequest
extends XMLRequest {
    private LockScope lockScope;
    private String owner;
    private Depth depth = Depth.DEPTH_INFINITY;
    private StringBuffer timeoutHeader;
    private boolean refreshLock = false;

    public LockRequest(String path, LockScope lockScope) {
        super("LOCK", path);
        this.lockScope = lockScope;
    }

    public LockRequest(String path, boolean refreshLock) {
        super("LOCK", path);
        this.refreshLock = refreshLock;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void setDepth(Depth depth) {
        if (depth.equals(Depth.DEPTH_0)) {
            this.setHeader("Depth", "0");
            this.depth = Depth.DEPTH_0;
        } else if (depth.equals(Depth.DEPTH_INFINITY)) {
            this.setHeader("Depth", "infinity");
            this.depth = Depth.DEPTH_INFINITY;
        }
    }

    public void addTimeout(LockTimeout timeout, int seconds) {
        if (this.timeoutHeader == null) {
            this.timeoutHeader = new StringBuffer();
        }
        if (this.timeoutHeader.length() > 0) {
            this.timeoutHeader.append(", ");
        }
        this.timeoutHeader.append(timeout);
        if (timeout == LockTimeout.SECONDS) {
            this.timeoutHeader.append(seconds);
        }
        this.setHeader("Timeout", this.timeoutHeader.toString());
    }

    public IRequestEntity prepareRequestEntity() {
        if (this.refreshLock) {
            return null;
        }
        StringEntity body = null;
        body = new StringEntity("text/xml", "UTF-8");
        body.append("<?xml version=\"1.0\" encoding=\"").append("utf-8").append("\"?>");
        body.append("<lockinfo").append(" xmlns=\"DAV:\"").append(">");
        body.append("<lockscope><").append(this.lockScope.toString()).append("></lockscope>");
        body.append("<locktype><write/></locktype>");
        if (this.owner != null) {
            body.append("<owner><href>").append(Encoder.encodeXml(this.owner)).append("</href></owner>");
        }
        body.append("</lockinfo>");
        this.setRequestEntity(body);
        return body;
    }

    protected SAXResponseEntity createResponseEntity(String path, IResponse response) {
        SAXResponseEntity entity = super.createResponseEntity(path, response);
        if (entity == null && response.isContentXML() && response.getStatus() == 200) {
            entity = new MultiStatusEntity(path, response);
        }
        return entity;
    }
}

