/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.requests.dav;

import com.tssap.dtr.client.lib.protocol.IRequestEntity;
import com.tssap.dtr.client.lib.protocol.entities.StringEntity;
import com.tssap.dtr.client.lib.protocol.requests.XMLRequest;
import com.tssap.dtr.client.lib.protocol.requests.dav.Depth;
import com.tssap.dtr.client.lib.protocol.requests.dav.LabelMethod;
import com.tssap.dtr.client.lib.protocol.util.Encoder;

public class LabelRequest
extends XMLRequest {
    private String label;
    private String labelName;
    private LabelMethod method;
    private Depth depth = Depth.DEPTH_0;

    public LabelRequest(String path, String labelName) {
        super("LABEL", path);
        this.labelName = labelName;
    }

    public LabelRequest(String path, String labelName, LabelMethod method) {
        super("LABEL", path);
        this.labelName = labelName;
        this.method = method;
    }

    public void setDepth(Depth depth) {
        if (depth.equals(Depth.DEPTH_0)) {
            this.setHeader("Depth", "0");
            this.depth = Depth.DEPTH_0;
        } else if (depth.equals(Depth.DEPTH_1)) {
            this.setHeader("Depth", "1");
            this.depth = Depth.DEPTH_1;
        } else if (depth.equals(Depth.DEPTH_INFINITY)) {
            this.setHeader("Depth", "infinity");
            this.depth = Depth.DEPTH_INFINITY;
        }
    }

    public void setApplyToLabel(String label) {
        this.label = label;
        if (label != null) {
            this.setHeader("Label", label);
        }
    }

    public IRequestEntity prepareRequestEntity() {
        StringEntity body = null;
        body = new StringEntity("text/xml", "UTF-8");
        String tagName = "set";
        if (this.method.equals(LabelMethod.ADD_LABEL)) {
            tagName = "add";
        } else if (this.method.equals(LabelMethod.REMOVE_LABEL)) {
            tagName = "remove";
        }
        body.append("<?xml version=\"1.0\" encoding=\"").append("utf-8").append("\"?>");
        body.append("<label").append(" xmlns=\"DAV:\"").append("><").append(tagName).append("><label-name>");
        body.append(Encoder.encodeXml(this.labelName));
        body.append("</label-name></").append(tagName).append("></label>");
        this.setRequestEntity(body);
        return body;
    }
}

