/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.requests.dav;

import com.tssap.dtr.client.lib.protocol.IRequestEntity;
import com.tssap.dtr.client.lib.protocol.IResponse;
import com.tssap.dtr.client.lib.protocol.IResponseEntity;
import com.tssap.dtr.client.lib.protocol.XCM;
import com.tssap.dtr.client.lib.protocol.entities.CheckoutResponseEntity;
import com.tssap.dtr.client.lib.protocol.entities.SAXResponseEntity;
import com.tssap.dtr.client.lib.protocol.entities.StringEntity;
import com.tssap.dtr.client.lib.protocol.requests.XMLRequest;
import com.tssap.dtr.client.lib.protocol.util.Encoder;
import java.util.ArrayList;

public class CheckoutRequest
extends XMLRequest {
    private ArrayList activities;
    private boolean applyToVersion = false;
    private boolean unreserved = false;
    private boolean allowForks = false;
    private boolean newActivity = false;
    private boolean exclusive = false;
    private String label;

    public CheckoutRequest(String path) {
        super("CHECKOUT", path);
    }

    public CheckoutRequest(String path, String activity, boolean applyToVersion) {
        this(path);
        this.addActivity(activity);
        this.setApplyToVersion(applyToVersion);
    }

    public CheckoutRequest(String path, String[] activitySet, boolean applyToVersion) {
        this(path);
        this.addActivitySet(activitySet);
        this.setApplyToVersion(applyToVersion);
    }

    public void addActivity(String activity) {
        if (this.activities == null) {
            this.activities = new ArrayList();
        }
        this.activities.add(activity);
    }

    public void addActivitySet(String[] activitySet) {
        if (this.activities == null) {
            this.activities = new ArrayList();
        }
        int i = 0;
        while (i < activitySet.length) {
            this.activities.add(activitySet[i]);
            ++i;
        }
    }

    public void setCreateNewActivity(boolean newActivity) {
        this.newActivity = newActivity;
    }

    public void setAllowForks(boolean allowForks) {
        this.allowForks = allowForks;
    }

    public void setApplyToVersion(boolean applyToVersion) {
        this.applyToVersion = applyToVersion;
    }

    public void setCheckoutUnreserved(boolean unreserved) {
        this.unreserved = unreserved;
    }

    public void setCheckoutExclusive(boolean exclusive) {
        this.exclusive = exclusive;
    }

    public void setApplyToLabel(String label) {
        this.label = label;
        if (label != null) {
            this.setHeader("Label", label);
        }
    }

    public String getWorkingResource() {
        return this.getResponse().getHeaderValue("Location");
    }

    public String getActivity() {
        return this.getResponse().getStatus() == 201 ? this.getResponse().getHeaderValue("Activity") : null;
    }

    public IRequestEntity prepareRequestEntity() {
        StringEntity body = null;
        body = new StringEntity("text/xml", "UTF-8");
        body.append("<?xml version=\"1.0\" encoding=\"").append("utf-8").append("\"?>");
        body.append("<checkout").append(" xmlns=\"DAV:\"");
        if (this.exclusive) {
            body.append(XCM.PREFIXED_XMLNS);
        }
        body.append(">");
        if (this.allowForks) {
            body.append("<fork-ok/>");
        }
        if (this.applyToVersion) {
            body.append("<apply-to-version/>");
        }
        if (this.newActivity) {
            body.append("<activity-set>");
            body.append("<new/>");
            body.append("</activity-set>");
        } else if (this.activities != null) {
            body.append("<activity-set>");
            int i = 0;
            while (i < this.activities.size()) {
                body.append("<href>");
                body.append(Encoder.encodeXml((String)this.activities.get(i)));
                body.append("</href>");
                ++i;
            }
            body.append("</activity-set>");
        }
        if (this.unreserved && (this.newActivity || this.activities != null)) {
            body.append("<unreserved/>");
        }
        if (this.exclusive) {
            body.append("<").append("XCM:").append("exclusive/>");
        }
        body.append("</checkout>");
        this.setRequestEntity(body);
        return body;
    }

    public String getCheckedoutVersionURL() {
        IResponseEntity entity = this.getResponse().getEntity();
        CheckoutResponseEntity coEntity = entity != null ? CheckoutResponseEntity.valueOf(entity) : null;
        return coEntity != null ? coEntity.getCheckedoutVersionURL() : null;
    }

    protected SAXResponseEntity createResponseEntity(String path, IResponse response) {
        SAXResponseEntity entity = super.createResponseEntity(path, response);
        if (entity == null && response.isContentXML() && response.getStatus() == 200) {
            entity = new CheckoutResponseEntity(response);
        }
        return entity;
    }
}

