/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.requests.dav;

import com.tssap.dtr.client.lib.protocol.IRequestEntity;
import com.tssap.dtr.client.lib.protocol.entities.MultiStatusEntity;
import com.tssap.dtr.client.lib.protocol.entities.PropertyElement;
import com.tssap.dtr.client.lib.protocol.entities.ResourceElement;
import com.tssap.dtr.client.lib.protocol.entities.StringEntity;
import com.tssap.dtr.client.lib.protocol.requests.MultiStatusRequest;
import java.util.Iterator;

public class CheckinRequest
extends MultiStatusRequest {
    private boolean keepCheckedOut = false;
    private boolean allowForks = false;

    public CheckinRequest(String path) {
        super("CHECKIN", path);
    }

    public void setAllowForks(boolean allowForks) {
        this.allowForks = allowForks;
    }

    public void setKeepCheckedOut(boolean keepCheckedOut) {
        this.keepCheckedOut = keepCheckedOut;
    }

    public int countResources() {
        MultiStatusEntity entity = MultiStatusEntity.valueOf(this.getResponse().getEntity());
        return entity != null ? entity.countResources() : 0;
    }

    public ResourceElement getResource(int i) {
        MultiStatusEntity entity = MultiStatusEntity.valueOf(this.getResponse().getEntity());
        return entity != null ? entity.getResource(i) : null;
    }

    public Iterator getResources() {
        MultiStatusEntity entity = MultiStatusEntity.valueOf(this.getResponse().getEntity());
        return entity != null ? entity.getResources() : null;
    }

    public String getNewVersion() {
        return this.getResponse().getStatus() == 201 ? this.getResponse().getHeaderValue("Location") : null;
    }

    public String getNewVersion(int i) {
        PropertyElement checkinProperty;
        ResourceElement res;
        String version = null;
        if (this.getResponse().getEntityType() == "MultiStatusEntity" && (res = ((MultiStatusEntity)this.getResponse().getEntity()).getResource(i)) != null && (checkinProperty = res.getProperty("checked-in")) != null) {
            version = checkinProperty.getValue();
        }
        return version;
    }

    public Iterator getNewVersions() {
        return new Iterator(){
            private Iterator resources;
            {
                this.resources = CheckinRequest.this.getResources();
            }

            public boolean hasNext() {
                return this.resources != null ? this.resources.hasNext() : false;
            }

            public Object next() {
                ResourceElement res;
                PropertyElement checkinProperty;
                String next = null;
                if (this.resources != null && (checkinProperty = (res = (ResourceElement)this.resources.next()).getProperty("checked-in")) != null) {
                    next = checkinProperty.getValue();
                }
                return next;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public IRequestEntity prepareRequestEntity() {
        StringEntity body = null;
        if (this.allowForks || this.keepCheckedOut) {
            body = new StringEntity("text/xml", "UTF-8");
            body.append("<?xml version=\"1.0\" encoding=\"").append("utf-8").append("\"?>");
            body.append("<checkin").append(" xmlns=\"DAV:\"").append(">");
            if (this.allowForks) {
                body.append("<fork-ok/>");
            }
            if (this.keepCheckedOut) {
                body.append("<keep-checked-out/>");
            }
            body.append("</checkin>");
        }
        this.setRequestEntity(body);
        return body;
    }
}

