/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.requests.dav;

import com.tssap.dtr.client.lib.protocol.IRequestEntity;
import com.tssap.dtr.client.lib.protocol.entities.StringEntity;
import com.tssap.dtr.client.lib.protocol.requests.XMLRequest;
import com.tssap.dtr.client.lib.protocol.util.Encoder;

public class BaselineControlRequest
extends XMLRequest {
    private String sourceBaseline;

    public BaselineControlRequest(String path) {
        super("BASELINE-CONTROL", path);
    }

    public BaselineControlRequest(String path, String sourceBaseline) {
        super("BASELINE-CONTROL", path);
        this.sourceBaseline = sourceBaseline;
    }

    public IRequestEntity prepareRequestEntity() {
        StringEntity body = null;
        if (this.sourceBaseline != null) {
            body = new StringEntity("text/xml", "UTF-8");
            body.append("<?xml version=\"1.0\" encoding=\"").append("utf-8").append("\"?>");
            body.append("<baseline-control").append(" xmlns=\"DAV:\"").append("><baseline><href>");
            body.append(Encoder.encodeXml(this.sourceBaseline));
            body.append("</href></baseline></baseline-control>");
        }
        this.setRequestEntity(body);
        return body;
    }
}

