/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.requests.dasl;

import com.tssap.dtr.client.lib.protocol.IRequestEntity;
import com.tssap.dtr.client.lib.protocol.entities.MultiStatusEntity;
import com.tssap.dtr.client.lib.protocol.entities.ResourceElement;
import com.tssap.dtr.client.lib.protocol.entities.StringEntity;
import com.tssap.dtr.client.lib.protocol.requests.MultiStatusRequest;
import com.tssap.dtr.client.lib.protocol.requests.dasl.CaseSensitivity;
import com.tssap.dtr.client.lib.protocol.requests.dasl.Ordering;
import com.tssap.dtr.client.lib.protocol.requests.dasl.Query;
import com.tssap.dtr.client.lib.protocol.requests.dav.Depth;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class SearchRequest
extends MultiStatusRequest {
    private ArrayList properties;
    private HashMap namespaces;
    private String from;
    private Depth depth = Depth.DEPTH_INFINITY;
    private Query whereClause;
    private ArrayList orderClauses;

    public SearchRequest(String path, String from) {
        super("SEARCH", path);
        this.from = from;
    }

    public SearchRequest(String path, String from, Depth depth) {
        super("SEARCH", path);
        this.from = from;
        this.depth = depth;
    }

    public void addSelectProperty(String propertyName) {
        if (this.properties == null) {
            this.properties = new ArrayList();
        }
        this.properties.add(propertyName);
    }

    public void addSelectProperty(String propertyName, String namespaceURI) {
        int n = propertyName.indexOf(58);
        if (n > 0) {
            this.addNamespace(propertyName.substring(0, n), namespaceURI);
        }
        this.addSelectProperty(propertyName);
    }

    public void addSelectProperty(String[] propertyNames) {
        if (this.properties == null) {
            this.properties = new ArrayList();
        }
        int i = 0;
        while (i < propertyNames.length) {
            this.properties.add(propertyNames[i]);
            ++i;
        }
    }

    public void addNamespace(String prefix, String namespaceURI) {
        if (this.namespaces == null) {
            this.namespaces = new HashMap();
        }
        if (prefix.endsWith(":")) {
            this.namespaces.put(prefix.substring(0, prefix.length() - 1), namespaceURI);
        } else {
            this.namespaces.put(prefix, namespaceURI);
        }
    }

    public void addWhereClause(Query whereClause) {
        this.whereClause = whereClause;
    }

    public void addOrderClause(String propertyName, Ordering order, CaseSensitivity sensitivity) {
        if (this.orderClauses == null) {
            this.orderClauses = new ArrayList();
        }
        this.orderClauses.add(new OrderClause(propertyName, order, sensitivity));
    }

    public int countResources() {
        MultiStatusEntity entity = MultiStatusEntity.valueOf(this.getResponse().getEntity());
        return entity != null ? entity.countResources() : 0;
    }

    public ResourceElement getResource(int i) {
        MultiStatusEntity entity = MultiStatusEntity.valueOf(this.getResponse().getEntity());
        return entity != null ? entity.getResource(i) : null;
    }

    public Iterator getResources() {
        MultiStatusEntity entity = MultiStatusEntity.valueOf(this.getResponse().getEntity());
        return entity != null ? entity.getResources() : null;
    }

    public IRequestEntity prepareRequestEntity() {
        StringEntity body = null;
        body = new StringEntity("text/xml", "UTF-8");
        body.append("<?xml version=\"1.0\" encoding=\"").append("utf-8").append("\"?>");
        body.append("<searchrequest").append(" xmlns=\"DAV:\"");
        if (this.namespaces != null && this.namespaces.size() > 0) {
            Iterator keys = this.namespaces.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                body.append(" xmlns:").append(key).append("=\"").append(this.namespaces.get(key)).append("\"");
            }
        }
        body.append("><basicsearch>");
        body.append("<select>");
        if (this.properties != null && this.properties.size() > 0) {
            body.append("<prop>");
            int i = 0;
            while (i < this.properties.size()) {
                body.append("<").append(this.properties.get(i)).append("/>");
                ++i;
            }
            body.append("</prop>");
        } else {
            body.append("<allprop/>");
        }
        body.append("</select>");
        body.append("<from><scope><href>").append(this.from).append("</href>");
        body.append("<depth>").append(SearchRequest.convertDepth(this.depth)).append("</depth></scope></from>");
        if (this.whereClause != null) {
            body.append("<where>").append(this.whereClause.toString()).append("</where>");
        }
        if (this.orderClauses != null) {
            body.append("<orderby>");
            int i = 0;
            while (i < this.orderClauses.size()) {
                OrderClause orderClause = (OrderClause)this.orderClauses.get(i);
                body.append("<order casesensitive=").append(orderClause.sensitivity).append("\"");
                body.append("<prop><").append(orderClause.propertyName).append("/></prop>");
                body.append("<").append(orderClause.order).append("/>");
                body.append("</order>");
                ++i;
            }
            body.append("</orderby>");
        }
        body.append("</basicsearch></searchrequest>");
        this.setRequestEntity(body);
        return body;
    }

    private static String convertDepth(Depth depth) {
        if (depth == Depth.DEPTH_0) {
            return "0";
        }
        if (depth == Depth.DEPTH_1) {
            return "1";
        }
        return "infinity";
    }

    private class OrderClause {
        public String propertyName;
        public Ordering order;
        public CaseSensitivity sensitivity;

        public OrderClause(String propertyName, Ordering order, CaseSensitivity sensitivity) {
            this.propertyName = propertyName;
            this.order = order;
            this.sensitivity = sensitivity;
        }
    }
}

