/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.requests;

import com.sap.tc.logging.Location;
import com.sap.util.monitor.jarm.ConfMonitor;
import com.sap.util.monitor.jarm.IMonitor;
import com.sap.util.monitor.jarm.TaskMonitor;
import com.tssap.dtr.client.lib.protocol.HTTPException;
import com.tssap.dtr.client.lib.protocol.Header;
import com.tssap.dtr.client.lib.protocol.IConnection;
import com.tssap.dtr.client.lib.protocol.IRequest;
import com.tssap.dtr.client.lib.protocol.IRequestEntity;
import com.tssap.dtr.client.lib.protocol.IResponse;
import com.tssap.dtr.client.lib.protocol.IResponseEntity;
import com.tssap.dtr.client.lib.protocol.IResponseParser;
import com.tssap.dtr.client.lib.protocol.ISessionContext;
import com.tssap.dtr.client.lib.protocol.entities.ByteArrayEntity;
import com.tssap.dtr.client.lib.protocol.impl.ResponseFactory;
import com.tssap.dtr.client.lib.protocol.util.LogUtil;
import com.tssap.dtr.client.lib.protocol.util.Query;
import com.tssap.dtr.client.lib.protocol.util.RequestLog;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;

public class RequestBase
implements IRequest {
    private String method;
    private String path;
    private Query query;
    private HashMap headers;
    private IRequestEntity requestEntity;
    private String contentType;
    private long contentLength = -1L;
    private IResponse response;
    private IResponseEntity responseEntity;
    private long duration = 0L;
    private boolean logRequestEntity = true;
    private boolean logResponseEntity = true;
    private Location location;
    private HashMap parsers;
    private IResponseParser defaultParser;
    private static Location TRACE = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$protocol$requests$RequestBase == null ? (class$com$tssap$dtr$client$lib$protocol$requests$RequestBase = RequestBase.class$("com.tssap.dtr.client.lib.protocol.requests.RequestBase")) : class$com$tssap$dtr$client$lib$protocol$requests$RequestBase));
    private static Location REQUEST_STACK = Location.getLocation((String)"com.tssap.dtr.client.lib.protocol.requests.STACK");
    private static Location REQUEST_COUNT_LOG = Location.getLocation((String)"com.tssap.dtr.client.lib.protocol.requests.COUNT");
    protected static Location REQUEST_LOG = Location.getLocation((String)"com.tssap.dtr.client.lib.protocol.REQUEST");
    protected static Location RESPONSE_LOG = Location.getLocation((String)"com.tssap.dtr.client.lib.protocol.RESPONSE");
    private static int requestCount;
    private static PrintStream logStream;
    private IMonitor monitor;
    private String monitorID;
    private String taskID;
    private boolean jarmEnabled = ConfMonitor.getMonitorSwitch();
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$protocol$requests$RequestBase;

    public RequestBase(String method) {
        this.setMethod(method);
        this.setPath("/");
    }

    public RequestBase(String method, String path) {
        this.setMethod(method);
        this.setPath(path);
    }

    public RequestBase(String method, String path, IRequestEntity entity) {
        this(method, path);
        this.setRequestEntity(entity);
    }

    public void clear() {
        this.method = null;
        this.path = null;
        this.query = null;
        this.requestEntity = null;
        this.contentType = null;
        this.contentLength = -1L;
        this.response = null;
        this.responseEntity = null;
        if (this.parsers != null) {
            this.parsers.clear();
        }
        this.defaultParser = null;
        this.removeAllHeaders();
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Query getQuery() {
        return this.query;
    }

    public void setQuery(Query query) {
        this.query = query;
    }

    public String getQueryString() {
        return this.query != null ? this.query.toString() : null;
    }

    public void setQueryString(String query) {
        this.query = new Query(query);
    }

    public Iterator getHeaderNames() {
        if (this.headers == null) {
            return null;
        }
        return new Iterator(){
            private Iterator iter;
            {
                this.iter = RequestBase.this.headers.keySet().iterator();
            }

            public boolean hasNext() {
                return this.iter.hasNext();
            }

            public Object next() {
                Header header = (Header)RequestBase.this.headers.get(this.iter.next());
                if (header != null) {
                    return header.getName();
                }
                return null;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Header getHeader(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Name of header must not be null or empty.");
        }
        if (this.headers == null) {
            return null;
        }
        return (Header)this.headers.get(name.toLowerCase());
    }

    public String getHeaderValue(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Name of header must not be null or empty.");
        }
        if (this.headers == null) {
            return null;
        }
        Header header = (Header)this.headers.get(name.toLowerCase());
        return header != null ? header.getValue() : null;
    }

    public String getHeaderValue(String name, String defaultValue) {
        String value = this.getHeaderValue(name);
        return value != null ? value : defaultValue;
    }

    public void setHeader(Header header) {
        String name = header.getName();
        if (this.headers == null) {
            this.headers = new HashMap();
        }
        this.headers.put(name.toLowerCase(), header);
    }

    public void setHeader(Header header, boolean append) {
        String name = header.getName();
        if (!append || this.headers == null) {
            this.setHeader(header);
        } else {
            Header existingHeader = (Header)this.headers.get(name.toLowerCase());
            if (existingHeader == null) {
                this.setHeader(header);
            } else {
                existingHeader.appendPart(header.getValue(), ", ");
            }
        }
    }

    public void setHeader(String name, String value) {
        this.setHeader(new Header(name, value));
    }

    public void setHeader(String name, String value, boolean append) {
        this.setHeader(new Header(name, value), append);
    }

    public void setHeaders(Header[] headerList) {
        if (this.headers == null) {
            this.headers = new HashMap();
        }
        int i = 0;
        while (i < headerList.length) {
            this.setHeader(headerList[i]);
            ++i;
        }
    }

    public void removeHeader(String name) {
        if (name != null && name.length() > 0) {
            if (this.headers != null) {
                this.headers.remove(name.toLowerCase());
            }
        } else {
            throw new IllegalArgumentException("Header name must not be null or empty.");
        }
    }

    public void removeAllHeaders() {
        if (this.headers != null) {
            this.headers.clear();
        }
    }

    public IRequestEntity getRequestEntity() {
        if (this.requestEntity == null) {
            this.prepareRequestEntity();
        }
        return this.requestEntity;
    }

    public void setRequestEntity(IRequestEntity entity) {
        if (entity != null) {
            this.requestEntity = entity;
            this.contentLength = entity.getContentLength();
            if (this.contentLength > 0L) {
                this.setHeader("Content-Length", Long.toString(this.contentLength));
            }
            this.contentType = entity.getContentType();
            if (this.contentType == null) {
                this.contentType = "application/octet-stream";
            }
            this.setHeader("Content-Type", this.contentType);
            if (entity.getContentMD5() != null) {
                this.setHeader("Content-MD5", entity.getContentMD5());
            }
        }
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public String getContentType() {
        return this.contentType;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IResponse perform(IConnection connection, boolean sendCloseConnection) throws IOException, HTTPException {
        if (connection == null) {
            IOException ex = new IOException("invalid connection");
            TRACE.throwing("perform(IConnection,boolean)", (Throwable)ex);
            throw ex;
        }
        if (TRACE.beInfo()) {
            TRACE.infoT("perform(IConnection,boolean)", "");
            TRACE.infoT("perform(IConnection,boolean)", "<<<BEGIN OF REQUEST>>>");
            TRACE.infoT("perform(IConnection,boolean)", "{0} {1}", new Object[]{this.getMethod(), this.getPath()});
        }
        if (REQUEST_STACK.beDebug()) {
            LogUtil.debugLogException(REQUEST_STACK, new RequestLog());
        }
        ++requestCount;
        long startTime = System.currentTimeMillis();
        if (this.jarmEnabled) {
            String user = this.getUser(connection);
            this.taskID = "NW:DI:HTTP:PERFORM";
            this.monitorID = "NW:DI:HTTP:" + this.method.toUpperCase();
            this.monitor = TaskMonitor.getRequestMonitor((String)user, (String)this.taskID);
            this.monitor.startComponent(this.monitorID);
        }
        try {
            try {
                block25: {
                    this.response = connection.send(this, sendCloseConnection);
                    if (logStream != null) {
                        this.logResponse(logStream, connection);
                    }
                    String responseType = this.response.getContentType();
                    IResponseParser parser = null;
                    if (this.parsers != null && responseType != null) {
                        parser = this.getResponseParser(responseType);
                    }
                    if (parser == null && this.defaultParser != null) {
                        parser = this.defaultParser;
                    }
                    try {
                        try {
                            this.responseEntity = parser != null ? parser.parse(connection.getAbsolutePath(this.path), this.response) : new ByteArrayEntity(this.response);
                            if (this.responseEntity != null) {
                                this.response.setEntity(this.responseEntity);
                                this.response = ResponseFactory.createResponse(this.responseEntity.getEntityType(), this.response);
                            }
                            this.response.releaseStream();
                        }
                        catch (InterruptedIOException e) {
                            LogUtil.debugLogException(TRACE, e);
                            sendCloseConnection = true;
                            this.responseEntity = null;
                            TRACE.infoT("perform(IConnection,boolean)", "Parsing of the response entity has been interrupted.");
                            Object var9_10 = null;
                            this.duration = System.currentTimeMillis() - startTime;
                            if (this.jarmEnabled) {
                                this.monitor.endComponent(this.monitorID);
                                this.monitor.setDescription(this.getRequestName() + "  " + connection.getUrl() + connection.getAbsolutePath(this.path) + " : " + this.response.getStatusLine() + " [req #" + requestCount + "]" + "[" + (this.response.getDuration() < 10L ? "<10" : Long.toString(this.response.getDuration())) + "ms]" + "[" + Thread.currentThread().getName() + "]");
                                this.monitor.endRequest(this.taskID);
                            }
                            if (TRACE.beInfo()) {
                                TRACE.infoT("perform(IConnection,boolean)", "{0} {1} [completed in {2}ms]", new Object[]{Integer.toString(this.response.getStatus()), this.response.getStatusDescription(), this.duration < 10L ? "<10" : Long.toString(this.duration)});
                            }
                            break block25;
                        }
                        Object var9_9 = null;
                    }
                    catch (Throwable throwable) {
                        Object var9_11 = null;
                        this.duration = System.currentTimeMillis() - startTime;
                        if (this.jarmEnabled) {
                            this.monitor.endComponent(this.monitorID);
                            this.monitor.setDescription(this.getRequestName() + "  " + connection.getUrl() + connection.getAbsolutePath(this.path) + " : " + this.response.getStatusLine() + " [req #" + requestCount + "]" + "[" + (this.response.getDuration() < 10L ? "<10" : Long.toString(this.response.getDuration())) + "ms]" + "[" + Thread.currentThread().getName() + "]");
                            this.monitor.endRequest(this.taskID);
                        }
                        if (!TRACE.beInfo()) throw throwable;
                        TRACE.infoT("perform(IConnection,boolean)", "{0} {1} [completed in {2}ms]", new Object[]{Integer.toString(this.response.getStatus()), this.response.getStatusDescription(), this.duration < 10L ? "<10" : Long.toString(this.duration)});
                        throw throwable;
                    }
                    this.duration = System.currentTimeMillis() - startTime;
                    if (this.jarmEnabled) {
                        this.monitor.endComponent(this.monitorID);
                        this.monitor.setDescription(this.getRequestName() + "  " + connection.getUrl() + connection.getAbsolutePath(this.path) + " : " + this.response.getStatusLine() + " [req #" + requestCount + "]" + "[" + (this.response.getDuration() < 10L ? "<10" : Long.toString(this.response.getDuration())) + "ms]" + "[" + Thread.currentThread().getName() + "]");
                        this.monitor.endRequest(this.taskID);
                    }
                    if (TRACE.beInfo()) {
                        TRACE.infoT("perform(IConnection,boolean)", "{0} {1} [completed in {2}ms]", new Object[]{Integer.toString(this.response.getStatus()), this.response.getStatusDescription(), this.duration < 10L ? "<10" : Long.toString(this.duration)});
                    }
                }
                Object var11_14 = null;
                if (logStream != null) {
                    this.logRequest(logStream, connection);
                }
            }
            catch (IOException e) {
                sendCloseConnection = true;
                LogUtil.logException(TRACE, e);
                throw e;
            }
            catch (HTTPException e) {
                sendCloseConnection = true;
                LogUtil.logException(TRACE, e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var11_15 = null;
            if (logStream != null) {
                this.logRequest(logStream, connection);
            }
            TRACE.infoT("perform(IConnection,boolean)", "<<<END OF REQUEST>>>");
            TRACE.infoT("perform(IConnection,boolean)", "");
            if (!sendCloseConnection) throw throwable;
            connection.close();
            throw throwable;
        }
        TRACE.infoT("perform(IConnection,boolean)", "<<<END OF REQUEST>>>");
        TRACE.infoT("perform(IConnection,boolean)", "");
        if (!sendCloseConnection) return this.response;
        connection.close();
        return this.response;
    }

    public IResponse perform(IConnection connection) throws IOException, HTTPException {
        return this.perform(connection, false);
    }

    public IResponse getResponse() {
        return this.response;
    }

    public IResponseEntity getResponseEntity() {
        return this.responseEntity;
    }

    public boolean logRequestEntity() {
        return this.logRequestEntity;
    }

    public boolean logResponseEntity() {
        return this.logResponseEntity;
    }

    public void enableLogging(boolean enable) {
        this.logRequestEntity = enable;
        this.logResponseEntity = enable;
    }

    public void enableRequestEntityLog(boolean enable) {
        this.logRequestEntity = enable;
    }

    public void enableResponseEntityLog(boolean enable) {
        this.logResponseEntity = enable;
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public IResponseParser getResponseParser(String contentType) {
        if (this.parsers == null) {
            return null;
        }
        return (IResponseParser)this.parsers.get(this.getParserKey(contentType));
    }

    public void setResponseParser(String contentType, IResponseParser parser) {
        if (this.parsers == null) {
            this.parsers = new HashMap();
        }
        this.parsers.put(this.getParserKey(contentType), parser);
    }

    public void removeResponseParser(String contentType) {
        if (this.parsers != null) {
            this.parsers.remove(this.getParserKey(contentType));
        }
    }

    public IResponseParser getDefaultParser() {
        return this.defaultParser;
    }

    public void setDefaultParser(IResponseParser parser) {
        this.defaultParser = parser;
    }

    protected IRequestEntity prepareRequestEntity() {
        return null;
    }

    private String getParserKey(String type) {
        int n = type.indexOf(59);
        String s = n > 0 ? type.substring(0, n).trim() : type;
        return s.toLowerCase();
    }

    public static void setLogStream(PrintStream log) {
        logStream = log;
    }

    protected void logRequest(PrintStream log, IConnection conn) {
        String requestName = this.getRequestName();
        if (REQUEST_LOG.beDebug()) {
            String url = conn.getProtocol().toString() + "://" + conn.getHost() + ":" + conn.getPort() + this.path;
            String status = this.response != null ? " : " + String.valueOf(this.response.getStatus()) : "";
            logStream.println("HTTP Request#" + requestCount + " [" + Thread.currentThread().getName() + "]:  " + requestName + "  " + url + "  (" + (this.duration < 10L ? "<10" : Long.toString(this.duration)) + "ms) : " + status);
        } else if (REQUEST_COUNT_LOG.beDebug()) {
            String url = conn.getProtocol().toString() + "://" + conn.getHost() + ":" + conn.getPort() + this.path;
            String status = this.response != null ? " : " + String.valueOf(this.response.getStatus()) : "";
            logStream.println("HTTP Request#" + requestCount + " [" + Thread.currentThread().getName() + "]:  " + requestName + "  " + url + "  (" + (this.duration < 10L ? "<10" : Long.toString(this.duration)) + "ms)" + status);
        }
    }

    protected void logResponse(PrintStream log, IConnection conn) {
        String traceHeader;
        if (RESPONSE_LOG.beDebug() && (traceHeader = this.response.getHeaderValue("DTRPerformanceStatistics")) != null && traceHeader.length() > 0) {
            logStream.println("HTTP Request#" + (requestCount - 1) + " [" + Thread.currentThread().getName() + "]:  " + traceHeader);
        }
    }

    private String getUser(IConnection conn) {
        String user = null;
        ISessionContext ctx = conn.getSessionContext();
        if (ctx != null) {
            user = ctx.getUser();
        }
        return user;
    }

    private String getRequestName() {
        int penultimateDot;
        String requestName = this.getClass().getName();
        int lastDot = requestName.lastIndexOf(46);
        if (lastDot > 0 && (penultimateDot = requestName.lastIndexOf(46, lastDot - 1)) > 0) {
            requestName = requestName.substring(penultimateDot + 1);
        }
        return requestName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

