/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.dtr.client.lib.protocol.pool;

import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.protocol.Connection;
import com.tssap.dtr.client.lib.protocol.IConnection;
import com.tssap.dtr.client.lib.protocol.IConnectionTemplate;
import com.tssap.dtr.client.lib.protocol.impl.HashMapIntInt;
import com.tssap.dtr.client.lib.protocol.impl.HashMapIntObject;
import com.tssap.dtr.client.lib.protocol.pool.IConnectionPool;
import com.tssap.dtr.client.lib.protocol.pool.OutOfConnectionsException;
import com.tssap.dtr.client.lib.protocol.templates.ITemplateProvider;
import com.tssap.dtr.client.lib.protocol.templates.InvalidTemplateIDException;
import com.tssap.dtr.client.lib.protocol.templates.TemplateException;
import java.util.NoSuchElementException;

public final class ConnectionPool
implements IConnectionPool {
    private HashMapIntObject freeConnections = new HashMapIntObject();
    private HashMapIntObject usedConnections = new HashMapIntObject();
    private int limit = -1;
    private int size;
    private HashMapIntInt limits = new HashMapIntInt();
    private int defaultLimit = -1;
    private HashMapIntInt sizes = new HashMapIntInt();
    private HashMapIntInt countUsed = new HashMapIntInt();
    private ITemplateProvider templateProvider;
    private Thread monitor;
    private volatile boolean monitoring;
    private HashMapIntObject monitored = new HashMapIntObject();
    private static Location TRACE = Location.getLocation((Class)(class$com$tssap$dtr$client$lib$protocol$pool$ConnectionPool == null ? (class$com$tssap$dtr$client$lib$protocol$pool$ConnectionPool = ConnectionPool.class$("com.tssap.dtr.client.lib.protocol.pool.ConnectionPool")) : class$com$tssap$dtr$client$lib$protocol$pool$ConnectionPool));
    static /* synthetic */ Class class$com$tssap$dtr$client$lib$protocol$pool$ConnectionPool;

    public ConnectionPool(ITemplateProvider templateProvider) {
        this.templateProvider = templateProvider;
    }

    public void setOverallLimit(int limit) {
        this.limit = limit;
        if (this.getSize() > limit) {
            this.removeFreeEntries();
        }
    }

    public int getOverallLimit() {
        return this.limit;
    }

    public void setLimit(int templateID, int limit) {
        this.limits.put(templateID, limit);
        int n = this.getSize(templateID);
        int n2 = n = n > 0 ? n : 0;
        if (limit > 0 && n > limit) {
            this.removeFreeEntries(templateID, n - limit);
        }
    }

    public int getLimit(int templateID) {
        int result = -1;
        if (this.limits != null) {
            try {
                result = this.limits.get(templateID);
            }
            catch (NoSuchElementException e) {
                TRACE.debugT("getLimit(int)", "Template ID not yet defined [ID=" + templateID + "]");
            }
        }
        return result < 0 ? this.defaultLimit : result;
    }

    public void setDefaultLimit(int limit) {
        this.defaultLimit = limit;
    }

    public int getDefaultLimit() {
        return this.defaultLimit;
    }

    public int getSize() {
        return this.size;
    }

    public int getSize(int templateID) {
        int n = -1;
        try {
            n = this.sizes.get(templateID);
        }
        catch (NoSuchElementException e) {
            TRACE.debugT("getSize(int)", "Template ID not yet defined [ID=" + templateID + "]");
            try {
                this.templateProvider.getConnectionTemplate(templateID);
                n = 0;
            }
            catch (InvalidTemplateIDException _) {
                // empty catch block
            }
        }
        return n;
    }

    public int countUsed(int templateID) throws InvalidTemplateIDException {
        try {
            return this.countUsed.get(templateID);
        }
        catch (NoSuchElementException e) {
            this.templateProvider.getConnectionTemplate(templateID);
            return 0;
        }
    }

    public int countFree(int templateID) throws InvalidTemplateIDException {
        return this.getSize(templateID) - this.countUsed(templateID);
    }

    public boolean hasConnection(int templateID) throws InvalidTemplateIDException {
        int free = this.countFree(templateID);
        return free > 0 || free == 0 && this.checkCapacity() && this.checkCapacity(templateID);
    }

    public IConnection acquireConnection(int templateID) throws OutOfConnectionsException, TemplateException {
        return this.aquireFreeEntry((int)templateID).connection;
    }

    public void releaseConnection(IConnection connection, boolean closeConnection) {
        this.releaseUsedEntry(connection, closeConnection);
    }

    public void refreshAll() {
        this.removeFreeEntries();
        this.removeUsedEntries();
    }

    public void refresh(int templateID) {
        this.removeFreeEntries(templateID);
        this.removeUsedEntries(templateID);
    }

    private void enableAutoClose(boolean enable) {
        if (enable) {
            if (this.monitor != null) {
                this.monitoring = false;
                this.monitor.interrupt();
            }
            Runnable r = new Runnable(){

                public void run() {
                    try {
                        ConnectionPool.this.monitor();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            this.monitoring = true;
            this.monitor = new Thread(r, "SAP HTTP CLIENT/6.40");
            this.monitor.start();
        } else if (this.monitor != null) {
            this.monitoring = false;
            this.monitor.interrupt();
        }
    }

    private IConnectionTemplate getTemplate(int templateID) throws InvalidTemplateIDException {
        return this.templateProvider.getConnectionTemplate(templateID);
    }

    private ConnectionEntry aquireFreeEntry(int templateID) throws InvalidTemplateIDException, OutOfConnectionsException {
        ConnectionEntry entry = (ConnectionEntry)this.freeConnections.get(templateID);
        if (entry == null) {
            entry = this.addEntry(templateID);
        }
        this.seizeEntry(entry);
        return entry;
    }

    private void releaseUsedEntry(IConnection connection, boolean closeConnection) {
        ConnectionEntry entry = this.getUsedEntry(connection);
        if (entry != null) {
            this.releaseEntry(entry);
            try {
                this.restoreConnectionAttributes(entry);
            }
            catch (InvalidTemplateIDException e) {
                TRACE.catching("releaseUsedEntry(IConnection,boolean)", (Throwable)e);
                TRACE.debugT("releaseUsedEntry(IConnection,boolean)", "The requested connection template " + entry.templateID + " is invalid or has been removed.");
            }
        }
        if (closeConnection) {
            connection.close();
        }
    }

    private ConnectionEntry addEntry(int templateID) throws InvalidTemplateIDException, OutOfConnectionsException {
        ConnectionEntry entry = this.createEntry(templateID);
        this.increaseSize(templateID);
        return entry;
    }

    private void delFreeEntry(ConnectionEntry entry) {
        this.decreaseSize(entry.templateID);
        this.freeConnections.put(entry.templateID, entry.next);
        entry.connection = null;
        entry.next = null;
    }

    private void delUsedEntry(ConnectionEntry entry) {
        this.usedConnections.remove(entry.connection.hashCode());
        this.decreaseUsed(entry.templateID);
        this.decreaseSize(entry.templateID);
    }

    private void seizeEntry(ConnectionEntry entry) {
        this.usedConnections.put(entry.connection.hashCode(), entry);
        this.increaseUsed(entry.templateID);
        this.freeConnections.put(entry.templateID, entry.next);
    }

    private void releaseEntry(ConnectionEntry entry) {
        ConnectionEntry currentFree;
        this.usedConnections.remove(entry.connection.hashCode());
        this.decreaseUsed(entry.templateID);
        entry.next = currentFree = (ConnectionEntry)this.freeConnections.get(entry.templateID);
        this.freeConnections.put(entry.templateID, entry);
    }

    private void restoreConnectionAttributes(ConnectionEntry entry) throws InvalidTemplateIDException {
        IConnectionTemplate template = this.templateProvider.getConnectionTemplate(entry.templateID);
        entry.connection.setSocketReadTimeout(template.getSocketReadTimeout());
        entry.connection.setRequestRepetitions(template.getRequestRepetitions(), template.getRepeatOnTimeout());
    }

    private ConnectionEntry getUsedEntry(IConnection connection) {
        return (ConnectionEntry)this.usedConnections.get(connection.hashCode());
    }

    private ConnectionEntry createEntry(int templateID) throws InvalidTemplateIDException, OutOfConnectionsException {
        IConnectionTemplate template = this.getTemplate(templateID);
        if (template == null) {
            throw new InvalidTemplateIDException("The requested connection template " + templateID + " is unknown.");
        }
        this.checkCapacities(template, templateID);
        ConnectionEntry newEntry = new ConnectionEntry(templateID, new Connection(template));
        if (TRACE.beDebug()) {
            TRACE.debugT("createEntry(int)", "Connection pool entry created [{0}]", new Object[]{newEntry.toString()});
        }
        return newEntry;
    }

    private boolean checkCapacities(IConnectionTemplate template, int templateID) throws OutOfConnectionsException {
        boolean ok = this.checkCapacity();
        if (!ok) {
            this.compactFreeEntries();
        }
        if (!ok) {
            throw new OutOfConnectionsException("The pool size has reached the maximum number of connections [limit=" + this.limit + "]");
        }
        ok = this.checkCapacity(templateID);
        if (!ok) {
            throw new OutOfConnectionsException("The pool size has reached the maximum number of connections for destination '" + template.getUrl() + "' [template id=" + templateID + "]");
        }
        return true;
    }

    private boolean checkCapacity() {
        return this.limit < 0 || this.size < this.limit;
    }

    private boolean checkCapacity(int templateID) {
        int n = this.getLimit(templateID);
        n = n < 0 ? this.defaultLimit : n;
        return n < 0 || this.getSize(templateID) < n;
    }

    private void compactFreeEntries() {
        int[] keys = this.freeConnections.keys();
        int i = 0;
        while (i < keys.length) {
            ConnectionEntry entry = (ConnectionEntry)this.freeConnections.get(keys[i]);
            if (entry != null) {
                entry.connection.close();
                this.delFreeEntry(entry);
            }
            ++i;
        }
    }

    private void removeFreeEntries() {
        int[] keys = this.freeConnections.keys();
        if (keys != null) {
            int i = 0;
            while (i < keys.length) {
                this.removeFreeEntries(keys[i]);
                ++i;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void removeFreeEntries(int templateID, int num) {
        ConnectionEntry entry;
        while ((entry = (ConnectionEntry)this.freeConnections.get(templateID)) != null && num > 0) {
            void var3_3;
            this.delFreeEntry((ConnectionEntry)var3_3);
            --num;
        }
        this.freeConnections.remove(templateID);
    }

    /*
     * WARNING - void declaration
     */
    private void removeFreeEntries(int templateID) {
        ConnectionEntry entry;
        while ((entry = (ConnectionEntry)this.freeConnections.get(templateID)) != null) {
            void var2_2;
            this.delFreeEntry((ConnectionEntry)var2_2);
        }
        this.freeConnections.remove(templateID);
    }

    private void removeUsedEntries() {
        int[] keys = this.usedConnections.keys();
        if (keys != null) {
            int i = 0;
            while (i < keys.length) {
                ConnectionEntry entry = (ConnectionEntry)this.usedConnections.get(keys[i]);
                this.delUsedEntry(entry);
                ++i;
            }
        }
    }

    private void removeUsedEntries(int templateID) {
        int[] keys = this.usedConnections.keys();
        if (keys != null) {
            int i = 0;
            while (i < keys.length) {
                ConnectionEntry entry = (ConnectionEntry)this.usedConnections.get(keys[i]);
                if (entry.templateID == templateID) {
                    this.delUsedEntry(entry);
                }
                ++i;
            }
        }
    }

    private void increaseSize(int templateID) {
        int n = 0;
        try {
            n = this.sizes.get(templateID);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.sizes.put(templateID, n + 1);
        ++this.size;
    }

    private void decreaseSize(int templateID) {
        try {
            int n = this.sizes.get(templateID);
            this.sizes.put(templateID, n - 1);
            --this.size;
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    private void increaseUsed(int templateID) {
        int n = 0;
        try {
            n = this.countUsed.get(templateID);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.countUsed.put(templateID, n + 1);
    }

    private void decreaseUsed(int templateID) {
        try {
            int n = this.countUsed.get(templateID);
            this.countUsed.put(templateID, n - 1);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    private void monitor() {
        while (true) {
            HashMapIntObject hashMapIntObject = this.monitored;
            synchronized (hashMapIntObject) {
                try {
                    while (this.monitoring) {
                        this.monitored.wait(10000L);
                    }
                }
                catch (InterruptedException e) {
                    TRACE.infoT("monitorConnections()", "connection auto close monitor [stopped]");
                    return;
                }
                if (!this.monitoring) {
                    TRACE.infoT("monitorConnections()", "connection auto close monitor [stopped]");
                    return;
                }
                if (!this.monitored.isEmpty()) {
                    int[] keys = this.monitored.keys();
                    int i = 0;
                    while (i < keys.length) {
                        Connection conn = (Connection)this.monitored.get(keys[i]);
                        if (conn.hasExpired()) {
                            conn.close();
                            this.monitored.remove(keys[i]);
                        }
                        ++i;
                    }
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ConnectionEntry {
        public int templateID;
        public Connection connection;
        public ConnectionEntry next;

        public ConnectionEntry(int templateID, Connection connection) {
            this.templateID = templateID;
            this.connection = connection;
        }

        public String toString() {
            return "templateID=" + this.templateID + ", connID=" + Integer.toHexString(this.connection.hashCode());
        }
    }
}

